#define MIX_ATTRIBUTE_CPP_

#include "Attribute.h"

namespace MiX{
  template <class Char,class Traits,class XMLTraits>
  XMLString<Char,Traits,XMLTraits> Attribute<Char,Traits,XMLTraits>::toString(bool bIndent,int iIndentOffset)const{
    XMLString<Char,Traits> s(getName());
    s += XMLTraits::eq(); s += XMLTraits::dblquote();
    s += getValue(); s += XMLTraits::dblquote();
    return s;
  }
  
  template <class Char,class Traits,class XMLTraits>
  Attribute<Char,Traits,XMLTraits>& Attribute<Char,Traits,XMLTraits>::create(const XMLString<Char,Traits,XMLTraits>& key,const XMLString<Char,Traits,XMLTraits>& val,NodeContainer<Char,Traits,XMLTraits>& parent){
    Attribute* newattr = new Attribute<Char,Traits,XMLTraits>(key,val);
    parent.getChildren().push_back(newattr);
    newattr->setParent(parent);
    return *newattr;
  }
}
