// -*- mode: C++ -*-
#ifndef MIX_ATTRMAP_H_
#define MIX_ATTRMAP_H_

#include <vector>
#include "XMLString.h"
#include "misc.h"

namespace MiX{
  /**
   * Attribute̾ͤǼ뼭
   * 
   * vectorȤäƼ
   * ͤ˲äݻ롣
   */
  template <class Char,class Traits,class XMLTraits> 
  class AttrMap {
  public:
    MiX_Template_Typedef(Char,Traits,XMLTraits);
    typedef MiX_STD::pair<string_type,string_type> value_type;
    typedef MiX_STD::vector<value_type> container_type;
    typedef container_type::iterator iterator;
    typedef container_type::const_iterator const_iterator;
  private:
    container_type impl_;
    struct search_by_key{
      string_type key_;
      search_by_key(const string_type& key) : key_(key) { };
      bool operator()(const value_type& v){ return v.first==key_; }
    };

  public:
    /// 󥹥ȥ饯
    AttrMap(){ impl_.clear(); }
    /// ƥʤκǽǤ򼨤ƥ졼
    iterator begin() { return impl_.begin(); }
    /// ƥʤκǸǤΰĸ򼨤ƥ졼
    iterator end() { return impl_.end(); }
    /// ƥʤκǽǤ򼨤ƥ졼(const)
    const_iterator begin()const{ return impl_.begin(); }
    /// ƥʤκǸǤΰĸ򼨤ƥ졼(const)
    const_iterator end()const{ return impl_.end(); }
    /// ƥʤ˳ǼƤǿ
    size_t size()const{ return impl_.size(); }
    /// ƥʤɤ
    bool empty()const{ return impl_.empty(); }
    /// ƥʤͤɲä
    void insert(const value_type& data){ impl_.push_back(data); }
    /// ƥʤˤ
    void clear(){ impl_.clear(); }
    /// keyˤäǤ򸡺ƥ졼֤
    iterator find(const string_type& key){ 
      return find_if(begin(),end(),search_by_key(key));
    }
    /// keyˤäǤ򸡺ƥ졼֤(const)
    const_iterator find(const string_type key)const{ 
      return find_if(begin(),end(),search_by_key(key));
    }
    /// keyˤäƼǤ
    void erase(const string_type key){
      iterator it = find(key);
      if(it!=end()) impl_.erase(it);
    }
    /// keyˤäƼǤͤ
    string_type operator[](const string_type& key) const;
  };
}

#ifndef MIX_ATTRMAP_CPP_
#include "AttrMap.cpp"
#endif//MIX_ATTRMAP_CPP_

#endif
