#include <iostream>
#include <fstream>
#include <string>
#include <utility>
#include <map>

typedef std::map<std::string,std::string> PhoneBook;
typedef std::pair<std::string,std::string> Person;

std::string input(const char* prompt){
  std::string ret;
  std::cout << prompt << ": " << std::flush;
  std::cin >> ret;
  return ret;
}

char prompt(){
  std::string s = input("add/delete/find/list/clear/quit [a,d,f,l,c,q]");
  return s.at(0);
}

void outputPerson(const Person& per){
  std::cout << per.first << " : " << per.second << std::endl;
}

std::vector<std::string> parseCSVLine(std::string ln){
  std::vector<std::string> ret;
  std::string::iterator it = ln.begin();
  std::string::iterator first = it;
  std::string::iterator last = ln.end();
  while(it!=last){
    if(*it==',') {
      ret.push_back(std::string(first,it));
      first = ++it;
    }
    ++it;
  }
  ret.push_back(std::string(first,last));
  return ret;
}

PhoneBook loadFile(const char* fn){
  PhoneBook ret;
  std::ifstream fin(fn);
  if(!fin) return ret;
  std::string ln;
  std::getline(fin,ln);
  while(!fin.eof()){
    std::vector<std::string> v=parseCSVLine(ln);
    if(v.size()==0) continue;
    ret.insert(std::make_pair(v.at(0),v.at(1)));
    std::getline(fin,ln);
  }
  fin.close();
  return ret;
}

void error(const char* errmsg){
  std::cout << "Error: " << errmsg << std::endl;
}

void storeFile(const char* fn,const PhoneBook& pb){
  std::ofstream fout(fn);
  PhoneBook::const_iterator it = pb.begin();
  PhoneBook::const_iterator last = pb.end();
  for( ;it!=last;++it){
    fout << it->first << ',' << it->second << std::endl;
  }
  fout.close();
}

int main(){
  PhoneBook pb = loadFile("phonebook.xml");
  char cmd = '\0';
  while(cmd!='q'){
    cmd = prompt();
    switch(cmd){
    case 'a' : case 'A' : {
      std::string name = input("Name");
      if(pb.find(name) != pb.end()) error("already exists.");
      else {
	std::string phone = input("Phone");
	pb.insert(Person(name,phone));
      }
      break;
    }
    case 'd' : case 'D' : {
      std::string name = input("Name");
      PhoneBook::iterator it =  pb.find(name);
      if(it==pb.end()) error("not found.");
      else pb.erase(it);
      break;
    }

    case 'f' : case 'F' : {
      std::string name = input("Name");
      PhoneBook::iterator it = pb.find(name);
      if(it==pb.end()) error("not found.");
      else outputPerson(*it);
      break;
    }
    case 'l' : case 'L' : {
      std::cout << pb.size() << "entries:" << std::endl;
      for_each(pb.begin(),pb.end(),outputPerson);
      break;
    }
    case 'c' : case 'C' : {
      pb.clear();
      break;
    }
    // I
    case 'q' : case 'Q' : 
    default :
      break;
    }
  }
  storeFile("phonebook.xml",pb);
}
