//CUPPA:include=+
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>

#include "../src/MiX/DOM_Parser.h"
#include "../src/MiX/Document.h"
#include "../src/MiX/Element.h"
#include "../src/MiX/Attribute.h"
#include "../src/MiX/Text.h"

#define T(str) MiX::XMLString<char>( str )

//CUPPA:namespace=+
//CUPPA:namespace=-

class XPathTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(XPathTest);
//CUPPA:suite=+
  CPPUNIT_TEST(testSelect);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:
public:

  virtual void setUp() { /* initialize */ }
  virtual void tearDown() { /* terminate */ }

//CUPPA:decl=+
  void testSelect() {
    const char data[] = {
      "<?xml?>"
      "<Library xmlns=\"library_url\" xmlns:html=\"html_url\">"
      "<Book>"
      "<Name>All your base vol.1</Name>"
      "<Price>5000</Price>"
      "<Description>are <html:strong>belong</html:strong> to us</Description>"
      "</Book>"
      "<Book>"
      "<Name>All your base vol.2</Name>"
      "<Price>10000</Price>"
      "<Description><html:i>are belong to us</html:i></Description>"
      "</Book>"
    };
    MiX::DOM_Parser<char> parser;
    MiX::Document<char>* doc = parser.parse(data);
    // ȤꤢNodeListǤ⡣
    MiX::NodeList<char> lst = MiX::XPath<MiX::NodeList<char> >("/Book/Name")(*doc);
    CPPUNIT_ASSERT_EQUAL( 2, lst.size() );
    for(MiX::NodeList<char>::iterator it=lst.begin();it!=lst.end();++it) {
      CPPUNIT_ASSERT_EQUAL(MiX::Node_Element, (*it)->getType());
      MiX::Element<char>& el = dynamic_cast<MiX::Element<char>&>(**it);
      CPPUNIT_ASSERT_EQUAL( MiX::XMLString<char>("Name"), el.getName() );
    }
    delete doc;
  }
//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

const char DOM_ParserTest::data_[] = {
  "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
  "<!-- -->"
  "<TestSuite name=\"DOM_ParserTest\">"
  "<!-- This is test comment. -->"
  "<TestCase name=\"testParse\"/>"
  "This \nis \ntest \ntext."
  "</TestSuite>"
};


CPPUNIT_TEST_SUITE_REGISTRATION(DOM_ParserTest);
