// -*- mode: C++ -*-
#ifndef MiX_XMLSTRING_H_
#define MiX_XMLSTRING_H_

// Adlib/XMLString.h
// (C) Copyright KUBO,Yotaro.
// [o[W]
// 0.4.7
//   - Oo[W̃ev[gp[^̉ɖ߂
//   - IncludeGuard}N̕ύX

#include <string>
#include <iostream>

#include "config.h"

namespace MiX{

  template <class charT,class char_traits,class xml_traits> 
  class XMLString
    : public std::basic_string<charT,char_traits>{
    typedef std::basic_string<charT,char_traits> super_type;
    typedef XMLString<charT,char_traits,xml_traits> this_type;
  public:
    ///RXgN^
    explicit XMLString() : super_type() { };
    ///Rs[RXgN^
    XMLString(const this_type& str) : super_type(str){ };
    ///RXgN^
    XMLString(const charT* s,size_t n) : super_type(s,n){ };
    ///RXgN^
    XMLString(const charT* s) : super_type(s){ };
    ///RXgN^
    XMLString(size_t n, char c) : super_type(n,c){ };
    ///RXgN^
    XMLString(const super_type& src) : super_type(src){ };
  };
  /// CT[^
  template <class charT,class char_traits,class xml_traits>
  std::ostream& operator<<(std::ostream& os,const XMLString<charT,char_traits,xml_traits>& src) {
    os << src.c_str() ;  return os;
  }
}


#endif
