require File.dirname(__FILE__) + '/../test_helper'
require 'users_controller'

# Re-raise errors caught by the controller.
class UsersController; def rescue_action(e) raise e end; end

class UsersControllerTest < ActionController::TestCase
  # Be sure to include AuthenticatedTestHelper in test/test_helper.rb instead
  # Then, you can remove it from this and the units test.
  include AuthenticatedTestHelper

  fixtures :users

  def test_should_not_allow_signup_when_no_login
    assert_no_difference 'User.count' do
      create_user
      assert_response :redirect
    end
  end

  def test_should_allow_signup_when_no_users
    User.destroy_all
    assert_difference 'User.count' do
      create_user
      assert_response :redirect
    end
  end

  def test_should_require_login_on_signup
    login_as(:aaron)
    assert_no_difference 'User.count' do
      create_user(:login => nil)
      assert assigns(:user).errors.on(:login)
      assert_response :success
    end
  end

  def test_should_require_password_on_signup
    login_as(:aaron)
    assert_no_difference 'User.count' do
      create_user(:password => nil)
      assert assigns(:user).errors.on(:password)
      assert_response :success
    end
  end

  def test_should_require_password_confirmation_on_signup
    login_as(:aaron)
    assert_no_difference 'User.count' do
      create_user(:password_confirmation => nil)
      assert assigns(:user).errors.on(:password_confirmation)
      assert_response :success
    end
  end

  def test_should_not_require_email_on_signup
    login_as(:aaron)
    assert_difference 'User.count' do
      create_user(:email => nil)
      assert_nil assigns(:user).errors.on(:email)
      assert_response :redirect
    end
  end

  private
  def create_user(options = {})
    post(:create,
         :user => {
           :login => 'quire',
           :email => 'quire@example.com',
           :password => 'quire69',
           :password_confirmation => 'quire69'
         }.merge(options))
  end
end
