/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Main.java to edit this template
 */
package jp.synthtarou.midimixer.windows;

import jp.synthtarou.midimixer.libs.midi.MXTraceNumber;
import jp.synthtarou.midimixer.libs.midi.driver.MXMIDIDriverReceiver;

/**
 *\
 * @author YOSHIDA Shintarou
 */
public class MXLIBWindows {
    private boolean loaded  = false;

    public MXLIBWindows() {
        try {
            System.loadLibrary("MXLIB01");
            StartLibrary();
            loaded = true;
        }catch(Throwable e) {
            e.printStackTrace();
        }
    }
    
    public boolean isUsable() {
        return loaded;
    }
    
    static public MXMIDIDriverReceiver _receiver = null;
    
    public static void setReceiver(MXMIDIDriverReceiver receiver) {
        _receiver = receiver;
    }
    
    public native void StartLibrary();

    public native int InputDevicesRoomSize();
    public native String InputDeviceName(int device);
    public native String InputDeviceId(int device);
    public native boolean InputDeviceIsOpen(int device);

    public native boolean InputDeviceOpen(int device);
    public native boolean InputDeviceQueryOpen(int device);
    public native boolean InputDeviceWaitDoneOpening(int device, long timeout);
    public native boolean InputDeviceClose(int device);

    public native int OutputDevicesRoomSize();
    public native String OutputDeviceName(int device);
    public native String OutputDeviceId(int device);
    public native boolean OutputDeviceIsOpen(int device);

    public native boolean OutputDeviceOpen(int device);
    public native boolean OutputDeviceQueryOpen(int device);
    public native boolean OutputDeviceWaitDoneOpening(int device, long timeout);
    public native boolean OutputDeviceClose(int device);
    
    public native boolean OutputShortMessage(int port, int message);
    public native boolean OutputLongMessage(int port, byte[] data);

    static private void cbCallText(String text) {
        System.out.println("Text [" + text.toString() + "]");
    }

    static MXLIBWindows main = new MXLIBWindows();
    int microSynth = -1;

    static private void cbCallShortMessage(int port, int message) {
        if( _receiver != null) {
            _receiver.DoShortMessage(port, new MXTraceNumber(), message);
        }
    }

    static private void cbCallLongMessage(int port, byte[] data) {
        if( _receiver != null) {
            _receiver.DoLongMessage(port, new MXTraceNumber(), data);
        }
    }

    public void main2(String[] args) {
        try {
            int size = InputDevicesRoomSize();
            System.out.println("inputSize = " + size);
            for(int i = 0; i < size; ++ i) {
                String name = InputDeviceName(i);
                String id = InputDeviceId(i);
                System.out.println("inputName[" + i + "]=" + name);
                System.out.println("inputID[" + i + "]=" + id);
                InputDeviceQueryOpen(i);
                InputDeviceWaitDoneOpening(i, 1000);
                System.out.println("ReserveDone " + name);
            }

            int outsize = OutputDevicesRoomSize();
            System.out.println("outputSize = " + outsize);
            for(int i = 0; i < outsize; ++ i) {
                System.out.println("List "  + i + "/" + outsize);
                String name = OutputDeviceName(i);
                String id = OutputDeviceId(i);
                System.out.println("outputName[" + i + "]=" + name);
                System.out.println("outputID[" + i + "]=" + id);
                if (name.startsWith("Microsoft")) {
                    OutputDeviceQueryOpen(i);
                    OutputDeviceWaitDoneOpening(i, 1000);
                    System.out.println("ReserveDone " + name);
                }
            }

            long start = System.currentTimeMillis();
            while(true) {
                long spent = System.currentTimeMillis() - start;
                if (spent >= 20000) {
                    break;
                }
                int count = 0;
                for(int i = 0; i < outsize; ++ i) {
                    String name = OutputDeviceName(i);
                    if (name.startsWith("Microsoft")) {
                        System.out.println("Found Microsoft " + name);
                        OutputDeviceOpen(i);
                        microSynth = i;
                        System.out.println("microSynth = " + microSynth);
                    }
                    if (OutputDeviceWaitDoneOpening(i, 1000)) {
                        count ++;
                    }
                }
                if (count == 0) {
                    break;
                }
                try {
                    Thread.sleep(300);
                }catch(InterruptedException e) {
                }
            }
            System.out.println("-7");
        }catch(Throwable e){
            e.printStackTrace();;
        }
        try {
            Thread.sleep(300000);
        }catch(Exception e) {
            
        }
    }
 
    public static void main(String[] args) {
        MXLIBWindows.main.main2(args);
    }
}