/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.mx20patchbay;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import jp.synthtarou.midimixer.MXStatic;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.swing.JTableWithFooter;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MX20View_OLD extends javax.swing.JPanel {
    private static final MXDebugLines _debug = new MXDebugLines(MX20View_OLD.class);
    /**
     * Creates new form MXMidiChannelPanel
     */
    JTableWithFooter jTableChMapping;
    
    MX20Process _process;
    
    public MX20View_OLD(MX20Process process) {
        _process = process;

        initComponents();
        setMinimumSize(new Dimension(100, 100));

        jTableChMapping = new JTableWithFooter(jPanelChannelMapping);

        TableModel model = createTableModel();
        jTableChMapping.setModel(model);
        
        jCheckBoxUseRoute.setSelected(_process.isUsingThisRecipe());
        jTableChMapping.setEnabled(_process.isUsingThisRecipe());
        jTableChMapping.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                if (jTableChMapping.isEnabled()) {
                    jTableChMapping_MousePressed(evt);
                }
            }
        });
    }
    
    public void updateModel() {
        TableModel model = createTableModel();
        jTableChMapping.setModel(model);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jCheckBoxUseRoute = new javax.swing.JCheckBox();
        jPanelChannelMapping = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        jCheckBoxUseRoute.setText("Use This Recipe");
        jCheckBoxUseRoute.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxUseRouteActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        add(jCheckBoxUseRoute, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jPanelChannelMapping, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void jCheckBoxUseRouteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxUseRouteActionPerformed
        _process.setUsingThisRecipe(jCheckBoxUseRoute.isSelected());
        jTableChMapping.setEnabled(jCheckBoxUseRoute.isSelected());
    }//GEN-LAST:event_jCheckBoxUseRouteActionPerformed
  
    public void jTableChMapping_MousePressed(MouseEvent evt)
    {
        int row = jTableChMapping.rowAtPoint(evt.getPoint());
        int column = jTableChMapping.columnAtPoint(evt.getPoint());

        int port = column - 1;
        int delivery = MXStatic.TOTAL_PORT_COUNT - row - 1;

        if (port >= 0) {         
            try {
                MX20Data data = _process.getData();
                if (data.isEnabled(port, delivery) == false) {
                    data.set(port, delivery, true);
                }else {
                    data.set(port, delivery, false);
                }
                updateModel();
            }catch(Throwable e) {
                e.printStackTrace();
            }   
        }
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox jCheckBoxUseRoute;
    private javax.swing.JPanel jPanelChannelMapping;
    // End of variables declaration//GEN-END:variables

    public synchronized TableModel createTableModel() {
        DefaultTableModel model = new DefaultTableModel() {
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex > 0) {
                    return Boolean.class;
                }
                return String.class;
            }
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };

        String inName = "";
        String outName = "";;

        if (_process.isTypeInput()) {
            inName = "In-Device ";
            outName = "Internal ";
        }else {
            inName = "Internal ";
            outName = "Out-Device ";
        }
        model.addColumn("");
        
        for (int i = 0; i < MXStatic.TOTAL_PORT_COUNT; ++ i) {
            model.addColumn(inName + MXUtilMidi.nameOfPortShort(i));
        }
        
        for (int delivery = MXStatic.TOTAL_PORT_COUNT - 1; delivery >= 0; -- delivery) {
            Vector line = new Vector();
            line.add(outName + MXUtilMidi.nameOfPortShort(delivery));
            for (int port = 0; port < MXStatic.TOTAL_PORT_COUNT; ++ port) {
                if (_process.getData().isEnabled(port, delivery)) {
                    line.add(Boolean.TRUE);
                }else {
                    line.add(Boolean.FALSE);
                }
            }
            model.addRow(line);
        }
        return model;
    }
}
