/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.mx20patchbay;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jp.synthtarou.midimixer.MXStatic;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.swing.JTableWithColumnHeader;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MX20View extends javax.swing.JPanel {
    private static final MXDebugLines _debug = new MXDebugLines(MX20View.class);

    MX20Process _process;
    
    JTableWithColumnHeader jTable;
    JScrollPane jScrollPane;

    /**
     * Creates new form MX20View
     */
    public MX20View(MX20Process process) {
        initComponents();
        _process = process;
        jTable = new JTableWithColumnHeader();
        TableModel model = createTableModel();
        jTable.setModel(model);
        
        jTable.setEnabled(_process.isUsingThisRecipe());
        jTable.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                jTable_MousePressed(evt);
            }
        });
        jTable.addKeyListener(new KeyAdapter() {
            public void keyPressed(KeyEvent e){
                if (jTable.getSelectedRow() < 0) {
                    return;
                }
                if (e.getKeyCode() == KeyEvent.VK_ENTER
                 || e.getKeyCode() == KeyEvent.VK_SPACE) {
                    popupOpenOrClose(jTable.getSelectedRow());
                }
            }
        });   

        TableColumnModel columnModel = jTable.getTableHeader().getColumnModel();
        
        columnModel.getColumn(0).setPreferredWidth(100);
        columnModel.getColumn(0).setMinWidth(100);
        columnModel.getColumn(0).setMaxWidth(100);

        if (process.isTypeInput()) {
            columnModel.getColumn(1).setPreferredWidth(100);
            columnModel.getColumn(1).setMinWidth(100);
            columnModel.getColumn(1).setMaxWidth(100);
        }
        
        jScrollPane = new JScrollPane(jTable);
        jPanel1.add(jScrollPane);

        jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                int x = 1;
                int y = jTable.getSelectedRow();
                Rectangle rect = jTable.getCellRect(y, x, true);
                rect.y += jTable.getTableHeader().getHeight();
                jScrollPane.getVerticalScrollBar().scrollRectToVisible(rect);
            }
        });
        jCheckBoxUseRecipe.setSelected(process.isUsingThisRecipe());
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jCheckBoxUseRecipe = new javax.swing.JCheckBox();
        jPanel1 = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        jCheckBoxUseRecipe.setText("Use This Recipe");
        jCheckBoxUseRecipe.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxUseRecipeActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        add(jCheckBoxUseRecipe, gridBagConstraints);

        jPanel1.setLayout(new javax.swing.BoxLayout(jPanel1, javax.swing.BoxLayout.LINE_AXIS));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jPanel1, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void jCheckBoxUseRecipeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxUseRecipeActionPerformed
        _process.setUsingThisRecipe(jCheckBoxUseRecipe.isSelected());
    }//GEN-LAST:event_jCheckBoxUseRecipeActionPerformed

    public void setupViewFromModel() {
        TableModel model = createTableModel();
        jTable.setModel(model);
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox jCheckBoxUseRecipe;
    private javax.swing.JPanel jPanel1;
    // End of variables declaration//GEN-END:variables

    public synchronized TableModel createTableModel() {
        DefaultTableModel model = new DefaultTableModel() {
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };

        String inName;
        String outName;

        if (_process.isTypeInput()) {
            inName = "In ";
            outName = "Internal ";
        }else {
            inName = "Internal ";
            outName = "Out ";
        }
        model.addColumn("");
        model.addColumn("to " + outName);

        for (int port = 0; port < MXStatic.TOTAL_PORT_COUNT; ++ port) {
            Vector line = new Vector();
            line.add(inName + MXUtilMidi.nameOfPortShort(port));
            
            StringBuffer text = new StringBuffer();

            for (int delivery = 0; delivery < MXStatic.TOTAL_PORT_COUNT; ++ delivery) {
                if (_process.getData().isEnabled(port, delivery)) {
                    if (text.length() != 0) {
                        text.append(", ");
                    }
                    text.append(MXUtilMidi.nameOfPortShort(delivery));
                }
            }
            line.add(text.toString());
            model.addRow(line);
        }
        return model;
    }

    public class ListenerForOpenOrClose implements ActionListener {
        int portnumber;
        int targetnumber;
        boolean flag;

        public ListenerForOpenOrClose(int from, int target, boolean setflag) {
            portnumber = from;
            targetnumber = target;
            flag = setflag;
        }
        
        @Override
        public void actionPerformed(ActionEvent e) {
            MX20Data data = _process.getData();
            data.set(portnumber, targetnumber, flag);
            setupViewFromModel();
            jTable.getSelectionModel().setSelectionInterval(portnumber, portnumber);
        }
    }

    public void popupOpenOrClose(int port) {
        try {
            MX20Data data = _process.getData();
            JPopupMenu jpopup = new JPopupMenu();

            for (int i = 0; i < MXStatic.TOTAL_PORT_COUNT; ++ i) {
                boolean using = data.isEnabled(port, i);
                JCheckBoxMenuItem item;
                if (_process.isTypeInput()) {
                    item = new JCheckBoxMenuItem(MXUtilMidi.nameOfPortInput(i));
                }else {
                    item = new JCheckBoxMenuItem(MXUtilMidi.nameOfPortOutput(i));
                }
                if (using) {
                    item.setSelected(true);
                    item.addActionListener(new ListenerForOpenOrClose(port, i, false));
                }else {
                    item.addActionListener(new ListenerForOpenOrClose(port, i, true));
                }
                jpopup.add(item);
            }

            jpopup.show(jTable, jTable.getColumnModel().getColumns().nextElement().getWidth(), jTable.getRowHeight(0) * (port + 1));
        }catch(Throwable e) {
            e.printStackTrace();
        }   
    }

    public void jTable_MousePressed(MouseEvent evt)
    {
        int port = jTable.rowAtPoint(evt.getPoint());
        int column = jTable.columnAtPoint(evt.getPoint());

        if (port >= 0 && column == 1) {         
            popupOpenOrClose(port);
        }
    }
}
