/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.mx20patchbay;

import jp.synthtarou.midimixer.MXStatic;
import jp.synthtarou.midimixer.libs.MXDebugLines;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MX20Data {
    private static final MXDebugLines _debug = new MXDebugLines(MX20Data.class);
    
    boolean[][] _transPort;
    int _portCount;

    public MX20Data() {
        _portCount = MXStatic.TOTAL_PORT_COUNT;
        _transPort = new boolean[_portCount][_portCount];
    }

    public int portCount() {
        return _portCount;
    }
    
    public boolean isEnabled(int fromPort, int toPort) {
        if (fromPort < 0 || toPort  < 0) {
            return false;
        }
        return _transPort[fromPort][toPort];
    }
    
    public void set(int fromPort, int toPort, boolean trans) {
        _transPort[fromPort][toPort] = trans;
    }

    public void clear() {
        _transPort = new boolean[_portCount][_portCount];
    }
    
}
