/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.mx11vcurve;

import javax.swing.JPanel;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import jp.synthtarou.midimixer.libs.midi.MXMidi;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MX11Process extends MXReceiver {
    MX11Data _data;
    MX11View _view;
    int _type;

    public MX11Process() {
        _data = new MX11Data();
        _view = new MX11View(this);
    }
    
    public MX11Data getData() {
        return _data;
    }

    @Override
    public void processMXMessage(MXMessage message) {
        if (isUsingThisRecipe() == false) { sendToNext(message); return; }

        if (message.getCommand() == MXMidi.COMMAND_NOTEON) {
            int port = message.getPort();
            int velocity = message.getGate();
            int newVelocity = _data.transform(port, velocity);
            if (velocity == newVelocity) {
                sendToNext(message);
            }else {
                int channel = message.getChannel();
                int note = message.getGate();
                MXMessage newMessage = MXMessageFactory.fromShortMessage(port, message._traceNumber, MXMidi.COMMAND_NOTEON + channel, note, newVelocity);
                sendToNext(newMessage);
            }
        }else {
            sendToNext(message);
        }
    }

    @Override
    public String getReceiverName() {
        return "Velocity Curve";
    }

    @Override
    public JPanel getReceiverView() {
        return _view;
    }
}
