/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs.swing;

import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;

/**
 *
 * @author YOSHIDA Shintarou
 */

public class MXFocusGroup {
    Component _focusedControl = null;
    boolean _checkEnable = false;
    ArrayList<MXFocusGroupElement> _groupMember = new ArrayList();

    public void attach(Component c) {
        if (c instanceof MXFocusAble) {
            _groupMember.add(new MXFocusGroupElement(this, c));
        }else {
            throw new IllegalArgumentException("Component is not MXFocusAble");
        }
    }

    public void detach(MXFocusAble c) {
        Iterator<MXFocusGroupElement> it = _groupMember.iterator();
        while(it.hasNext()) {
            MXFocusGroupElement e = it.next();
            if (e._root == c) {
                it.remove();
                return;
            }
        }
    }

    void comingFocus(Component c) {
        if (c != _focusedControl) {
            if (_focusedControl != null) {
                if (_focusedControl instanceof MXFocusAble) {
                    MXFocusAble f = (MXFocusAble)_focusedControl;
                    f.focusStatusChanged(false);
                }
                _focusedControl = null;
            }
            _focusedControl = c;
            if (c != null) {
                if (c instanceof MXFocusAble) {
                    MXFocusAble f = (MXFocusAble)c;
                    f.focusStatusChanged(true);
                }
            }
        }
    }
    
    void doDoubleCheck() {
        for (MXFocusGroupElement t : _groupMember) {
            if (t.checkMouseInTarget()) {
                comingFocus(t._root);
                return;
            }
        }
        comingFocus(null);
    }

    public void setFocusEnabled(boolean flag) {
        _checkEnable = flag;
        for (MXFocusGroupElement member : _groupMember) {
            for (Component c : member._element) {
                MouseListener[] listM = c.getMouseListeners();
                int mouseListenterCount = 0, required = 0;               
                for (int i = 0; i < listM.length; ++ i) {
                    MouseListener m = listM[i];
                    if (m == member) {
                        mouseListenterCount ++;
                        break;
                    }
                }
                required ++;
                if (mouseListenterCount != required) {
                    member.uninstallAll();
                    member.installAllRecursible(c);
                    break;
                }
            }
        }
        comingFocus(null);
    }
    
    public boolean isFocusEnabled() {
        return _checkEnable;
    }
    
    public Component getFocus() {
        return _focusedControl;
    }
}
