/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs.swing;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class CheckBoxListCellRenderer extends JCheckBox implements ListCellRenderer, MouseListener {
    JList _list;
    
    public CheckBoxListCellRenderer() {
    }

    public void bind(JList list) {
        if (_list != null) {
            throw new Error("aho");
        }
        _list = list;
        list.setCellRenderer(this);
        list.addMouseListener(this);
    }
    @Override
    public Component getListCellRendererComponent(
      JList list,
      Object value,
      int index,
      boolean isSelected,
      boolean cellHasFocus){

      JCheckBox checkBox = (JCheckBox)value;
      setText(checkBox.getText());
      setSelected(checkBox.isSelected());

      return this;
    }

    @Override
    public void mouseClicked(MouseEvent e){
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point p = e.getPoint();

        int index = _list.locationToIndex(p);

        JCheckBox checkBox = (JCheckBox)_list.getModel().getElementAt(index);
        if (checkBox.isSelected()){
            checkBox.setSelected(false);
        }else{
            checkBox.setSelected(true);
        }
        //_list.setSelectedIndex(index);
        _list.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}
