/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs.midi.programlist.database;

import java.util.ArrayList;
import jp.synthtarou.midimixer.libs.midi.programlist.GMFile;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class PDFileManager {
    static final PDFileManager _manager = new PDFileManager();

    ArrayList<PDFile> _listXML;

    protected PDFileManager() {
        _listXML = new ArrayList();
        _listXML.add(new GMFile());
    }
    
    public static PDFileManager getManager() {
        return _manager;
    }
    
    public void register(PDFile file) {
        for (PDFile xml : _listXML) {
            if (xml.getName().equals(file.getName())) {
                return;
            }
        }
        try {
            _listXML.add(file);
        }catch(Throwable e){
            e.printStackTrace();;
        }
    }
    
    public void unregist(String name) {
        for (PDFile xml : _listXML) {
            if (xml.getName().equals(name)) {
                _listXML.remove(xml);
                return;
            }
        }
    }
    
    public PDFile get(int x) {
        return _listXML.get(x);
    }

    public int size() {
        return _listXML.size();
    }
}
