/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs.midi.port;

import javax.swing.JPanel;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;

/**
 *
 * @author YOSHIDA Shintarou
 */

public class FinalMIDIOut extends MXReceiver {
    private static final MXDebugLines _debug = new MXDebugLines(FinalMIDIOut.class);

    protected static final FinalMIDIOut _instance = new FinalMIDIOut();
    
    public static FinalMIDIOut getInstance() {
        return _instance;
    }

    @Override
    public void processMXMessage(MXMessage message) {
        //if (usingThis() == false) { sendToNext(message); return; }
        MXMIDIOut out = MXMIDIOutManager.getManager().findMIDIOutput(message.getPort());
        if (out == null) {
            //_debug.println("output not assigned");
            return;
        }
        if (out.isOpen() == false) {
            //_debug.println("output not opened");
            return;
        }
        out.processMidiOut(message);
    }

    @Override
    public String getReceiverName() {
        return "Dispatch To Device";
    }

    @Override
    public JPanel getReceiverView() {
        return null;
    }
}
