/*
 * Copyright 2023 user0001.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs.midi.driver;

/**
 *
 * @author YOSHIDA Shintarou
 */
public interface MXMIDIDriver {
    public boolean isUsable();
    public void StartLibrary();

    public int InputDevicesRoomSize();
    public String InputDeviceName(int device);
    public String InputDeviceId(int device);
    public boolean InputDeviceIsOpen(int device);

    public boolean InputDeviceOpen(int device);
    public boolean InputDeviceQueryOpen(int device);
    public boolean InputDeviceWaitDoneOpening(int device, long timeout);
    public boolean InputDeviceClose(int device);
    
    public void InputSetReceiver(MXMIDIDriverReceiver receiver);

    public int OutputDevicesRoomSize();
    public String OutputDeviceName(int device);
    public String OutputDeviceId(int device);
    public boolean OutputDeviceIsOpen(int device);

    public boolean OutputDeviceOpen(int device);
    public boolean OutputDeviceQueryOpen(int device);
    public boolean OutputDeviceWaitDoneOpening(int device, long timeout);
    public boolean OutputDeviceClose(int device);
    
    public boolean OutputShortMessage(int port, int message);
    public boolean OutputLongMessage(int port, byte[] data);
}
