/*
 * Copyright 2023 user0001.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs.midi.driver;

import jp.synthtarou.midimixer.libs.MultiThreadQueue;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXMIDIDevice {
    class OutputElement {
        public OutputElement(int dword) {
            _dword = dword;
            _isBinary = false;
        }
        public OutputElement(byte[] data) {
            _data = data;
            _isBinary = true;
        }
        boolean _isBinary = false;
        int _dword;
        byte[] _data;
    }
    
    class OutputThread implements Runnable {
        MultiThreadQueue<OutputElement> _queue = new MultiThreadQueue<>();
        boolean _finish = false;
        
        public OutputThread() {
            
        }

        public void push(OutputElement elem) {
            _queue.push(elem);
        }
        
        public void run() {
            try {
                Thread.currentThread().setPriority(Thread.MAX_PRIORITY);
            }catch(Throwable ex) {
                ex.printStackTrace();;
            }
            while(true) {
                OutputElement e = _queue.pop();
                if (e == null) {
                    //System.out.println("Done. Thread.");
                    return;
                }
                try {
                    if (e._isBinary) {
                        _driver.OutputLongMessage(_deviveNumber, e._data);
                    }else  {
                        _driver.OutputShortMessage(_deviveNumber, e._dword);
                    }
                }catch(Throwable ex) {
                    ex.printStackTrace();
                }
            }
        }
        
        public void quit() {
            _queue.quit(); // poo() -> maybe null
        }                
    }
    
    public MXMIDIDevice(MXMIDIDriver driver, boolean isInput, int deviveNumber) {
        _driver = driver;
        _isInput = isInput;
        _deviveNumber = deviveNumber;
    }
    
    /**
     * @return the driver
     */
    private MXMIDIDriver getDriver() {
        return _driver;
    }

    /**
     * @return the device
     */
    private int getDeviceNumber() {
        return _deviveNumber;
    }

    int _deviveNumber;
    MXMIDIDriver _driver;
    boolean _isInput;
    OutputThread _outputThread = null;
    boolean _tryThread = false;
    
    public void open() {
        if (_isInput) {
            _driver.InputDeviceOpen(_deviveNumber);
        }else {
            _driver.OutputDeviceOpen(_deviveNumber);
            if (_tryThread) {
                _outputThread = new OutputThread();
                new Thread(_outputThread).start();
            }
        }
    }

    public void setInputReceiver(MXMIDIDriverReceiver receiver) {
        _driver.InputSetReceiver(receiver);
    }
    
    public void close() {
        if (_isInput) {
            _driver.InputDeviceClose(_deviveNumber);
        }else {
            _driver.OutputDeviceClose(_deviveNumber);
            if (_outputThread != null) {
                _outputThread.quit();
            }
        }
    }

    public boolean isOpen() {
        if (_isInput) {
            return _driver.InputDeviceIsOpen(_deviveNumber);
        }else {
            return _driver.OutputDeviceIsOpen(_deviveNumber);
        }
    }
    
    public String getName() {
        if (_isInput) {
            return _driver.InputDeviceName(_deviveNumber);
        }else {
            return _driver.OutputDeviceName(_deviveNumber);
        }
    }
    
    public void OutputShortMessage(int dword) {        
        if (_isInput) {
        }else if (_outputThread != null) {
            _outputThread.push(new OutputElement(dword));
        }else {
            if (_driver.OutputDeviceIsOpen(_deviveNumber) == false) {
                new IllegalStateException().printStackTrace();
            }
            _driver.OutputShortMessage(_deviveNumber, dword);
        }   
    }

    public void OutputLongMessage(byte[] data) {        
        if (_isInput) {
        }else if (_outputThread != null) {
            _outputThread.push(new OutputElement(data));
        }else {
            _driver.OutputLongMessage(_deviveNumber, data);
        }
    }
    
    synchronized void OutputInternal(OutputElement elem) {
        if (elem._isBinary) {
            _driver.OutputLongMessage(_deviveNumber, elem._data);
        }else {
            _driver.OutputShortMessage(_deviveNumber, elem._dword);
        }
    }
}
