/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs.midi.capture;

import java.util.TreeMap;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXMessageTemplate;
import jp.synthtarou.midimixer.libs.midi.MXTraceNumber;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXMessageCapture {
    TreeMap<String, TextInformation> _captureData = new TreeMap();

    public MXMessageCapture() {
    }
    
    public void clear() {
        _captureData = new TreeMap();
        age = 0;
    }
    
    public int age = 0;
    
    public void process(MXMessage message) {
        int channel = message.getChannel();
        int gate = message.getGate();
        int value = message.getValue();
        String dtext = message.toDText();

        synchronized(this) {
            TextInformation textNode = _captureData.get(dtext + channel);
            if (textNode == null) {
                textNode = new TextInformation();
                textNode.dtext = dtext;
                textNode.command = message.getCommand();
                textNode.channel = message.getChannel();
                age ++;
                _captureData.put(dtext + message.getChannel(), textNode);
            }

            GateInfomation gateNode = textNode.listGateValues.get(gate);
            if (gateNode == null) {
                gateNode = new GateInfomation();
                gateNode._gate = gate;
                gateNode._maxValue = value;
                gateNode._minValue = value;
                gateNode._parent = textNode;
                textNode.listGateValues.put(gate, gateNode);
                age ++;
                return;
            }
            if (gateNode._minValue > value) {
                gateNode._minValue = value;
                age ++;
            }
            if (gateNode._maxValue < value) {
                gateNode._maxValue = value;
                age ++;
            }
            notifyAll();
        }
    }
    
    public int getAge() {
        return age;
    }

    public String nameOf(GateInfomation gate) {
        TextInformation text = gate._parent;

        //MXMessage messageMin = MXMessageFactory.fromDtext(text.dtext, gate._gate, gate._minValue);
        int port = 0;
        MXMessageTemplate template = MXMessageFactory.fromDtext(text.dtext, gate._parent.channel);
        MXMessage message = template.bind(null, 0, 0, 0);

        return  message.toStringHeader(gate._minValue, gate._maxValue);
    }
    
    public MXWrapList<GateInfomation> createListModel() {
        synchronized(this) {
            MXWrapList<GateInfomation> list = new MXWrapList<>();

            TreeMap<String, TextInformation> capture = _captureData;
            for (TextInformation text : capture.values()) {
                for (GateInfomation gate : text.listGateValues.values()) {
                    list.addNameAndValue(nameOf(gate), gate);
                }
            }
            return list;
        }
    }
}
