/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs.midi;

import javax.swing.JComponent;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.libs.MXDebugLines;

/**
 *
 * @author YOSHIDA Shintarou
 */
public abstract class MXReceiver {
    private static final MXDebugLines _debug = new MXDebugLines(MXReceiver.class);
    private static MXMain _lock = MXMain.getMain();
    
    public abstract String getReceiverName();

    public abstract JComponent getReceiverView();
    
    private MXReceiver _nextReceiver;

    public final MXReceiver getNextReceiver() {
        return _nextReceiver;
    }

    public void setNextReceiver(MXReceiver next) {
        _nextReceiver = next;
    }
    
    public abstract void processMXMessage(MXMessage message);
    
    /* implements like following
     *      public void processMXMessage(MXMessage message) {
     *          if (usingThis() == false) {
     *              sendToNext(message);
     *              return;
     *          }
     *      .......
    */
    public void sendToNext(MXMessage message) {
        if (_nextReceiver != null) {
            synchronized(_lock) {
                _nextReceiver.processMXMessage(message);
                //if (message.isDataentry() && message.getVisitant().getDataentryValue14() == 0 && message._trace == null) { message._trace = new Throwable(); }
            }
        }else {
            _debug.println("receiver not set " + message);
            _debug.printStackTrace();
        }
    }

    boolean _usingThis = true;
    
    public final boolean isUsingThisRecipe() {
        return _usingThis;
    }

    public final void setUsingThisRecipe(boolean usingThis) {
        _usingThis = usingThis;
    }
}
