/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs.logview;

import java.util.ArrayList;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXLogViewMidiRenderer /*extends MXLogViewRenderer */{
/*    public static final int MODE_SHORT = 1;
    public static final int MODE_BINARY = 2;
    public static final int MODE_DTEXT = 3;
    public static final int MODE_FORMAT = 4;
    
    public synchronized static MXWrapList<Integer> getModeDataModel() {
        MXWrapList<Integer> model = new MXWrapList();
        model.addNameAndValue("Binary", MODE_BINARY);
        model.addNameAndValue("Short", MODE_SHORT);
        model.addNameAndValue("D-Text", MODE_DTEXT);
        model.addNameAndValue("Binary + Short", MODE_FORMAT);
        return model;
    }
    
    public synchronized void setMode(int mode) {
        _mode = mode;
    }

    String _title;
    int _mode = MODE_SHORT;
    
    public MXLogViewMidiRenderer(String title) {
        _title = title;
    }

    public String dumpDWord(int code) {
        int status = (code >> 16) & 0xff;
        int data1 = (code >> 8) & 0xff;
        int data2 = (code) & 0xff;
        
        return MXUtil.toHexFF(status) + "," + MXUtil.toHexFF(data1) + "," + MXUtil.toHexFF(data2);
    }
    
    public String format(Object value) {
        String text = "";
        MXMessage message = (MXMessage)value;
        ArrayList darray = message.toDArray();
        String dtext = darray.toString();
        
        if (darray.contains("#GL") || darray.contains("#GH")) {
            dtext = dtext + " gate=" + message.getGate();
        }
        if (darray.contains("#VL") || darray.contains("#VH")) {
            dtext = dtext + " value=" + message.getValue();
        }
        
        String portText = "[" + MXUtilMidi.nameOfPortShort(message.getPort());
        if (message.isMessageTypeChannel()) {
            portText = portText + message.getChannel();
        }
        portText += "] ";
        
        String title = _title + " ";
        String shortText = message.toString();
        String bit14or = "";

        if (message.isValue14bit()) {
            bit14or += " - 14bit";
        }

        ArrayList<String> dump = new ArrayList();

        if (message.isMessageTypeDataentry()) {
            if (message.getVisitant() != null) {
                MXVisitant visit = message.getVisitant();
                if (visit.isHaveDataentryRPN()) {
                    bit14or += "RPN [" + MXUtil.toHexFF(visit.getDataentryMSB()) + ":" + MXUtil.toHexFF(visit.getDataentryLSB()) + "]";
                }else if (visit.isHaveDataentryNRPN()) {
                    bit14or += "NRPN [" + MXUtil.toHexFF(visit.getDataentryMSB()) + ":" + MXUtil.toHexFF(visit.getDataentryLSB()) + "]";
                }
            }
        }

        int dwordlen = message.getDwordCount();
        if (dwordlen > 0)  {
            for (int i = 0; i < dwordlen; ++ i) {
                dump.add(dumpDWord(message.getAsDword(i)));
            }
        }else {
            byte[] data = message.getDataBytes();
            dump.add(MXUtil.dumpHexFF(data));
        }
        
        switch(_mode) {
            case MODE_SHORT:
                text = title + shortText + bit14or;
                break;
            case MODE_BINARY:
                text = title + portText + " " + dump.toString() + " " + bit14or;
                break;
            case MODE_DTEXT:
                text = title + portText + dtext +bit14or;
                break;
            case MODE_FORMAT:
                text = title + portText + " '" + dump.toString()+ "' = " + shortText + bit14or; 
                break;
            default:
                text = "ERROR";
                break;
        }

        return text;
     }*/
 }
