/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs;

import java.util.LinkedList;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MultiThreadQueue<T> {
    private static final MXDebugLines _debug = new MXDebugLines(MultiThreadQueue.class);

    LinkedList<T> _queue;
    boolean _quit;
    
    public MultiThreadQueue() {
        _queue = new LinkedList<T>();
        _quit = false;
    }
    
    public synchronized void push(T obj) {
        _queue.add(obj);
        notifyAll();
    }
    
    public synchronized T pop() {
        while(true) {
            while (_queue.isEmpty() && !_quit) {
                try {
                    wait(100);
                }catch(InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (!_queue.isEmpty()) {
                T value = _queue.removeFirst();
                return value;
            }
            if (_quit) {
                return null;
            }
        }
    }
    
    public synchronized void quit() {
        try {
            _quit = true;
            notifyAll();
        }catch(Throwable e) {
            e.printStackTrace();
        }
    }
    
    public static void main(String[] args) {
        MXDebugLines.globalSwitchOn();
        final MultiThreadQueue<Integer> que = new MultiThreadQueue<Integer>();
        new Thread(new Runnable() {
            public void run() {
                while(true) {
                    try {
                        Integer value = que.pop();
                        if (value == null) {
                           _debug.println("Thread burn!");
                           que.quit();
                           break;
                        }
                        _debug.println("Thread got " + value);
                        if (value == 100) {
                           _debug.println("Thread bingo!");
                           que.quit();
                           break;
                        }
                        try {
                            Thread.sleep(70);
                        } catch (InterruptedException ex) {
                            _debug.printStackTrace(ex);
                        }
                    }catch(Throwable ex) {
                        _debug.printStackTrace(ex);
                    }
                }
            }
        }).start();
        new Thread(new Runnable() {
            public void run() {
                for (int i = 0; i <= 100; ++ i) {
                    que.push(i);
                    try {
                        Thread.sleep(60);
                    } catch (InterruptedException ex) {
                        _debug.printStackTrace(ex);
                    }
                }
            }
        }).start();;
        
        while(true) {
            Integer value = que.pop();
            if (value == null) {
                _debug.println("Main burn!");
                que.quit();
                break;
            }
            _debug.println("Main got " + value);
            if (value == 100) {
                _debug.println("Main bingo!");
                que.quit();
                break;
            }
            try {
                Thread.sleep(70);
            } catch (InterruptedException ex) {
                _debug.printStackTrace(ex);
            }
        }
    }
}
