/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXLineWriter {
    OutputStream _fout;
    PrintWriter _writer;
    
    String _charset;
   
    public MXLineWriter(File file, String charset) throws IOException {
        _fout = new FileOutputStream(file);
        try {
            _writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(_fout, charset)));
        }catch(IOException ioe) {
            try {
                _fout.close();
            }catch(IOException e) {
            }
            _fout = null;
            throw ioe;
        }
        _writer.println("#charset=" + charset);
    }
    
    public void close() throws IOException {
        if (_writer != null) {
            _writer.flush();
            _writer.close();
            _writer = null;
        }
    }
    
    public void println(String text) {
        _writer.println(text);
    }

    public PrintWriter getWriter() {
        return _writer;
    }
    
}
