/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXLineReader {
    InputStream _in;
    String _charset;
    byte[] _buffer;
    int _pos;
    int _bufferSize;
    
    public MXLineReader(InputStream in) {
        this(in, "utf-8");
    }
    public MXLineReader(InputStream in, String charset) {
        _in = in;
        _charset = charset;
        _buffer = new byte[4096];
        _pos = 0;
        _bufferSize = 0;
    }
    
    protected boolean fetchIfNeed() throws IOException {
        if (_pos >= _bufferSize) {
            int newSize = _in.read(_buffer, 0, _buffer.length);
            if (newSize <= 0) {
                return false;
            }
            _bufferSize = newSize;
            _pos = 0;
        }
        return true;
    }
    
    public String readLine() throws IOException {
        byte[] line = new byte[256];
        int x = 0;
        
        do {
            if (_pos >= _bufferSize && fetchIfNeed() == false) {
                break;
            }
            byte ch = _buffer[_pos ++ ];
            if (ch == '\r') continue;
            if (ch == '\n') break;
            line[x ++] = ch;
            if (x >= line.length) {
                byte[] newLine = new byte[line.length * 2];
                System.arraycopy(line, 0, newLine, 0, line.length);
                line = newLine;
            }
        }while(true);
        
        if (x == 0 && _pos >= _bufferSize) {
            return null;
        }
        
        String text = new String(line, 0, x, "ASCII");
        try {
            if (text.startsWith("#charset=")) {
                try {
                    String newCharset = text.substring(9);
                    Charset.forName(newCharset);
                    _charset = newCharset;
                }catch(Exception e) {
                    
                }
            }
            text = new String(line, 0, x, _charset);
        }catch(Exception e) {
        }
        return text;
    }
}
