/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer;

import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.SwingUtilities;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.MXUtil;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXVersionDialog extends javax.swing.JDialog {
    private static final MXDebugLines _debug = new MXDebugLines(MXVersionDialog.class);

    public static MXVersionDialog showAsModal(Frame parent) {
        MXVersionDialog dialog = new MXVersionDialog(parent, true);
        dialog.setTitle("Thank YOU for Trial");
        dialog.setAlwaysOnTop(true);
        dialog.pack();
        dialog.setSize(500, 400);
        MXUtil.centerWindow(dialog);
        dialog.setVisible(true);
        return dialog;
    }

    public MXVersionDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        jProgressBar1.setMinimum(0);
        StringBuffer text = new StringBuffer();
        text.append(MXStatic.MX_APPNAME_WITH_VERSION + "\n");
        text.append("\n");
        text.append("V0.16 beta fixed mixer component\n");
        text.append("V0.15 Visitant Architecture, Dataentry Input\n");
        text.append("V0.14 MouseWheel, ControllerSize\n");
        text.append("V0.13 Sequencer RealTime Tuning\n");
        text.append("V0.12 Template for CC Picker\n");
        text.append("V0.11 (Pre) Support DATAENTRY / 14bit\n");
        text.append("V0.10 Support 14 bit CC\n");
        text.append("V0.09 More Humanic Interface\n");
        text.append("V0.08 Drum Pad + Sequence + Chord\n");
        text.append("V0.07 Drum Pad + 0.1\n");
        text.append("V0.06 CC Mixer Chain\n");
        text.append("V0.05 supported Drum Pad\n");
        text.append("V0.04B supported SysEX Checksum\n");
        jTextArea1.setText(text.toString());
        jTextArea1.setEditable(false);
        jProgressBar1.setIndeterminate(true);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();
        jProgressBar1 = new javax.swing.JProgressBar();
        jButton1 = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("I wish you have fun.");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        getContentPane().add(jLabel1, gridBagConstraints);

        jTextArea1.setColumns(20);
        jTextArea1.setRows(5);
        jScrollPane1.setViewportView(jTextArea1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(jScrollPane1, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(jProgressBar1, gridBagConstraints);

        jButton1.setText("OK");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        getContentPane().add(jButton1, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        setVisible(false);
    }//GEN-LAST:event_jButton1ActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JProgressBar jProgressBar1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea jTextArea1;
    // End of variables declaration//GEN-END:variables

}
