/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package jp.synthtarou.midimixer.libs.midi.smf;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class SMFMessageList {
    TreeSet<SMFMessage> _set = new TreeSet<SMFMessage>();
    SMFParser _file;
    
    public SMFMessageList(SMFParser file) {
        _file = file;
    }
    
    public void add(SMFMessage message) {
        _set.add(message);
    }

    public void  dump() {
        for (SMFMessage message : _set) {
            System.out.println(message);
        }
    }
    
    /*
    public SMFMessage firstTempo() {
        List<SMFMessage> list = listTempo();
        if (list != null && list.size() >= 1) {
            SMFMessage message = list.get(0);
            if (message._tick == 0) {
                return message;
            }
        }
        return null;
    }*/

    public ArrayList<SMFMessage> listAll() {
        ArrayList<SMFMessage> list = new ArrayList();
        list.addAll(_set);
        return list;
    }
    
    public List<SMFMessage> listTempo() {
        ArrayList<SMFMessage> ret = new ArrayList();
        for (SMFMessage message : _set) {
            if (message.getStatus() == 0xff) {
                switch(message.getData1()) {
                    case 0: // シーケンス番号
                    case 1: // テキストイベント
                    case 2: // 著作権情報
                    case 3: // シーケンス名・トラック名
                    case 4: // 楽器名
                    case 5: // 歌詞
                    case 6: // マーカー
                    case 7: // キューポイント
                    case 0x20: //MIDIチャンネルプリフィクス
                    case 0x2f: //END
                    case 0x54: //SNMPTE OFFSEt
                    case 0x58: //メトロノーム
                    case 0x59: //調合
                    case 0x75: //シーケンサメタ
                        break;
                    case 0x51: //Tempo
                        ret.add(message);
                }
            }
        }
        return ret;
    }

    public int size() {
        return _set.size();
    }
}
