/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs.midi.programlist.database;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class PDBank implements DoubleIndexElement {
    int _bankMSB;
    int _bankLSB;
    String _bankName;
    PDProgram _parent;
    PDDrumSet _drumSet;

    public PDBank(PDProgram parent, int msb, int lsb, String name) {
        _parent = parent;
        _bankMSB = msb;
        _bankLSB = lsb;
        _bankName = name;
    }
    
    public int getBankMSB() {
        return _bankMSB;
    }

    public int getBankLSB() {
        return _bankLSB;
    }
    
    public String getName() {
        return _bankName;
    }

    public int getId() {
        return _bankMSB << 8 | _bankLSB;
    }
    
    public PDDrumSet smartReserve(PDDrumSet set) {
        if (_drumSet == null) {
            if (set == null) {
                set = new PDDrumSet();
            } 
            _drumSet = set; 
        }
        return _drumSet;
    }
    
    public PDDrumSet getDrum() {
        return _drumSet;
    }
}
