/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs.midi.programlist;

import jp.synthtarou.midimixer.libs.midi.programlist.database.PDModule;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.MXLineReader;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDBank;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDMap;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDProgram;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class GMLevel1 extends PDModule {
    private static final MXDebugLines _debug = new MXDebugLines(GMLevel1.class);
    
    public GMLevel1() {
        super("System Default");
        try {
            InputStream stream = GMLevel1.class.getResourceAsStream("GMLevel1.csv");
            readCSV(stream, "Shift_JIS");
            stream.close();
        }catch(Exception e) {
        }
    }
    
    public void readCSV(InputStream stream, String charset) {
        MXLineReader reader = new MXLineReader(stream, charset);
        String line;
        String folder = "";
        int folderId = 0;
        ArrayList<String> cells = new ArrayList();
        
        try {
            while( (line = reader.readLine()) != null ) {
                if (line.startsWith("#")) {
                    folder = line.substring(1);
                    folderId ++;
                    continue;
                }

                MXUtil.split(line, cells, ',');

                if (cells.size() >= 4) {
                    try {
                        String dispCode = cells.get(0);
                        String numberHex = cells.get(1);
                        String nameEnglish = cells.get(2);
                        String nameLocalized = cells.get(3);

                        int programNumber = MXUtil.parseTextForNumber(dispCode) - 1; 
                        
                        PDModule pdmodule = this;
                        PDMap pdmap = pdmodule.smartReserve(getName());
                        PDProgram pdprogram = pdmap.smartReserve(programNumber, nameEnglish);
                        PDBank pdbank = pdprogram.smartReserve(-1, -1, nameEnglish);

                    }catch(Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        }catch(IOException e) {
            e.printStackTrace();;
        }
    }
}
