/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs.domino;

import jp.synthtarou.midimixer.libs.MXDOMElement;
import java.awt.Color;
import java.util.List;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class DTextMessage {
    public DTextMessage() {
    }

    public DTextMessage(String name, String text, int gate) {
        _name = name;
        _dataText = text;
        _gate = gate;
    }

    int _id = -1; /* from 0 to 1300 */
    String _name = "";
    Color _color = Color.black;
    int _sync; /* 0: None1: Last2: LastEachGate */
    int _gate;
    boolean _muteSync;
    
    public String toString() {
        return _name + ":" + _dataText + ", Gate=" + _gate;
    }
    
    public DTextMessage(int id, String name) {
        _id = id;
        _name = name;
    }
    
    public String getMemoText() {
        return _memoText;
    }

    public String getName() {
        return _name;
    }
    
    public String getDataText() {
        return _dataText;
    }
    
    public int getGate() {
        return _gate;
    }
    
    public String getValueMin() {
        return valueMin;
    }

    public String getValueMax() {
        return valueMax;
    }

    public String getValueOffset() {
        return valueMax;
    }
    
    String _memoText;
    String _dataText;
    
    String valueDefault, valueMin, valueMax, valueOffset, valueName, valueType, valueTableID;
    List<MXDOMElement> valueEntry;
    
    String gateDefault, gateMin, gateMax, gateOffset, gateName, gateType, gateTableID;
    List<MXDOMElement> gateEntry;
}
