/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs;

import java.util.ArrayList;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXTimer {
    static class Item {
        long tick;
        Runnable action;
    }
    
    ArrayList<Item> _pending;
    
    public static MXTimer _timer;
    
    static {
        _timer = new MXTimer();
        Thread t = new Thread(new Runnable() {
            public void run() {
                _timer.mysticLoop();
            }
        });
        t.start();
    }
    
    protected MXTimer() {
        _pending = new ArrayList<Item>();
    }
    
    public static void letsCountdown(long time, Runnable action) {
        Item i = new Item();
        i.tick = System.currentTimeMillis() + time;
        i.action = action;
        synchronized(_timer._pending) {
            _timer._pending.add(i);
            _timer._pending.notify();
        }
    }
    
    public void mysticLoop() {
        while(true) {
            Item pop = null;
            long current = System.currentTimeMillis();
            long nextTick = 60 * 1000 + current;
            synchronized(_pending) {
                for (Item i : _pending) {
                    if (i.tick <= current) {
                        pop = i;
                        _pending.remove(i);
                        break;
                    }
                }
                for (Item i : _pending) {
                    if (i.tick <= nextTick) {
                        nextTick = i.tick;
                    }
                }
                if (pop == null) {
                    try {
                        _pending.wait(nextTick - current);
                    }catch(InterruptedException e) {
                    }
                }
            }
            if (pop != null) {
                try {
                    pop.action.run();
                }catch(Throwable e) {
                    e.printStackTrace();
                }            
            }
        }
    }
}            