/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx70console;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.synthtarou.midimixer.libs.MXTimer;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.midi.MXTraceNumber;
import jp.synthtarou.midimixer.mx70console.ConsoleElement;
import jp.synthtarou.midimixer.mx70console.MX70Process;

public class MX70Panel
extends JPanel {
    MX70Process _process;
    private JCheckBox jCheckBoxInsideInput;
    private JCheckBox jCheckBoxInsideOutput;
    private JCheckBox jCheckBoxOutsideInput;
    private JCheckBox jCheckBoxOutsideOutput;
    private JLabel jLabel1;
    private JLabel jLabelInsideInput;
    private JLabel jLabelInsideOutput;
    private JLabel jLabelOutsideInput;
    private JLabel jLabelOutsideOutput;
    private JList<String> jListInsideInput;
    private JList<String> jListInsideOutput;
    private JList<String> jListOutsideInput;
    private JList<String> jListOutsideOutput;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelInsideInput;
    private JPanel jPanelInsideOutput;
    private JPanel jPanelOutsideInput;
    private JPanel jPanelOutsideOutput;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    NumberFormat formatter3 = new DecimalFormat("0.000");

    public MX70Panel(MX70Process process) {
        JCheckBox[] boxList;
        this._process = process;
        this.initComponents();
        for (JCheckBox box : boxList = new JCheckBox[]{this.jCheckBoxOutsideInput, this.jCheckBoxInsideInput, this.jCheckBoxInsideOutput, this.jCheckBoxOutsideOutput}) {
            int x;
            Object text = box.getText();
            while ((x = ((String)text).indexOf(47)) >= 0) {
                String front = ((String)text).substring(0, x);
                String back = ((String)text).substring(x + 1);
                text = front + "<br>" + back;
            }
            box.setText("<html>" + (String)text + "</html>");
            box.setSelected(true);
        }
        Dimension size = this.getSize();
        size.width /= 4;
        size.width -= 4;
        size.height -= 4;
        this.jScrollPane2.setPreferredSize(size);
        this.jScrollPane3.setPreferredSize(size);
        this.jScrollPane4.setPreferredSize(size);
        this.jScrollPane5.setPreferredSize(size);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MX70Panel.this._process._outsideInput.bind(MX70Panel.this.jListOutsideInput);
                MX70Panel.this._process._insideInput.bind(MX70Panel.this.jListInsideInput);
                MX70Panel.this._process._insideOutput.bind(MX70Panel.this.jListInsideOutput);
                MX70Panel.this._process._outsideOutput.bind(MX70Panel.this.jListOutsideOutput);
                MX70Panel.this.showTimeSpend();
            }
        });
    }

    private void initComponents() {
        this.jCheckBoxOutsideInput = new JCheckBox();
        this.jCheckBoxInsideInput = new JCheckBox();
        this.jCheckBoxInsideOutput = new JCheckBox();
        this.jCheckBoxOutsideOutput = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jPanelOutsideInput = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jListOutsideInput = new JList();
        this.jPanelInsideInput = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jListInsideInput = new JList();
        this.jPanelInsideOutput = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.jListInsideOutput = new JList();
        this.jPanelOutsideOutput = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.jListOutsideOutput = new JList();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabelOutsideInput = new JLabel();
        this.jLabelInsideInput = new JLabel();
        this.jLabelInsideOutput = new JLabel();
        this.jLabelOutsideOutput = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jCheckBoxOutsideInput.setText("Outside/Input");
        this.jCheckBoxOutsideInput.setToolTipText("");
        this.jCheckBoxOutsideInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX70Panel.this.jCheckBoxOutsideInputActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jCheckBoxOutsideInput, gridBagConstraints);
        this.jCheckBoxInsideInput.setText("Inside/Input");
        this.jCheckBoxInsideInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX70Panel.this.jCheckBoxInsideInputActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jCheckBoxInsideInput, gridBagConstraints);
        this.jCheckBoxInsideOutput.setText("Inside/Output");
        this.jCheckBoxInsideOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX70Panel.this.jCheckBoxInsideOutputActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jCheckBoxInsideOutput, gridBagConstraints);
        this.jCheckBoxOutsideOutput.setText("Outsize/Output");
        this.jCheckBoxOutsideOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX70Panel.this.jCheckBoxOutsideOutputActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jCheckBoxOutsideOutput, gridBagConstraints);
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 2));
        this.jPanelOutsideInput.setBorder(BorderFactory.createTitledBorder("Outside Input"));
        this.jPanelOutsideInput.setLayout(new BoxLayout(this.jPanelOutsideInput, 2));
        this.jScrollPane2.setVerticalScrollBarPolicy(22);
        this.jListOutsideInput.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MX70Panel.this.jListOutsideInputMousePressed(evt);
            }
        });
        this.jListOutsideInput.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MX70Panel.this.jListOutsideInputValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jListOutsideInput);
        this.jPanelOutsideInput.add(this.jScrollPane2);
        this.jPanel1.add(this.jPanelOutsideInput);
        this.jPanelInsideInput.setBorder(BorderFactory.createTitledBorder("Inide Input"));
        this.jPanelInsideInput.setLayout(new BoxLayout(this.jPanelInsideInput, 2));
        this.jScrollPane3.setToolTipText("");
        this.jScrollPane3.setVerticalScrollBarPolicy(22);
        this.jListInsideInput.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MX70Panel.this.jListInsideInputMousePressed(evt);
            }
        });
        this.jListInsideInput.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MX70Panel.this.jListInsideInputValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jListInsideInput);
        this.jPanelInsideInput.add(this.jScrollPane3);
        this.jPanel1.add(this.jPanelInsideInput);
        this.jPanelInsideOutput.setBorder(BorderFactory.createTitledBorder("Inside Output"));
        this.jPanelInsideOutput.setLayout(new BoxLayout(this.jPanelInsideOutput, 2));
        this.jScrollPane4.setVerticalScrollBarPolicy(22);
        this.jListInsideOutput.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MX70Panel.this.jListInsideOutputMousePressed(evt);
            }
        });
        this.jListInsideOutput.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MX70Panel.this.jListInsideOutputValueChanged(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.jListInsideOutput);
        this.jPanelInsideOutput.add(this.jScrollPane4);
        this.jPanel1.add(this.jPanelInsideOutput);
        this.jPanelOutsideOutput.setBorder(BorderFactory.createTitledBorder("Outsde Output"));
        this.jPanelOutsideOutput.setLayout(new BoxLayout(this.jPanelOutsideOutput, 2));
        this.jScrollPane5.setVerticalScrollBarPolicy(22);
        this.jListOutsideOutput.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MX70Panel.this.jListOutsideOutputMousePressed(evt);
            }
        });
        this.jListOutsideOutput.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MX70Panel.this.jListOutsideOutputValueChanged(evt);
            }
        });
        this.jScrollPane5.setViewportView(this.jListOutsideOutput);
        this.jPanelOutsideOutput.add(this.jScrollPane5);
        this.jPanel1.add(this.jPanelOutsideOutput);
        this.jScrollPane1.setViewportView(this.jPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setText("jLabel1");
        this.jPanel2.add((Component)this.jLabel1, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jLabelOutsideInput.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.jLabelOutsideInput, gridBagConstraints);
        this.jLabelInsideInput.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.jLabelInsideInput, gridBagConstraints);
        this.jLabelInsideOutput.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.jLabelInsideOutput, gridBagConstraints);
        this.jLabelOutsideOutput.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.jLabelOutsideOutput, gridBagConstraints);
    }

    private void jCheckBoxOutsideInputActionPerformed(ActionEvent evt) {
        this.jPanelOutsideInput.setVisible(this.jCheckBoxOutsideInput.isSelected());
    }

    private void jCheckBoxInsideInputActionPerformed(ActionEvent evt) {
        this.jPanelInsideInput.setVisible(this.jCheckBoxInsideInput.isSelected());
    }

    private void jCheckBoxInsideOutputActionPerformed(ActionEvent evt) {
        this.jPanelInsideOutput.setVisible(this.jCheckBoxInsideOutput.isSelected());
    }

    private void jCheckBoxOutsideOutputActionPerformed(ActionEvent evt) {
        this.jPanelOutsideOutput.setVisible(this.jCheckBoxOutsideOutput.isSelected());
    }

    public void selectByTraceNumberCall(final JList list, final MXTraceNumber trace) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MX70Panel.this.selectByTraceNumber(list, trace);
            }
        });
    }

    public void selectByTraceNumber(JList list, MXTraceNumber trace) {
        this._process._outsideInput.setSelectedTraceNumber(trace);
        this._process._insideInput.setSelectedTraceNumber(trace);
        this._process._insideOutput.setSelectedTraceNumber(trace);
        this._process._outsideOutput.setSelectedTraceNumber(trace);
    }

    private void jListOutsideInputValueChanged(ListSelectionEvent evt) {
        ConsoleElement e;
        int index = this.jListOutsideInput.getSelectedIndex();
        if (index >= 0 && (e = this._process._outsideInput.getConsoleElement(index)) != null) {
            this.selectByTraceNumberCall(this.jListOutsideInput, e.getTraceNumber());
            this.jLabel1.setText(e.getTraceNumber() + " => 0 = " + e.getTraceNumber().thisWrap(0) + ", 1 = " + e.getTraceNumber().thisWrap(1) + ", 2 = " + e.getTraceNumber().thisWrap(2) + ", 3 = =" + e.getTraceNumber().thisWrap(3));
        }
    }

    private void jListInsideInputValueChanged(ListSelectionEvent evt) {
        ConsoleElement e;
        int index = this.jListInsideInput.getSelectedIndex();
        if (index >= 0 && (e = this._process._insideInput.getConsoleElement(index)) != null) {
            this.selectByTraceNumberCall(this.jListInsideInput, e.getTraceNumber());
            this.jLabel1.setText(e.getTraceNumber() + " => 0 = " + e.getTraceNumber().thisWrap(0) + ", 1 = " + e.getTraceNumber().thisWrap(1) + ", 2 = " + e.getTraceNumber().thisWrap(2) + ", 3 = =" + e.getTraceNumber().thisWrap(3));
        }
    }

    private void jListInsideOutputValueChanged(ListSelectionEvent evt) {
        ConsoleElement e;
        int index = this.jListInsideOutput.getSelectedIndex();
        if (index >= 0 && (e = this._process._insideOutput.getConsoleElement(index)) != null) {
            this.selectByTraceNumberCall(this.jListInsideOutput, e.getTraceNumber());
            this.jLabel1.setText(e.getTraceNumber() + " => 0 = " + e.getTraceNumber().thisWrap(0) + ", 1 = " + e.getTraceNumber().thisWrap(1) + ", 2 = " + e.getTraceNumber().thisWrap(2) + ", 3 = =" + e.getTraceNumber().thisWrap(3));
        }
    }

    private void jListOutsideOutputValueChanged(ListSelectionEvent evt) {
        ConsoleElement e;
        int index = this.jListOutsideOutput.getSelectedIndex();
        if (index >= 0 && (e = this._process._outsideOutput.getConsoleElement(index)) != null) {
            this.selectByTraceNumberCall(this.jListOutsideOutput, e.getTraceNumber());
            this.jLabel1.setText(e.getTraceNumber() + " => 0 = " + e.getTraceNumber().thisWrap(0) + ", 1 = " + e.getTraceNumber().thisWrap(1) + ", 2 = " + e.getTraceNumber().thisWrap(2) + ", 3 = =" + e.getTraceNumber().thisWrap(3));
        }
    }

    private void jListOutsideInputMousePressed(MouseEvent evt) {
        ConsoleElement e;
        int index = this.jListOutsideInput.getSelectedIndex();
        if (index >= 0 && (e = this._process._outsideInput.getConsoleElement(index)) != null) {
            this.selectByTraceNumberCall(this.jListOutsideInput, e.getTraceNumber());
        }
    }

    private void jListInsideInputMousePressed(MouseEvent evt) {
        ConsoleElement e;
        int index = this.jListInsideInput.getSelectedIndex();
        if (index >= 0 && (e = this._process._insideInput.getConsoleElement(index)) != null) {
            this.selectByTraceNumberCall(this.jListInsideInput, e.getTraceNumber());
        }
    }

    private void jListInsideOutputMousePressed(MouseEvent evt) {
        ConsoleElement e;
        int index = this.jListInsideOutput.getSelectedIndex();
        if (index >= 0 && (e = this._process._insideOutput.getConsoleElement(index)) != null) {
            this.selectByTraceNumberCall(this.jListInsideOutput, e.getTraceNumber());
        }
    }

    private void jListOutsideOutputMousePressed(MouseEvent evt) {
        ConsoleElement e;
        int index = this.jListOutsideOutput.getSelectedIndex();
        if (index >= 0 && (e = this._process._outsideOutput.getConsoleElement(index)) != null) {
            this.selectByTraceNumberCall(this.jListOutsideOutput, e.getTraceNumber());
        }
    }

    public boolean isOwnerWindowVisible() {
        try {
            Container cont = MXUtil.getOwnerWindow(this);
            return cont.isVisible();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void showTimeSpend() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    block8: for (int i = 0; i < 4; ++i) {
                        long count = MXTraceNumber.totalCount(i);
                        long spend = MXTraceNumber.totalWrap(i);
                        long bottom = MXTraceNumber.totalBottom(i);
                        String div = MX70Panel.this.formatter3.format(1.0 * (double)spend / (double)count);
                        String text = "<html>" + spend + "ms/" + count + "=" + div + "<br> bottom" + bottom + "ms</html>";
                        switch (i) {
                            case 0: {
                                MX70Panel.this.jLabelOutsideInput.setText(text);
                                continue block8;
                            }
                            case 1: {
                                MX70Panel.this.jLabelInsideInput.setText(text);
                                continue block8;
                            }
                            case 2: {
                                MX70Panel.this.jLabelInsideOutput.setText(text);
                                continue block8;
                            }
                            case 3: {
                                MX70Panel.this.jLabelOutsideOutput.setText(text);
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                for (Container parent = MX70Panel.this.getParent(); parent != null; parent = parent.getParent()) {
                    Dialog d;
                    Window w;
                    if (parent instanceof Window && !(w = (Window)parent).isVisible()) {
                        return;
                    }
                    if (!(parent instanceof Dialog) || (d = (Dialog)parent).isVisible()) continue;
                    return;
                }
                MXTimer.letsCountdown(1000L, new Runnable(){

                    @Override
                    public void run() {
                        MX70Panel.this.showTimeSpend();
                    }
                });
            }
        });
    }

    public void showAsWindow() {
        JFrame newFrame = new JFrame();
        newFrame.setTitle("Free Consone / SysEX(MIX Recipe)");
        newFrame.pack();
        newFrame.getContentPane().add(this);
        this.setPreferredSize(new Dimension(1000, 250));
        newFrame.pack();
        MXUtil.centerWindow(newFrame);
        newFrame.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int count = 4999;
                MX70Panel.this.jListOutsideInput.ensureIndexIsVisible(count);
                MX70Panel.this.jListInsideInput.ensureIndexIsVisible(count);
                MX70Panel.this.jListInsideOutput.ensureIndexIsVisible(count);
                MX70Panel.this.jListOutsideOutput.ensureIndexIsVisible(count);
            }
        });
    }
}

