/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx60output;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIInManager;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIOut;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIOutManager;
import jp.synthtarou.midimixer.libs.swing.CheckBoxListCellRenderer;
import jp.synthtarou.midimixer.libs.swing.MXFileOpenChooser;
import org.xml.sax.SAXException;

public class MX60MidiOutListPanel
extends JPanel {
    private static final MXDebugLines _debug = new MXDebugLines(MX60MidiOutListPanel.class);
    private JScrollPane jScrollPane4;
    private JTable jTableDevice;
    public CheckBoxListCellRenderer _inputBox;
    public CheckBoxListCellRenderer _outputBox;

    public MX60MidiOutListPanel() {
        this.initComponents();
        MXMIDIInManager manager = MXMIDIInManager.getManager();
        this.jTableDevice = new JTable();
        this.jScrollPane4 = new JScrollPane(this.jTableDevice);
        this.jTableDevice.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MX60MidiOutListPanel.this.jTableDeviceMousePressed(evt);
            }
        });
        this.jTableDevice.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MX60MidiOutListPanel.this.jTableDeviceKeyPressed(evt);
            }
        });
        this.add(this.jScrollPane4);
        this.refreshList();
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 2));
    }

    public void refreshList() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MX60MidiOutListPanel.this.refreshList();
                }
            });
            return;
        }
        MXMIDIOutManager manager = MXMIDIOutManager.getManager();
        manager.reloadDeviceList();
        this.jTableDevice.setModel(this.createDeviceModel());
        this.jTableDevice.getColumnModel().getColumn(1).setMaxWidth(50);
        this.jTableDevice.getColumnModel().getColumn(2).setMaxWidth(50);
    }

    public TableModel createDeviceModel() {
        MXWrapList<MXMIDIOut> allOutput = MXMIDIOutManager.getManager().listAllOutput();
        MXMIDIOutManager manager = MXMIDIOutManager.getManager();
        DefaultTableModel tableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        tableModel.addColumn("Port");
        tableModel.addColumn("Assign");
        tableModel.addColumn("Open");
        tableModel.addColumn("DominoXML");
        for (MXMIDIOut output : allOutput.valueList()) {
            File dfile = output.getDXMLFile();
            String dfileName = "";
            if (dfile != null) {
                dfileName = dfile.getName();
            }
            tableModel.addRow(new Object[]{output.getName(), MXUtilMidi.nameOfPortShort(output.assignedPort()), output.isOpen() ? "o" : "-", dfileName});
        }
        return tableModel;
    }

    public void updateDeviceTable() {
        DefaultTableModel model = (DefaultTableModel)this.jTableDevice.getModel();
        TableModel newModel = this.createDeviceModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            String name = (String)model.getValueAt(i, 0);
            String asssign = (String)model.getValueAt(i, 1);
            String open = (String)model.getValueAt(i, 2);
            String withD = (String)model.getValueAt(i, 3);
            String newName = (String)newModel.getValueAt(i, 0);
            String newAssign = (String)newModel.getValueAt(i, 1);
            String newOpen = (String)newModel.getValueAt(i, 2);
            String newWithD = (String)newModel.getValueAt(i, 3);
            if (!name.equals(newName)) {
                _debug.println("any troubole?");
                break;
            }
            model.setValueAt(newAssign, i, 1);
            model.setValueAt(newOpen, i, 2);
            model.setValueAt(newWithD, i, 3);
        }
    }

    public void popupOutputPortSelect(int row) {
        JPopupMenu menu = this.createPopupMenuForPort(row);
        menu.show(this.jTableDevice, this.jTableDevice.getColumnModel().getColumns().nextElement().getWidth(), this.jTableDevice.getRowHeight(0) * (row + 1));
    }

    public JPopupMenu createPopupMenuForPort(final int row) {
        JPopupMenu popup = new JPopupMenu();
        for (int i = -1; i < 16; ++i) {
            JMenuItem item = i < 0 ? popup.add("(none)") : popup.add(MXUtilMidi.nameOfPortShort(i));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    JMenuItem item = (JMenuItem)arg0.getSource();
                    String itemText = item.getText();
                    int newAssign = itemText.startsWith("(") ? -1 : MXUtilMidi.valueOfPortName(itemText);
                    MXMIDIOutManager manager = MXMIDIOutManager.getManager();
                    DefaultTableModel model = null;
                    model = (DefaultTableModel)MX60MidiOutListPanel.this.jTableDevice.getModel();
                    String text = (String)model.getValueAt(row, 0);
                    MXMIDIOut output = manager.listAllOutput().valueOfName(text);
                    MXMIDIOutManager.getManager().reserveOutput(output, newAssign);
                    if (newAssign >= 0 && !output.open()) {
                        JOptionPane.showMessageDialog(MX60MidiOutListPanel.this, "Couldn't open " + text);
                    }
                    MX60MidiOutListPanel.this.updateDeviceTable();
                }
            });
        }
        return popup;
    }

    private void jTableDeviceKeyPressed(KeyEvent evt) {
        if (evt.getKeyChar() == ' ' || evt.getKeyChar() == '\n') {
            this.popupOutputPortSelect(this.jTableDevice.getSelectedRow());
        }
    }

    private void jTableDeviceMousePressed(MouseEvent evt) {
        DefaultTableModel tableModel;
        int row = this.jTableDevice.rowAtPoint(evt.getPoint());
        int col = this.jTableDevice.columnAtPoint(evt.getPoint());
        if (col == 1) {
            this.popupOutputPortSelect(row);
        }
        if (col == 2) {
            tableModel = (DefaultTableModel)this.jTableDevice.getModel();
            String name = (String)tableModel.getValueAt(row, 0);
            MXWrapList<MXMIDIOut> allOutput = MXMIDIOutManager.getManager().listAllOutput();
            for (MXMIDIOut output : allOutput.valueList()) {
                if (!output.getName().equals(name)) continue;
                if (output.assignedPort() < 0) {
                    JOptionPane.showMessageDialog(this, "Please assign [" + output.getName() + "] to port, before open.");
                    break;
                }
                if (output.isOpen()) {
                    output.close();
                    break;
                }
                if (output.open()) break;
                JOptionPane.showMessageDialog(this, "Can't open " + output.getName());
                break;
            }
            this.updateDeviceTable();
        }
        if (col == 3) {
            tableModel = (DefaultTableModel)this.jTableDevice.getModel();
            String portname = (String)tableModel.getValueAt(row, 0);
            MXMIDIOut out = MXMIDIOutManager.getManager().findMIDIOutput(portname);
            if (out == null) {
                return;
            }
            File dir = null;
            if (out.getDXMLFile() != null) {
                dir = MXFileOpenChooser.getExistDirectoryRecursive(out.getDXMLFile());
            }
            if (dir == null) {
                dir = MXFileOpenChooser.getStartDirectory();
            }
            MXFileOpenChooser chooser = new MXFileOpenChooser(dir);
            chooser.addExtension(".xml", "Domino XML File");
            chooser.setAcceptAllFileFilterUsed(false);
            if (chooser.showOpenDialog(this) == 0) {
                String name = (String)tableModel.getValueAt(row, 0);
                MXWrapList<MXMIDIOut> allOutput = MXMIDIOutManager.getManager().listAllOutput();
                for (MXMIDIOut output : allOutput.valueList()) {
                    if (!output.getName().equals(name)) continue;
                    try {
                        output.setDXMLFile(chooser.getSelectedFile());
                        this.updateDeviceTable();
                    }
                    catch (SAXException e) {
                        JOptionPane.showMessageDialog(this, e.toString());
                    }
                }
            }
        }
    }
}

