/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx40layer;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.MXTimer;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.MXWrap;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.midi.programlist.database.ProgramPicker;
import jp.synthtarou.midimixer.libs.swing.MXFileOpenChooser;
import jp.synthtarou.midimixer.libs.swing.SafeSpinnerNumberModel;
import jp.synthtarou.midimixer.mx40layer.MX40Group;
import jp.synthtarou.midimixer.mx40layer.MX40Layer;
import jp.synthtarou.midimixer.mx40layer.MX40Process;

public class MX40View
extends JPanel
implements TableModelListener {
    private static final MXDebugLines _debug = new MXDebugLines(MX40View.class);
    public MX40Process _process;
    MX40Group _editingGroup;
    MX40Layer _editingLayer;
    MXWrapList<Integer> _watchChannel = MXUtilMidi.createChannel(false);
    MXWrapList<Integer> _watchProgram = MXUtilMidi.createProgram();
    MXWrapList<Integer> _modPort = MX40Layer.createSendOption(false);
    MXWrapList<Integer> _modChannel = MX40Layer.createSendOption(false);
    MXWrapList<Integer> _modBank = MX40Layer.createSendOption(true);
    MXWrapList<Integer> _modProgram = MX40Layer.createSendOption(true);
    MXWrapList<Integer> _changeChannel = MXUtilMidi.createChannel(false);
    MXWrapList<Integer> _changeProgram = MXUtilMidi.createProgram();
    MXWrapList<Integer> _changeVolume = MXUtilMidi.createPercent();
    MXWrapList<Integer> _changeExpression = MXUtilMidi.createPercent();
    MXWrapList<Integer> _changeLowNote = MXUtilMidi.createNoteNo();
    MXWrapList<Integer> _changeHighNote = MXUtilMidi.createNoteNo();
    MXWrapList<Integer> _changeLowVelocity = MXUtilMidi.createVelocity();
    MXWrapList<Integer> _changeHighVelocity = MXUtilMidi.createVelocity();
    MXWrapList<MX40Group> _groupsModel = null;
    MXWrapList<MX40Layer> _layersModel = null;
    boolean underConstruction = true;
    private JButton jButtonApplyGroup;
    private JButton jButtonApplyLayer;
    private JButton jButtonExport;
    private JButton jButtonGroupDown;
    private JButton jButtonGroupProgram;
    private JButton jButtonGroupUp;
    private JButton jButtonImport;
    private JButton jButtonLayerDown;
    private JButton jButtonLayerProgram;
    private JButton jButtonLayerUp;
    private JButton jButtonNewGroup;
    private JButton jButtonNewLayer;
    private JButton jButtonRemoveGroup;
    private JButton jButtonRemoveLayer;
    private JButton jButtonSendPort;
    private JButton jButtonWatchPort;
    private JCheckBox jCheckBoxBank;
    private JCheckBox jCheckBoxChannel;
    private JCheckBox jCheckBoxFixPan;
    private JCheckBox jCheckBoxPort;
    private JCheckBox jCheckBoxProgram;
    private JCheckBox jCheckBoxRotateLayer;
    private JCheckBox jCheckBoxUseLayer;
    private JComboBox<String> jComboBoxModBank;
    private JComboBox<String> jComboBoxModChannel;
    private JComboBox<String> jComboBoxModPort;
    private JComboBox<String> jComboBoxModProgram;
    private JComboBox<String> jComboBoxSendChannel;
    private JComboBox<String> jComboBoxSendNoteHigh;
    private JComboBox<String> jComboBoxSendNoteLow;
    private JComboBox<String> jComboBoxSendVelocityHi;
    private JComboBox<String> jComboBoxSendVelocityLow;
    private JComboBox<String> jComboBoxWatchChannel;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelTargetGroupName;
    private JList<String> jListGroupList;
    private JList<String> jListLayerList;
    private JPanel jPanel0;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanelGroup;
    private JPanel jPanelLayer;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JSpinner jSpinnerRotatePoly;
    private JSpinner jSpinnerSendAdjustExpression;
    private JSpinner jSpinnerSendAdjustTranspose;
    private JSpinner jSpinnerSendAdjustVelocity;
    private JSpinner jSpinnerSendBankLSB;
    private JSpinner jSpinnerSendBankMSB;
    private JSpinner jSpinnerSendFixedPan;
    private JSpinner jSpinnerSendProgram;
    private JSpinner jSpinnerWatchBankLSB;
    private JSpinner jSpinnerWatchBankMSB;
    private JSpinner jSpinnerWatchProgram;
    private JSplitPane jSplitPane1;
    private JTable jTable1;
    private JTable jTable2;
    private JTable jTable3;
    private JTextField jTextFieldGroupName;
    private JTextField jTextFieldLayerName;
    boolean updateRequest = false;

    public MX40View(MX40Process process) {
        this.initComponents();
        this._process = process;
        this.jTextFieldGroupName.setText("New Group");
        this._editingGroup = null;
        this._editingLayer = null;
        this.jComboBoxWatchChannel.setModel(this._watchChannel);
        this.jTextFieldLayerName.setText("New Layer");
        this.jComboBoxModPort.setModel(this._modPort);
        this.jComboBoxModChannel.setModel(this._modChannel);
        this.jComboBoxSendChannel.setModel(this._changeChannel);
        this.jComboBoxModBank.setModel(this._modBank);
        this.jComboBoxModProgram.setModel(this._modProgram);
        this.jSpinnerSendProgram.setModel(new SafeSpinnerNumberModel(0, 0, 127, 1));
        this.jSpinnerSendBankMSB.setModel(new SafeSpinnerNumberModel(0, 0, 127, 1));
        this.jSpinnerSendBankLSB.setModel(new SafeSpinnerNumberModel(0, 0, 127, 1));
        this.jSpinnerSendFixedPan.setModel(new SafeSpinnerNumberModel(0, 0, 127, 1));
        this.jSpinnerSendAdjustExpression.setModel(new SafeSpinnerNumberModel(100, 0, 100, 1));
        this.jSpinnerSendAdjustTranspose.setModel(new SafeSpinnerNumberModel(0, -128, 128, 1));
        this.jSpinnerSendAdjustVelocity.setModel(new SafeSpinnerNumberModel(0, -128, 128, 1));
        this.jComboBoxSendNoteLow.setModel(this._changeLowNote);
        this.jComboBoxSendNoteHigh.setModel(this._changeHighNote);
        this.jComboBoxSendVelocityLow.setModel(this._changeLowVelocity);
        this.jComboBoxSendVelocityHi.setModel(this._changeHighVelocity);
        this.jCheckBoxUseLayer.setSelected(process.isUsingThisRecipe());
        this._editingGroup = null;
        this._editingLayer = null;
        this.jTable1.setModel(this._process._inputInfo);
        this.jTable2.setModel(this._process._outputInfo);
        this._process._inputInfo.addTableModelListener(this);
        this._process._outputInfo.addTableModelListener(this);
        MXUtil.autoResizeTableColumnWidth(this.jTable1);
        MXUtil.autoResizeTableColumnWidth(this.jTable2);
        this.startEditingPack(0, 0);
        this.disableUnusedOnPanel();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable3 = new JTable();
        this.jCheckBoxUseLayer = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jPanelGroup = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldGroupName = new JTextField();
        this.jButtonWatchPort = new JButton();
        this.jComboBoxWatchChannel = new JComboBox();
        this.jCheckBoxPort = new JCheckBox();
        this.jCheckBoxChannel = new JCheckBox();
        this.jCheckBoxBank = new JCheckBox();
        this.jCheckBoxProgram = new JCheckBox();
        this.jCheckBoxRotateLayer = new JCheckBox();
        this.jButtonNewGroup = new JButton();
        this.jButtonApplyGroup = new JButton();
        this.jButtonRemoveGroup = new JButton();
        this.jButtonGroupProgram = new JButton();
        this.jButtonGroupUp = new JButton();
        this.jButtonGroupDown = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.jListGroupList = new JList();
        this.jSpinnerRotatePoly = new JSpinner();
        this.jSpinnerWatchProgram = new JSpinner();
        this.jSpinnerWatchBankMSB = new JSpinner();
        this.jSpinnerWatchBankLSB = new JSpinner();
        this.jPanelLayer = new JPanel();
        this.jLabel8 = new JLabel();
        this.jTextFieldLayerName = new JTextField();
        this.jButtonNewLayer = new JButton();
        this.jButtonApplyLayer = new JButton();
        this.jButtonRemoveLayer = new JButton();
        this.jButtonLayerUp = new JButton();
        this.jButtonLayerDown = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jListLayerList = new JList();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jComboBoxModPort = new JComboBox();
        this.jButtonSendPort = new JButton();
        this.jComboBoxModChannel = new JComboBox();
        this.jComboBoxSendChannel = new JComboBox();
        this.jComboBoxModProgram = new JComboBox();
        this.jSpinnerSendProgram = new JSpinner();
        this.jComboBoxModBank = new JComboBox();
        this.jSpinnerSendBankMSB = new JSpinner();
        this.jSpinnerSendBankLSB = new JSpinner();
        this.jSpinnerSendFixedPan = new JSpinner();
        this.jSpinnerSendAdjustExpression = new JSpinner();
        this.jComboBoxSendNoteLow = new JComboBox();
        this.jComboBoxSendNoteHigh = new JComboBox();
        this.jSpinnerSendAdjustTranspose = new JSpinner();
        this.jSpinnerSendAdjustVelocity = new JSpinner();
        this.jLabel14 = new JLabel();
        this.jLabelTargetGroupName = new JLabel();
        this.jButtonLayerProgram = new JButton();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jCheckBoxFixPan = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.jComboBoxSendVelocityLow = new JComboBox();
        this.jComboBoxSendVelocityHi = new JComboBox();
        this.jLabel18 = new JLabel();
        this.jPanel0 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel3 = new JPanel();
        this.jScrollPane6 = new JScrollPane();
        this.jTable2 = new JTable();
        this.jButtonImport = new JButton();
        this.jButtonExport = new JButton();
        this.jTable3.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTable3);
        this.setLayout(new GridBagLayout());
        this.jCheckBoxUseLayer.setText("Use This Recipe");
        this.jCheckBoxUseLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jCheckBoxUseLayerActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.jCheckBoxUseLayer, gridBagConstraints);
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 2));
        this.jSplitPane1.setDividerLocation(700);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanelGroup.setBorder(BorderFactory.createTitledBorder("1.Edit Group"));
        this.jPanelGroup.setLayout(new GridBagLayout());
        this.jLabel1.setText("Group Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanelGroup.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        this.jPanelGroup.add((Component)this.jTextFieldGroupName, gridBagConstraints);
        this.jButtonWatchPort.setText("-");
        this.jButtonWatchPort.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MX40View.this.jButtonWatchPortMousePressed(evt);
            }
        });
        this.jButtonWatchPort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jButtonWatchPortActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.jPanelGroup.add((Component)this.jButtonWatchPort, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        this.jPanelGroup.add(this.jComboBoxWatchChannel, gridBagConstraints);
        this.jCheckBoxPort.setText("Watch Port");
        this.jCheckBoxPort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jCheckBoxPortActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanelGroup.add((Component)this.jCheckBoxPort, gridBagConstraints);
        this.jCheckBoxChannel.setText("Watch Channel");
        this.jCheckBoxChannel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jCheckBoxChannelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanelGroup.add((Component)this.jCheckBoxChannel, gridBagConstraints);
        this.jCheckBoxBank.setText("Watch Bank (MSB/LSB)");
        this.jCheckBoxBank.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jCheckBoxBankActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanelGroup.add((Component)this.jCheckBoxBank, gridBagConstraints);
        this.jCheckBoxProgram.setText("Watch Program");
        this.jCheckBoxProgram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jCheckBoxProgramActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanelGroup.add((Component)this.jCheckBoxProgram, gridBagConstraints);
        this.jCheckBoxRotateLayer.setText("Rotate Layer (Poly)");
        this.jCheckBoxRotateLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jCheckBoxRotateLayerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        this.jPanelGroup.add((Component)this.jCheckBoxRotateLayer, gridBagConstraints);
        this.jButtonNewGroup.setText("Start New Group");
        this.jButtonNewGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jButtonNewGroupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        this.jPanelGroup.add((Component)this.jButtonNewGroup, gridBagConstraints);
        this.jButtonApplyGroup.setText("Save Group");
        this.jButtonApplyGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jButtonApplyGroupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 2.0;
        this.jPanelGroup.add((Component)this.jButtonApplyGroup, gridBagConstraints);
        this.jButtonRemoveGroup.setText("Remove");
        this.jButtonRemoveGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jButtonRemoveGroupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        this.jPanelGroup.add((Component)this.jButtonRemoveGroup, gridBagConstraints);
        this.jButtonGroupProgram.setText("Program Picker");
        this.jButtonGroupProgram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jButtonGroupProgramActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 2.0;
        this.jPanelGroup.add((Component)this.jButtonGroupProgram, gridBagConstraints);
        this.jButtonGroupUp.setText("Up");
        this.jButtonGroupUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jButtonGroupUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 13;
        this.jPanelGroup.add((Component)this.jButtonGroupUp, gridBagConstraints);
        this.jButtonGroupDown.setText("Down");
        this.jButtonGroupDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jButtonGroupDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 13;
        this.jPanelGroup.add((Component)this.jButtonGroupDown, gridBagConstraints);
        this.jScrollPane3.setViewportBorder(BorderFactory.createTitledBorder("Group List"));
        this.jListGroupList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MX40View.this.jListGroupListValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jListGroupList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelGroup.add((Component)this.jScrollPane3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        this.jPanelGroup.add((Component)this.jSpinnerRotatePoly, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        this.jPanelGroup.add((Component)this.jSpinnerWatchProgram, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        this.jPanelGroup.add((Component)this.jSpinnerWatchBankMSB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        this.jPanelGroup.add((Component)this.jSpinnerWatchBankLSB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanelGroup, gridBagConstraints);
        this.jPanelLayer.setBorder(BorderFactory.createTitledBorder("2.Edit Layer"));
        this.jPanelLayer.setLayout(new GridBagLayout());
        this.jLabel8.setText("Layer Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.jPanelLayer.add((Component)this.jLabel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.jPanelLayer.add((Component)this.jTextFieldLayerName, gridBagConstraints);
        this.jButtonNewLayer.setText("Start New Layer");
        this.jButtonNewLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jButtonNewLayerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 17;
        this.jPanelLayer.add((Component)this.jButtonNewLayer, gridBagConstraints);
        this.jButtonApplyLayer.setText("Save Layer");
        this.jButtonApplyLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jButtonApplyLayerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        this.jPanelLayer.add((Component)this.jButtonApplyLayer, gridBagConstraints);
        this.jButtonRemoveLayer.setText("Remove");
        this.jButtonRemoveLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jButtonRemoveLayerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = 17;
        this.jPanelLayer.add((Component)this.jButtonRemoveLayer, gridBagConstraints);
        this.jButtonLayerUp.setText("Up");
        this.jButtonLayerUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jButtonLayerUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = 13;
        this.jPanelLayer.add((Component)this.jButtonLayerUp, gridBagConstraints);
        this.jButtonLayerDown.setText("Down");
        this.jButtonLayerDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jButtonLayerDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        this.jPanelLayer.add((Component)this.jButtonLayerDown, gridBagConstraints);
        this.jScrollPane2.setViewportBorder(BorderFactory.createTitledBorder("Layer List"));
        this.jListLayerList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MX40View.this.jListLayerListValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jListLayerList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelLayer.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jLabel2.setText("Port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanelLayer.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("Channel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.jPanelLayer.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("Bank");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.jPanelLayer.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText("Program");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.jPanelLayer.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel7.setText("Pan");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        this.jPanelLayer.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel9.setText("Expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        this.jPanelLayer.add((Component)this.jLabel9, gridBagConstraints);
        this.jLabel10.setText("Note Range");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        this.jPanelLayer.add((Component)this.jLabel10, gridBagConstraints);
        this.jLabel11.setText("Velocity Range");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        this.jPanelLayer.add((Component)this.jLabel11, gridBagConstraints);
        this.jLabel12.setText("Transpose");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        this.jPanelLayer.add((Component)this.jLabel12, gridBagConstraints);
        this.jLabel13.setText("Velocity");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        this.jPanelLayer.add((Component)this.jLabel13, gridBagConstraints);
        this.jComboBoxModPort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jComboBoxModPortActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        this.jPanelLayer.add(this.jComboBoxModPort, gridBagConstraints);
        this.jButtonSendPort.setText("-");
        this.jButtonSendPort.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MX40View.this.jButtonSendPortMousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.jPanelLayer.add((Component)this.jButtonSendPort, gridBagConstraints);
        this.jComboBoxModChannel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jComboBoxModChannelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        this.jPanelLayer.add(this.jComboBoxModChannel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanelLayer.add(this.jComboBoxSendChannel, gridBagConstraints);
        this.jComboBoxModProgram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jComboBoxModProgramActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        this.jPanelLayer.add(this.jComboBoxModProgram, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        this.jPanelLayer.add((Component)this.jSpinnerSendProgram, gridBagConstraints);
        this.jComboBoxModBank.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jComboBoxModBankActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelLayer.add(this.jComboBoxModBank, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanelLayer.add((Component)this.jSpinnerSendBankMSB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanelLayer.add((Component)this.jSpinnerSendBankLSB, gridBagConstraints);
        this.jSpinnerSendFixedPan.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MX40View.this.jSpinnerSendFixedPanStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        this.jPanelLayer.add((Component)this.jSpinnerSendFixedPan, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanelLayer.add((Component)this.jSpinnerSendAdjustExpression, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        this.jPanelLayer.add(this.jComboBoxSendNoteLow, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        this.jPanelLayer.add(this.jComboBoxSendNoteHigh, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        this.jPanelLayer.add((Component)this.jSpinnerSendAdjustTranspose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        this.jPanelLayer.add((Component)this.jSpinnerSendAdjustVelocity, gridBagConstraints);
        this.jLabel14.setText("In Group");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanelLayer.add((Component)this.jLabel14, gridBagConstraints);
        this.jLabelTargetGroupName.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.jPanelLayer.add((Component)this.jLabelTargetGroupName, gridBagConstraints);
        this.jButtonLayerProgram.setText("Program Picker");
        this.jButtonLayerProgram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jButtonLayerProgramActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        this.jPanelLayer.add((Component)this.jButtonLayerProgram, gridBagConstraints);
        this.jLabel15.setText("%   0%-100%");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        this.jPanelLayer.add((Component)this.jLabel15, gridBagConstraints);
        this.jLabel16.setText("-128....+128");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 12;
        this.jPanelLayer.add((Component)this.jLabel16, gridBagConstraints);
        this.jLabel17.setText("-128....+128");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 13;
        this.jPanelLayer.add((Component)this.jLabel17, gridBagConstraints);
        this.jCheckBoxFixPan.setText("Fix Pan");
        this.jCheckBoxFixPan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jCheckBoxFixPanActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        this.jPanelLayer.add((Component)this.jCheckBoxFixPan, gridBagConstraints);
        this.jLabel6.setText(" to");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        this.jPanelLayer.add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        this.jPanelLayer.add(this.jComboBoxSendVelocityLow, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        this.jPanelLayer.add(this.jComboBoxSendVelocityHi, gridBagConstraints);
        this.jLabel18.setText(" to ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        this.jPanelLayer.add((Component)this.jLabel18, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanelLayer, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jPanel0.setLayout(new GridBagLayout());
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Input Info"));
        this.jPanel4.setLayout(new BoxLayout(this.jPanel4, 2));
        this.jScrollPane5.setHorizontalScrollBarPolicy(31);
        this.jScrollPane5.setVerticalScrollBarPolicy(22);
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane5.setViewportView(this.jTable1);
        this.jPanel4.add(this.jScrollPane5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel0.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Output Info"));
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 2));
        this.jScrollPane6.setHorizontalScrollBarPolicy(31);
        this.jScrollPane6.setVerticalScrollBarPolicy(22);
        this.jTable2.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane6.setViewportView(this.jTable2);
        this.jPanel3.add(this.jScrollPane6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel0.add((Component)this.jPanel3, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.jPanel0);
        this.jPanel2.add(this.jSplitPane1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jButtonImport.setText("Import");
        this.jButtonImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jButtonImportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.jButtonImport, gridBagConstraints);
        this.jButtonExport.setText("Export");
        this.jButtonExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX40View.this.jButtonExportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jButtonExport, gridBagConstraints);
    }

    public void disableUnusedOnPanel() {
        boolean flag;
        MX40Group group = new MX40Group(this._process);
        this.readGroupFromPanel(group);
        this.jButtonWatchPort.setEnabled(group._isWatchPort);
        this.jComboBoxWatchChannel.setEnabled(group._isWatchChannel);
        this.jSpinnerWatchProgram.setEnabled(group._isWatchProgram);
        this.jSpinnerWatchBankMSB.setEnabled(group._isWatchBank);
        this.jSpinnerWatchBankLSB.setEnabled(group._isWatchBank);
        this.jButtonGroupProgram.setEnabled(group._isWatchBank || group._isWatchProgram);
        this.jSpinnerRotatePoly.setEnabled(group._isRotate);
        boolean bl = flag = this._editingGroup != null;
        if (flag) {
            MX40Layer layer = new MX40Layer(this._process, group);
            this.readLayerFromPanel(layer);
            this.jButtonSendPort.setEnabled(layer._modPort == 2);
            this.jComboBoxSendChannel.setEnabled(layer._modChannel == 2);
            this.jSpinnerSendBankMSB.setEnabled(layer._modBank == 2);
            this.jSpinnerSendBankLSB.setEnabled(layer._modBank == 2);
            this.jSpinnerSendProgram.setEnabled(layer._modProgram == 2);
            this.jButtonLayerProgram.setEnabled(layer._modBank == 2 || layer._modProgram == 2);
            this.jLabelTargetGroupName.setText(this._editingGroup._title);
            this.jSpinnerSendFixedPan.setEnabled(layer._modPan == 2);
        } else {
            this.jButtonSendPort.setEnabled(false);
            this.jComboBoxSendChannel.setEnabled(false);
            this.jSpinnerSendBankMSB.setEnabled(false);
            this.jSpinnerSendBankLSB.setEnabled(false);
            this.jSpinnerSendProgram.setEnabled(false);
            this.jButtonLayerProgram.setEnabled(false);
            this.jLabelTargetGroupName.setText("*** none **");
            this.jSpinnerSendFixedPan.setEnabled(false);
        }
        this.jTextFieldLayerName.setEnabled(flag);
        this.jButtonNewLayer.setEnabled(flag);
        this.jButtonApplyLayer.setEnabled(flag);
        this.jButtonApplyGroup.setEnabled(flag);
        this.jComboBoxModProgram.setEnabled(flag);
        this.jComboBoxModBank.setEnabled(flag);
        this.jComboBoxModPort.setEnabled(flag);
        this.jComboBoxModChannel.setEnabled(flag);
        this.jCheckBoxFixPan.setEnabled(flag);
        this.jSpinnerSendAdjustExpression.setEnabled(flag);
        this.jSpinnerSendAdjustTranspose.setEnabled(flag);
        this.jSpinnerSendAdjustVelocity.setEnabled(flag);
        this.jComboBoxSendNoteLow.setEnabled(flag);
        this.jComboBoxSendNoteHigh.setEnabled(flag);
    }

    private void jButtonNewGroupActionPerformed(ActionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        this.startNewGroupAndLayer();
        int lastGroupEntry = this._process._groupList.size() - 1;
        this.startEditingPack(lastGroupEntry, 0);
        this.disableUnusedOnPanel();
    }

    private void jCheckBoxUseLayerActionPerformed(ActionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        this._process.setUsingThisRecipe(this.jCheckBoxUseLayer.isSelected());
        this.recursibleEnable(this, this.jCheckBoxUseLayer.isSelected());
        this.jCheckBoxUseLayer.setEnabled(true);
    }

    private void jButtonApplyGroupActionPerformed(ActionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        if (this._editingGroup != null) {
            MX40Group group2 = new MX40Group(this._process);
            this.readGroupFromPanel(group2);
            if (!group2._title.equals(this._editingGroup._title) && this._groupsModel.indexOfName(group2._title) >= 0) {
                JOptionPane.showMessageDialog(this, "name [" + group2._title + "] already used", "can't save", 0);
                return;
            }
            this.readGroupFromPanel(this._editingGroup);
            this.listUpGroups();
        }
    }

    private void jListGroupListValueChanged(ListSelectionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        int index = this.jListGroupList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        this.startEditingPack(index, 0);
    }

    private void jButtonNewLayerActionPerformed(ActionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        if (this._editingGroup == null) {
            JOptionPane.showMessageDialog(this, "\u30b0\u30eb\u30fc\u30d7\u304c\u9078\u629e\u3055\u308c\u3066\u3044\u306a\u306e\u3067\u30ec\u30a4\u30e4\u30fc\u3092\u64cd\u4f5c\u3067\u304d\u306a\u3044", "\u6761\u4ef6\u3092\u6e80\u305f\u3057\u3066\u3044\u307e\u305b\u3093", 0);
            return;
        }
        MX40Layer layer = new MX40Layer(this._process, this._editingGroup);
        this.readLayerFromPanel(layer);
        this.startNewLayer(this._editingGroup, layer);
        int selGroup = this._process._groupList.indexOf(this._editingGroup);
        int lastLayerEntry = this._editingGroup._listLayer.size() - 1;
        this.startEditingPack(selGroup, lastLayerEntry);
    }

    private void jButtonApplyLayerActionPerformed(ActionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        if (this._editingLayer != null) {
            MX40Layer layer2 = new MX40Layer(this._process, this._editingGroup);
            this.readLayerFromPanel(layer2);
            if (!layer2._title.equals(this._editingLayer._title) && this._layersModel.indexOfName(layer2._title) >= 0) {
                JOptionPane.showMessageDialog(this, "name [" + layer2._title + "] already used", "can't save", 0);
                return;
            }
            this.readLayerFromPanel(this._editingLayer);
            this.listupLayers();
            this._process.resendProgramChange();
        }
    }

    private void jListLayerListValueChanged(ListSelectionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        int index = this.jListLayerList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        int groupIndex = 0;
        try {
            groupIndex = this._process._groupList.indexOf(this._editingGroup);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.startEditingPack(groupIndex, index);
    }

    private void jButtonGroupProgramActionPerformed(ActionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        MX40Group group = new MX40Group(null);
        this.readGroupFromPanel(group);
        ProgramPicker picker = new ProgramPicker();
        picker.setDefault(group._watchingProgram, group._watchingBankMSB, group._watchingBankLSB);
        MXUtil.showAsDialog(this, picker, "Select Program");
        if (picker._returnProgram >= 0) {
            this.jSpinnerWatchProgram.setValue(picker._returnProgram);
            this.jSpinnerWatchBankMSB.setValue(picker._returnBankMSB);
            this.jSpinnerWatchBankLSB.setValue(picker._returnBankLSB);
            JOptionPane.showMessageDialog(this, "Push [Save Group] Please");
        }
    }

    private void jButtonLayerProgramActionPerformed(ActionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        MX40Layer layer = new MX40Layer(null, null);
        this.readLayerFromPanel(layer);
        ProgramPicker picker = new ProgramPicker();
        picker.setDefault(layer._fixedProgram, layer._fixedBankMSB, layer._fixedBankLSB);
        MXUtil.showAsDialog(this, picker, "Select Program");
        if (picker._returnProgram >= 0) {
            this.jSpinnerSendProgram.setValue(picker._returnProgram);
            this.jSpinnerSendBankMSB.setValue(picker._returnBankMSB);
            this.jSpinnerSendBankLSB.setValue(picker._returnBankLSB);
            JOptionPane.showMessageDialog(this, "Push [Save Layer] Please");
        }
    }

    private void jCheckBoxPortActionPerformed(ActionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        this.disableUnusedOnPanel();
    }

    private void jCheckBoxChannelActionPerformed(ActionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        this.disableUnusedOnPanel();
    }

    private void jCheckBoxBankActionPerformed(ActionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        this.disableUnusedOnPanel();
    }

    private void jCheckBoxProgramActionPerformed(ActionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        this.disableUnusedOnPanel();
    }

    private void jComboBoxModPortActionPerformed(ActionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        this.disableUnusedOnPanel();
    }

    private void jComboBoxModChannelActionPerformed(ActionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        this.disableUnusedOnPanel();
    }

    private void jComboBoxModBankActionPerformed(ActionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        this.disableUnusedOnPanel();
    }

    private void jComboBoxModProgramActionPerformed(ActionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        this.disableUnusedOnPanel();
    }

    private void jButtonRemoveGroupActionPerformed(ActionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        int x = this.jListGroupList.getSelectedIndex();
        if (x >= 0) {
            this._process._groupList.remove(x);
            try {
                this._editingGroup = null;
                this.listUpGroups();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this._editingLayer = null;
                this.listupLayers();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this._process.resendProgramChange();
            this.disableUnusedOnPanel();
        }
    }

    private void jButtonGroupUpActionPerformed(ActionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        int x = this.jListGroupList.getSelectedIndex();
        if (x >= 0 && x >= 1) {
            MX40Group o = this._process._groupList.remove(x);
            this._process._groupList.add(x - 1, o);
            this.listUpGroups();
            this._process.resendProgramChange();
        }
    }

    private void jButtonGroupDownActionPerformed(ActionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        int x = this.jListGroupList.getSelectedIndex();
        if (x >= 0 && x < this._process._groupList.size() - 1) {
            MX40Group o = this._process._groupList.remove(x);
            this._process._groupList.add(x + 1, o);
            this.listUpGroups();
            this._process.resendProgramChange();
        }
    }

    private void jButtonRemoveLayerActionPerformed(ActionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        MX40Group parent = this._editingGroup;
        if (parent == null) {
            return;
        }
        int x = this.jListLayerList.getSelectedIndex();
        if (x >= 0) {
            parent._listLayer.remove(x);
            this.listupLayers();
            this._process.resendProgramChange();
            this.disableUnusedOnPanel();
        }
    }

    private void jButtonLayerUpActionPerformed(ActionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        MX40Group parent = this._editingGroup;
        if (parent == null) {
            return;
        }
        int x = this.jListLayerList.getSelectedIndex();
        if (x >= 0 && x >= 1) {
            MX40Layer o = parent._listLayer.remove(x);
            parent._listLayer.add(x - 1, o);
            this.listupLayers();
            this._process.resendProgramChange();
        }
    }

    private void jButtonLayerDownActionPerformed(ActionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        MX40Group parent = this._editingGroup;
        if (parent == null) {
            return;
        }
        int x = this.jListLayerList.getSelectedIndex();
        if (x >= 0 && x <= this._process._groupList.size() - 1) {
            MX40Layer o = parent._listLayer.remove(x);
            parent._listLayer.add(x + 1, o);
            this.listupLayers();
            this._process.resendProgramChange();
        }
    }

    private void jCheckBoxFixPanActionPerformed(ActionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        this.disableUnusedOnPanel();
    }

    private void jButtonImportActionPerformed(ActionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        this.doImportLayer();
    }

    private void jButtonExportActionPerformed(ActionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        this.doExportLayer();
    }

    private void jSpinnerSendFixedPanStateChanged(ChangeEvent evt) {
    }

    private void jCheckBoxRotateLayerActionPerformed(ActionEvent evt) {
        if (this.underConstruction) {
            return;
        }
        this.disableUnusedOnPanel();
    }

    private void jButtonWatchPortMousePressed(MouseEvent evt) {
        JPopupMenu menu = new JPopupMenu();
        if (!this.jButtonWatchPort.isEnabled()) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            String name = MXUtilMidi.nameOfPortOutput(i);
            JMenuItem item = new JMenuItem(name);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MX40View.this.jButtonWatchPort.setText(e.getActionCommand());
                }
            });
            menu.add(item);
        }
        menu.show(this.jButtonWatchPort, 0, this.jButtonWatchPort.getHeight());
    }

    private void jButtonWatchPortActionPerformed(ActionEvent evt) {
    }

    private void jButtonSendPortMousePressed(MouseEvent evt) {
        JPopupMenu menu = new JPopupMenu();
        if (!this.jButtonSendPort.isEnabled()) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            String name = MXUtilMidi.nameOfPortOutput(i);
            JMenuItem item = new JMenuItem(name);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MX40View.this.jButtonSendPort.setText(e.getActionCommand());
                }
            });
            menu.add(item);
        }
        menu.show(this.jButtonSendPort, 0, this.jButtonSendPort.getHeight());
    }

    public void doImportLayer() {
        MXFileOpenChooser chooser = new MXFileOpenChooser();
        chooser.addExtension(".xml", "XML File");
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(this) == 0) {
            final File file = chooser.getSelectedFile();
            this._process.importSetting(file);
            this._process.resendProgramChange();
            this.justRefreshViewListAndPanel();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(MX40View.this, "Succeed Import [" + file + "]");
                }
            });
        }
    }

    public void doExportLayer() {
        JFileChooser chooser = new JFileChooser();
        if (chooser.showSaveDialog(this) == 0) {
            File file = chooser.getSelectedFile();
            this._process.exportSetting(file);
            JOptionPane.showMessageDialog(this, "Succeed Export [" + file + "]");
        }
    }

    public void recursibleEnable(Component c, boolean enable) {
        if (c instanceof Container) {
            Container parent = (Container)c;
            int count = parent.getComponentCount();
            for (int x = 0; x < count; ++x) {
                this.recursibleEnable(parent.getComponent(x), enable);
            }
        }
        if (c instanceof JComponent) {
            ((JComponent)c).setEnabled(enable);
        }
    }

    public void readGroupFromPanel(MX40Group group) {
        int watchPort;
        group._title = this.jTextFieldGroupName.getText();
        group._isWatchPort = this.jCheckBoxPort.isSelected();
        group._isWatchChannel = this.jCheckBoxChannel.isSelected();
        group._isWatchBank = this.jCheckBoxBank.isSelected();
        group._isWatchProgram = this.jCheckBoxProgram.isSelected();
        group._isRotate = this.jCheckBoxRotateLayer.isSelected();
        group._rotatePoly = (Integer)this.jSpinnerRotatePoly.getValue();
        String text = this.jButtonWatchPort.getText();
        group._watchingPort = watchPort = text.length() >= 1 ? text.charAt(0) - 65 : -1;
        group._watchingChannel = (Integer)((MXWrap)this.jComboBoxWatchChannel.getSelectedItem()).value;
        group._watchingProgram = (Integer)this.jSpinnerWatchProgram.getValue();
        group._watchingBankMSB = (Integer)this.jSpinnerWatchBankMSB.getValue();
        group._watchingBankLSB = (Integer)this.jSpinnerWatchBankLSB.getValue();
    }

    public void writeGroupToPanel(MX40Group group) {
        this._editingGroup = group;
        if (group == null) {
            this.jPanelGroup.setBorder(BorderFactory.createTitledBorder("New Group"));
            group = new MX40Group(this._process);
        } else {
            this.jListGroupList.setSelectedIndex(this._groupsModel.indexOfValue(group));
            this.jPanelGroup.setBorder(BorderFactory.createTitledBorder("Editing Group [" + group._title + "]"));
        }
        this.jTextFieldGroupName.setText(group._title);
        this.jCheckBoxPort.setSelected(group._isWatchPort);
        this.jCheckBoxChannel.setSelected(group._isWatchChannel);
        this.jCheckBoxBank.setSelected(group._isWatchBank);
        this.jCheckBoxProgram.setSelected(group._isWatchProgram);
        this.jCheckBoxRotateLayer.setSelected(group._isRotate);
        this.jSpinnerRotatePoly.setValue(group._rotatePoly);
        this.jButtonWatchPort.setText(MXUtilMidi.nameOfPortShort(group._watchingPort));
        this.jComboBoxWatchChannel.setSelectedIndex(this._watchChannel.indexOfValue(group._watchingChannel));
        this.jSpinnerWatchProgram.setValue(group._watchingProgram);
        this.jSpinnerWatchBankMSB.setValue(group._watchingBankMSB);
        this.jSpinnerWatchBankLSB.setValue(group._watchingBankLSB);
    }

    public void readLayerFromPanel(MX40Layer layer) {
        int sendPort;
        layer._title = this.jTextFieldLayerName.getText();
        layer._modPort = this._modPort.readCombobox(this.jComboBoxModPort);
        layer._modChannel = this._modChannel.readCombobox(this.jComboBoxModChannel);
        layer._modBank = this._modBank.readCombobox(this.jComboBoxModBank);
        layer._modProgram = this._modProgram.readCombobox(this.jComboBoxModProgram);
        layer._modPan = this.jCheckBoxFixPan.isSelected() ? 2 : 1;
        String text = this.jButtonSendPort.getText();
        layer._fixedPort = sendPort = text.length() >= 1 ? text.charAt(0) - 65 : -1;
        layer._fixedChannel = this._changeChannel.readCombobox(this.jComboBoxSendChannel);
        layer._fixedBankMSB = (Integer)this.jSpinnerSendBankMSB.getValue();
        layer._fixedBankLSB = (Integer)this.jSpinnerSendBankLSB.getValue();
        layer._fixedProgram = (Integer)this.jSpinnerSendProgram.getValue();
        layer._fixedPan = (Integer)this.jSpinnerSendFixedPan.getValue();
        layer._adjustTranspose = (Integer)this.jSpinnerSendAdjustTranspose.getValue();
        layer._adjustVelocity = (Integer)this.jSpinnerSendAdjustVelocity.getValue();
        layer._adjustExpression = (Integer)this.jSpinnerSendAdjustExpression.getValue();
        layer.setAcceptKeyLowest(this._changeLowNote.readCombobox(this.jComboBoxSendNoteLow));
        layer.setAcceptKeyHighest(this._changeHighNote.readCombobox(this.jComboBoxSendNoteHigh));
        layer.setAcceptVelocityLowest(this._changeLowVelocity.readCombobox(this.jComboBoxSendVelocityLow));
        layer.setAcceptVelocityHighest(this._changeHighVelocity.readCombobox(this.jComboBoxSendVelocityHi));
    }

    public void writeLayerToPanel(MX40Layer layer) {
        this._editingLayer = layer;
        if (layer == null) {
            if (this._editingGroup != null) {
                layer = new MX40Layer(this._process, this._editingGroup);
                this.jPanelLayer.setBorder(BorderFactory.createTitledBorder(layer._title));
            } else {
                layer = new MX40Layer(this._process, this._editingGroup);
                this.jPanelLayer.setBorder(BorderFactory.createTitledBorder("Select Group 1st"));
            }
        } else {
            this.jListLayerList.setSelectedIndex(this._layersModel.indexOfValue(this._editingLayer));
            this.jPanelLayer.setBorder(BorderFactory.createTitledBorder("Editing Layer [" + layer._title + "]"));
        }
        this.jTextFieldLayerName.setText(layer._title);
        this._modPort.writeComboBox(this.jComboBoxModPort, layer._modPort);
        this._modChannel.writeComboBox(this.jComboBoxModChannel, layer._modChannel);
        this._modBank.writeComboBox(this.jComboBoxModBank, layer._modBank);
        this._modProgram.writeComboBox(this.jComboBoxModProgram, layer._modProgram);
        this.jButtonSendPort.setText(MXUtilMidi.nameOfPortShort(layer._fixedPort));
        this._changeChannel.writeComboBox(this.jComboBoxSendChannel, layer._fixedChannel);
        this.jSpinnerSendProgram.setValue(layer._fixedProgram);
        this.jSpinnerSendBankMSB.setValue(layer._fixedBankMSB);
        this.jSpinnerSendBankLSB.setValue(layer._fixedBankLSB);
        this.jCheckBoxFixPan.setSelected(layer._modPan == 2);
        this.jSpinnerSendFixedPan.setModel(new SafeSpinnerNumberModel(layer._fixedPan, 0, 127, 1));
        this.jSpinnerSendAdjustExpression.setModel(new SafeSpinnerNumberModel(layer._adjustExpression, 0, 100, 1));
        this.jSpinnerSendAdjustTranspose.setModel(new SafeSpinnerNumberModel(layer._adjustTranspose, -128, 128, 1));
        this.jSpinnerSendAdjustVelocity.setModel(new SafeSpinnerNumberModel(layer._adjustVelocity, -128, 128, 1));
        this._changeLowNote.writeComboBox(this.jComboBoxSendNoteLow, layer.getAcceptKeyLowest());
        this._changeHighNote.writeComboBox(this.jComboBoxSendNoteHigh, layer.getAcceptKeyHighest());
        this._changeLowVelocity.writeComboBox(this.jComboBoxSendVelocityLow, layer.getAcceptVelocityLowest());
        this._changeHighVelocity.writeComboBox(this.jComboBoxSendVelocityHi, layer.getAcceptVelocityHighest());
    }

    public void startNewGroupAndLayer() {
        MX40Group group = new MX40Group(this._process);
        this.readGroupFromPanel(group);
        String newPrefix = group._title;
        if (newPrefix == null || newPrefix.isEmpty() || newPrefix.isBlank()) {
            newPrefix = "Group";
        }
        String newTitle = newPrefix;
        while (true) {
            boolean already = false;
            for (int i = 0; i < this._process._groupList.size(); ++i) {
                String title = this._process._groupList.get((int)i)._title;
                if (!title.equals(newTitle)) continue;
                already = true;
            }
            if (!already) break;
            newTitle = this.randomName(newPrefix);
        }
        group._title = newTitle;
        this._process._groupList.add(group);
        MX40Layer layer = new MX40Layer(this._process, group);
        layer._title = this.jTextFieldLayerName.getText();
        this.startNewLayer(group, layer);
    }

    public void startNewLayer(MX40Group group, MX40Layer layer) {
        String newPrefix = layer._title;
        if (newPrefix == null || newPrefix.isEmpty() || newPrefix.isBlank()) {
            newPrefix = "Layer";
        }
        String newTitle = newPrefix;
        while (true) {
            boolean already = false;
            for (int i = 0; i < group._listLayer.size(); ++i) {
                String title = group._listLayer.get((int)i)._title;
                if (!title.equals(newTitle)) continue;
                already = true;
            }
            if (!already) break;
            newTitle = this.randomName(newPrefix);
        }
        layer._title = newTitle;
        group._listLayer.add(layer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startEditingPack(int group, int layer) {
        this.underConstruction = true;
        try {
            int ret;
            MX40Group newStartGroup = null;
            MX40Layer newStartLayer = null;
            try {
                newStartGroup = this._process._groupList.get(group);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                newStartLayer = newStartGroup._listLayer.get(layer);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (newStartGroup == this._editingGroup && newStartLayer == this._editingLayer) {
                return;
            }
            MX40Group panelGroup = new MX40Group(this._process);
            this.readGroupFromPanel(panelGroup);
            boolean askGroupChanged = false;
            if (this._editingGroup != null && !panelGroup.equals(this._editingGroup) && this._process._groupList.contains(this._editingGroup)) {
                askGroupChanged = true;
                if (newStartGroup == this._editingGroup) {
                    askGroupChanged = false;
                }
            }
            MX40Layer panelLayer = new MX40Layer(this._process, null);
            this.readLayerFromPanel(panelLayer);
            boolean askProgramChanged = false;
            if (this._editingLayer != null && !panelLayer.equals(this._editingLayer) && (this._editingGroup == null || this._editingGroup._listLayer.contains(this._editingLayer))) {
                askProgramChanged = true;
                if (newStartLayer == this._editingLayer) {
                    askProgramChanged = false;
                }
            }
            if (askGroupChanged) {
                this._editingGroup.caneChageTo(panelGroup);
                ret = JOptionPane.showConfirmDialog(this, "Will discard Changes", "Group Changed", 2);
                if (ret == 2) {
                    this.jListGroupList.setSelectedIndex(this._groupsModel.indexOfValue(this._editingGroup));
                    this.jListLayerList.setSelectedIndex(this._layersModel.indexOfValue(this._editingLayer));
                    return;
                }
            }
            if (askProgramChanged && (ret = JOptionPane.showConfirmDialog(this, "Will discard Changes", "Layer Changed", 2)) == 2) {
                this.jListGroupList.setSelectedIndex(this._groupsModel.indexOfValue(this._editingGroup));
                this.jListLayerList.setSelectedIndex(this._layersModel.indexOfValue(this._editingLayer));
                return;
            }
            this._editingGroup = newStartGroup;
            this._editingLayer = newStartLayer;
            this.listUpGroups();
            this.listupLayers();
            this.writeGroupToPanel(this._editingGroup);
            this.writeLayerToPanel(this._editingLayer);
        }
        finally {
            try {
                this.disableUnusedOnPanel();
            }
            catch (Exception exception) {}
            this.underConstruction = false;
        }
    }

    public void listUpGroups() {
        MXWrapList<MX40Group> listModel = new MXWrapList<MX40Group>();
        for (int i = 0; i < this._process._groupList.size(); ++i) {
            MX40Group g = this._process._groupList.get(i);
            listModel.addNameAndValue(g._title, g);
            if (this._editingGroup != g) continue;
            listModel.setSelectedItem(g);
        }
        this._groupsModel = listModel;
        this.jListGroupList.setModel(this._groupsModel);
        this.repaint();
    }

    public void listupLayers() {
        MX40Group parent = this._editingGroup;
        MXWrapList<MX40Layer> listModel = new MXWrapList<MX40Layer>();
        if (parent != null) {
            for (int i = 0; i < parent._listLayer.size(); ++i) {
                MX40Layer l = parent._listLayer.get(i);
                listModel.addNameAndValue(l._title, l);
                if (this._editingLayer != l) continue;
                listModel.setSelectedItem(l);
            }
        }
        this._layersModel = listModel;
        this.jListLayerList.setModel(listModel);
        this.repaint();
    }

    public String randomName(String prefix) {
        char ch;
        while (prefix.length() > 0 && (ch = prefix.charAt(prefix.length() - 1)) >= '0' && ch <= '9') {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        long x = 0L;
        while ((x = (long)(Math.random() * 8999.0 + 1000.0)) < 1000L || x >= 10000L) {
        }
        return prefix + Integer.toString((int)x);
    }

    public void justRefreshViewListAndPanel() {
        int indexGroup = -1;
        int indexLayer = -1;
        try {
            indexGroup = this._process._groupList.indexOf(this._editingGroup);
            indexLayer = this._editingGroup._listLayer.indexOf(this._editingLayer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.justRefreshViewListAndPanel(indexGroup, indexLayer);
    }

    public void justRefreshViewListAndPanel(int indexGroup, int indexLayer) {
        MXWrapList<MX40Group> groupModel = new MXWrapList<MX40Group>();
        for (int i = 0; i < this._process._groupList.size(); ++i) {
            MX40Group group = this._process._groupList.get(i);
            groupModel.addNameAndValue(group._title, group);
        }
        MXWrapList<MX40Layer> layerModel = new MXWrapList<MX40Layer>();
        if (this._editingGroup != null) {
            for (int i = 0; i < this._editingGroup._listLayer.size(); ++i) {
                MX40Layer layer = this._editingGroup._listLayer.get(i);
                layerModel.addNameAndValue(layer._title, layer);
            }
        }
        this.jListGroupList.setModel(groupModel);
        if (indexGroup >= 0) {
            this.jListGroupList.setSelectedIndex(indexGroup);
        }
        this.jListLayerList.setModel(layerModel);
        if (indexLayer >= 0) {
            this.jListLayerList.setSelectedIndex(indexLayer);
        }
        this.startEditingPack(indexGroup, indexLayer);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.updateRequest = true;
        MXTimer.letsCountdown(500L, new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (MX40View.this.updateRequest) {
                            MX40View.this.updateRequest = false;
                        }
                        MX40View.this.jTable1.invalidate();
                        MX40View.this.jTable2.invalidate();
                    }
                });
            }
        });
    }
}

