/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx30controller;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.MXStatic;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.MXWrap;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.settings.MXSetting;
import jp.synthtarou.midimixer.libs.swing.MXFileOpenChooser;
import jp.synthtarou.midimixer.libs.swing.MXFocusGroup;
import jp.synthtarou.midimixer.mx30controller.InitializeConfirmPanel;
import jp.synthtarou.midimixer.mx30controller.MGCircle;
import jp.synthtarou.midimixer.mx30controller.MGPad;
import jp.synthtarou.midimixer.mx30controller.MGSlider;
import jp.synthtarou.midimixer.mx30controller.MGStatus;
import jp.synthtarou.midimixer.mx30controller.MX30ResizeMixerSetting;
import jp.synthtarou.midimixer.mx30controller.MX32MixerData;
import jp.synthtarou.midimixer.mx30controller.MX32MixerProcess;

public class MX32MixerView
extends JPanel {
    private static final MXDebugLines _debug = new MXDebugLines(MX32MixerView.class);
    MX32MixerProcess _process;
    MXFocusGroup _focusGroup;
    MXWrapList<Integer> chainModel;
    private JButton jButton3;
    private JCheckBox jCheckBoxSyncTogether;
    private JComboBox<String> jComboBoxChain;
    private JLabel jLabel1;
    private JLabel jLabelKeyTracker;
    private JList<String> jListABC;
    private JPanel jPanelControllers;
    private JPanel jPanelEdit;
    private JPanel jPanelSyncTo;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;

    public MX32MixerView(MX32MixerProcess process) {
        int port = process._port;
        this._process = process;
        this.initComponents();
        this.chainModel = new MXWrapList();
        this.chainModel.addNameAndValue(MXUtilMidi.nameOfPortShort(-1), -1);
        for (int p2 = 0; p2 < 16; ++p2) {
            if (p2 == port) continue;
            this.chainModel.addNameAndValue(MXUtilMidi.nameOfPortShort(p2), p2);
        }
        this.jComboBoxChain.setModel(this.chainModel);
        if (port == 0) {
            MXMain.getMain().addLaunchSequence(new Runnable(){

                @Override
                public void run() {
                    MX32MixerView.this._process._parent.showTextForFocus(2, 0, 0, 0);
                }
            });
        }
        this.jLabelKeyTracker.setFocusable(true);
        this.jSplitPane1.setDividerLocation(this.getWidth() - 250);
        this.updateUI();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanelControllers = new JPanel();
        this.jPanelSyncTo = new JPanel();
        this.jComboBoxChain = new JComboBox();
        this.jCheckBoxSyncTogether = new JCheckBox();
        this.jPanelEdit = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jListABC = new JList();
        this.jLabelKeyTracker = new JLabel();
        this.jLabel1 = new JLabel();
        this.jButton3 = new JButton();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MX32MixerView.this.formFocusGained(evt);
            }
        });
        this.setLayout(new BoxLayout(this, 2));
        this.jSplitPane1.setDividerLocation(500);
        this.jPanelControllers.setLayout(new BoxLayout(this.jPanelControllers, 2));
        this.jSplitPane1.setLeftComponent(this.jPanelControllers);
        this.jPanelSyncTo.setLayout(new GridBagLayout());
        this.jComboBoxChain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX32MixerView.this.jComboBoxChainActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanelSyncTo.add(this.jComboBoxChain, gridBagConstraints);
        this.jCheckBoxSyncTogether.setText("Me Too (Message Chain)");
        this.jCheckBoxSyncTogether.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX32MixerView.this.jCheckBoxSyncTogetherActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanelSyncTo.add((Component)this.jCheckBoxSyncTogether, gridBagConstraints);
        this.jPanelEdit.setBorder(BorderFactory.createTitledBorder("Target Information"));
        this.jPanelEdit.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.jListABC);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelEdit.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabelKeyTracker.setForeground(new JLabel().getBackground());
        this.jLabelKeyTracker.setText("<HTML>PC Key<br>[Cursor]<br>[Space]<br>[Back:]</HTML>");
        this.jLabelKeyTracker.setFocusCycleRoot(true);
        this.jLabelKeyTracker.setFocusTraversalPolicyProvider(true);
        this.jLabelKeyTracker.setVerifyInputWhenFocusTarget(false);
        this.jLabelKeyTracker.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MX32MixerView.this.jLabelKeyTrackerFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                MX32MixerView.this.jLabelKeyTrackerFocusLost(evt);
            }
        });
        this.jLabelKeyTracker.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MX32MixerView.this.jLabelKeyTrackerKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.jPanelEdit.add((Component)this.jLabelKeyTracker, gridBagConstraints);
        this.jLabelKeyTracker.getAccessibleContext().setAccessibleName("Try Cursor<br>&Space+Back<br>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanelSyncTo.add((Component)this.jPanelEdit, gridBagConstraints);
        this.jLabel1.setText("Message Chain To");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.jPanelSyncTo.add((Component)this.jLabel1, gridBagConstraints);
        this.jButton3.setText("Customize Controllers");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX32MixerView.this.jButton3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanelSyncTo.add((Component)this.jButton3, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.jPanelSyncTo);
        this.add(this.jSplitPane1);
    }

    private void jComboBoxChainActionPerformed(ActionEvent evt) {
        Integer sel = (Integer)((MXWrap)this.jComboBoxChain.getSelectedItem()).value;
        int x = -1;
        if (sel != null) {
            x = sel;
        }
        this._process._patchToMixer = x;
    }

    private void jCheckBoxSyncTogetherActionPerformed(ActionEvent evt) {
        this._process._patchTogether = this.jCheckBoxSyncTogether.isSelected();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        JPopupMenu popup = new JPopupMenu();
        JRadioButtonMenuItem item1 = new JRadioButtonMenuItem("Edit Contoller");
        item1.setSelected(true);
        popup.add(item1);
        item1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MX32MixerView.this.doStartEditMixer();
            }
        });
        JMenuItem item2 = new JMenuItem("Initialize With...");
        popup.add(item2);
        item2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MX32MixerView.this.doInitializeMixer();
            }
        });
        JMenuItem item3 = new JMenuItem("Import Settings");
        popup.add(item3);
        item3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MX32MixerView.this.doImportMixer();
            }
        });
        JMenuItem item4 = new JMenuItem("Export Settings");
        popup.add(item4);
        item4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MX32MixerView.this.doExportMixer();
            }
        });
        JMenuItem item5 = new JMenuItem("Resize Mixer");
        popup.add(item5);
        item5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MX32MixerView.this.doResizeMixer();
            }
        });
        popup.show(this.jButton3, 20, this.jButton3.getHeight());
    }

    private void jLabelKeyTrackerKeyPressed(KeyEvent evt) {
        switch (evt.getKeyCode()) {
            case 8: 
            case 10: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this._process._parent.goNextFocus(this._process._port, evt.getKeyCode());
            }
        }
    }

    private void jLabelKeyTrackerFocusGained(FocusEvent evt) {
        if (this._focusGroup.getFocus() == null) {
            this._process._parent.goNextFocus(this._process._port, 0);
        }
        this.jLabelKeyTracker.setForeground(Color.red);
    }

    private void jLabelKeyTrackerFocusLost(FocusEvent evt) {
        this.jLabelKeyTracker.setForeground(this.jLabelKeyTracker.getBackground());
    }

    private void formFocusGained(FocusEvent evt) {
        this.jLabelKeyTracker.requestFocusInWindow();
    }

    public void doInitializeMixer() {
        InitializeConfirmPanel panel = new InitializeConfirmPanel(this._process);
        MXUtil.showAsDialog(this, panel, "Initialize Mixer");
        this.updateUI();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    MX32MixerData data = MX32MixerView.this._process._data;
                    for (int column = 0; column < 17; ++column) {
                        int row;
                        Color c = MXStatic.sliderColor(column);
                        for (row = 0; row < 4; ++row) {
                            MXUtil.backgroundRecursive(data.getCircle(row, column), c);
                        }
                        for (row = 0; row < 1; ++row) {
                            MXUtil.backgroundRecursive(data.getSlider(row, column), c);
                        }
                        for (row = 0; row < 3; ++row) {
                            MXUtil.backgroundRecursive(data.getDrumPad(row, column), c);
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    public void doImportMixer() {
        MXFileOpenChooser chooser = new MXFileOpenChooser();
        chooser.addExtension(".xml", "XML File");
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(this) == 0) {
            File file = chooser.getSelectedFile();
            MXSetting setting = new MXSetting(file, false);
            setting.setTarget(this._process);
            setting.readFile();
            this.updateUI();
            JOptionPane.showMessageDialog(this, "Succeed Import [" + file + "]");
            this.updateSliderFromStatus();
        }
    }

    public void doExportMixer() {
        JFileChooser chooser = new JFileChooser();
        if (chooser.showSaveDialog(this) == 0) {
            File file = chooser.getSelectedFile();
            MXSetting setting = new MXSetting(file, false);
            setting.setTarget(this._process);
            setting.writeToFile();
            JOptionPane.showMessageDialog(this, "Succeed Export [" + file + "]");
        }
    }

    public void doResizeMixer() {
        MX30ResizeMixerSetting config = new MX30ResizeMixerSetting(this._process._parent);
        MXUtil.showAsDialog(this, config, "Resize Mixer");
        if (config._okOption) {
            this._process._parent.globalContollerHidden();
        }
    }

    public void doStartEditMixer() {
        this._process._parent.enterEditMode(true);
    }

    public JPanel getControllerCase() {
        return this.jPanelControllers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initControllers() {
        MX32MixerProcess mixer = this._process;
        try {
            GridBagConstraints gbc;
            this._focusGroup = new MXFocusGroup();
            mixer._data.setEveryComponents(null, null, null);
            JPanel panel001 = this.getControllerCase();
            panel001.removeAll();
            panel001.setLayout(new GridBagLayout());
            int grindY = 0;
            ArrayList[] matrixCircle = new ArrayList[4];
            for (int row = 0; row < 4; ++row) {
                ArrayList<MGCircle> newCircle = new ArrayList<MGCircle>();
                int col = 0;
                while (col < 17) {
                    MGCircle cc1 = new MGCircle(this._process, row, col);
                    cc1.setSize(50, 50);
                    this._focusGroup.attach(cc1);
                    gbc = new GridBagConstraints();
                    gbc.gridx = col++;
                    gbc.gridy = grindY;
                    gbc.fill = 1;
                    gbc.anchor = 10;
                    gbc.weightx = 0.0;
                    gbc.weighty = 0.0;
                    panel001.add((Component)cc1, gbc);
                    newCircle.add(cc1);
                }
                matrixCircle[row] = newCircle;
                ++grindY;
            }
            ArrayList[] matrixSlider = new ArrayList[1];
            for (int row = 0; row < 1; ++row) {
                ArrayList<MGSlider> newSlider;
                matrixSlider[row] = newSlider = new ArrayList<MGSlider>();
                int col = 0;
                while (col < 17) {
                    MGSlider sc1 = new MGSlider(this._process, row, col);
                    this._focusGroup.attach(sc1);
                    sc1.setSize(50, 100);
                    gbc = new GridBagConstraints();
                    gbc.gridx = col++;
                    gbc.gridy = grindY;
                    gbc.fill = 1;
                    gbc.anchor = 10;
                    gbc.weightx = 1.0;
                    gbc.weighty = 1.0;
                    panel001.add((Component)sc1, gbc);
                    newSlider.add(sc1);
                }
            }
            ++grindY;
            ArrayList[] matrixPad = new ArrayList[3];
            for (int row = 0; row < 3; ++row) {
                ArrayList<MGPad> newPad = new ArrayList<MGPad>();
                int col = 0;
                while (col < 17) {
                    MGStatus number = mixer._data.getDrumPadStatus(row, col);
                    MGPad rc1 = new MGPad(this._process, row, col);
                    this._focusGroup.attach(rc1);
                    newPad.add(rc1);
                    rc1.setSize(50, 50);
                    gbc = new GridBagConstraints();
                    gbc.gridx = col++;
                    gbc.gridy = grindY;
                    gbc.fill = 1;
                    gbc.anchor = 10;
                    gbc.weightx = 1.0;
                    gbc.weighty = 0.0;
                    panel001.add((Component)rc1, gbc);
                }
                matrixPad[row] = newPad;
                ++grindY;
            }
            this._focusGroup.setFocusEnabled(true);
            int x = this.chainModel.indexOfValue(mixer._patchToMixer);
            this.jComboBoxChain.setSelectedIndex(x);
            mixer._data.setEveryComponents(matrixSlider, matrixCircle, matrixPad);
            this.jCheckBoxSyncTogether.setSelected(mixer._patchTogether);
        }
        finally {
            this.updateUI();
        }
    }

    public void updateSliderFromStatus() {
        this.initControllers();
    }

    public void setFocusString(String str) {
        ArrayList<String> list = new ArrayList<String>();
        MXUtil.split(str, list, '\n');
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (String line : list) {
            model.addElement(line);
        }
        this.jListABC.setModel(model);
        this.jLabelKeyTracker.requestFocus();
    }

    public void globalControllerHidden() {
        MX32MixerData data = this._process._data;
        int lines = this._process._parent.getActiveLines();
        for (int column = 0; column < 17; ++column) {
            int row;
            for (row = 0; row < 4; ++row) {
                if (this._process._parent.isKnobActive(row) && column < lines) {
                    data.getCircle(row, column).setVisible(true);
                    continue;
                }
                data.getCircle(row, column).setVisible(false);
            }
            for (row = 0; row < 1; ++row) {
                if (column < lines) {
                    data.getSlider(row, column).setVisible(true);
                    continue;
                }
                data.getSlider(row, column).setVisible(false);
            }
            for (row = 0; row < 3; ++row) {
                if (this._process._parent.isPadActive(row) && column < lines) {
                    data.getDrumPad(row, column).setVisible(true);
                    continue;
                }
                data.getDrumPad(row, column).setVisible(false);
            }
        }
    }
}

