/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx30controller;

import java.io.File;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXMessageTemplate;
import jp.synthtarou.midimixer.libs.midi.MXTraceNumber;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIInForPlayer;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant;
import jp.synthtarou.midimixer.mx00playlist.FileWithId;

public class MGStatus
implements Cloneable {
    public static final int SWITCH_ON_WHEN_ANY = 1;
    public static final int SWITCH_ON_IF_PLUS1 = 2;
    public static final int SWITCH_ON_IF_OVER_HALF = 3;
    public static final int SWITCH_ON_IF_MAX = 4;
    public static final int SWITCH_OUT_ON_SAME_AS_INPUT = 5;
    public static final int SWITCH_OUT_ON_CUSTOM = 6;
    public static final int SWITCH_OUT_ON_VALUE_AS_INPUT_PLUS1 = 8;
    public static final int SWITCH_OUT_ON_VALUE_AS_INPUT = 9;
    public static final int SWITCH_OUT_ON_VALUE_FIXED = 10;
    public static final int SWITCH_OUT_OFF_NONE = 11;
    public static final int SWITCH_OUT_OFF_SAME_AS_INPUT = 12;
    public static final int SWITCH_OUT_OFF_SAME_AS_OUTPUT_ON = 13;
    public static final int SWITCH_OUT_OFF_CUSTOM = 14;
    public static final int SWITCH_OUT_OFF_VALUE_0 = 15;
    public static final int SWITCH_OUT_OFF_VALUE_SAME_AS_MIN = 16;
    public static final int SWITCH_OUT_OFF_VALUE_SAME_AS_INPUT = 17;
    public static final int SWITCH_OUT_OFF_VALUE_FIXED = 18;
    public static final int SWITCH_HARMONY_VELOCITY_SAME_AS_INPUT = 19;
    public static final int SWITCH_HARMONY_VELOCITY_FIXED = 20;
    public static final int SWITCH_TYPE_ON = 1;
    public static final int SWITCH_TYPE_ONOFF = 2;
    public static final int SWITCH_TYPE_HARMONY = 4;
    public static final int SWITCH_TYPE_SEQUENCE = 5;
    private static final MXDebugLines _debug = new MXDebugLines(MGStatus.class);
    public static final int TYPE_CIRCLE = 1;
    public static final int TYPE_SLIDER = 2;
    public static final int TYPE_DRUMPAD = 3;
    public static final int TYPE_DRUMPAD_OUTSIGNAL = 4;
    public static final int SP_NONE = 255;
    public static final int SP_NOTE_ON = 0;
    public static final int SP_MESSAGE_VALUE = 16;
    public static final int SP_SYSTEM = 112;
    public static final int SP_PROG_UP = 128;
    public static final int SP_PROG_DOWN = 144;
    private int _port;
    private int _uiType;
    private int _row;
    private int _column;
    private String _name = "";
    private String _memo = "";
    private String _textCommand = "";
    private int _value = 0;
    private int _rangeMin = 0;
    private int _rangeMax = 127;
    private boolean _uiValueInvert = false;
    private int _valueHome = 0;
    private boolean _valueLastSent = false;
    private boolean _valueLastDetect = false;
    private int _gate = 0;
    private int _channel = 0;
    private int _switchLastDetected;
    private MXMessageTemplate _cachedMessage = null;
    private int _switchType = 2;
    private int _switchInputType = 2;
    private int _switchOutOnType = 5;
    private int _switchOutOnTypeOfValue = 9;
    private int _switchOutOnValueFixed = 127;
    private String _switchOutOnText = "";
    private int _switchOutOnTextGate = 0;
    MXMessageTemplate _cacheOutOnMessage = null;
    private int _switchOutOffType = 12;
    private int _switchOutOffTypeOfValue = 15;
    private int _switchOutOffValueFixed = 0;
    private String _switchOutOffText = "";
    private int _switchOutOffTextGate = 0;
    MXMessageTemplate _cacheOutOffMessage = null;
    private boolean _switchWithToggle = false;
    private int _switchHarmonyVelocityType = 19;
    private int _switchHarmonyVelocityFixed = 100;
    private String _switchHarmonyNotes = "";
    private String _switchSequencerFile = "";
    private boolean _switchSequenceSeekStart = true;
    private boolean _switchSequencerToSingltTrack = true;
    private boolean _switchSequencerFilterNote = true;
    private MXMIDIInForPlayer _switchSequencer = null;
    private int _switchSwitchOutPort = 0;
    private int _switchOutChannel = 0;
    private int _dataroomType = 0;
    private int _dataroomMSB = -1;
    private int _dataroomLSB = -1;
    private boolean _value14bit = false;

    public void setValue14bitAndZoom(boolean value14bit) {
        MXMessage message = this.toMXMessage(null);
        if (!message.canPaired14bit() && !message.hasValueHiField() && value14bit) {
            return;
        }
        if (!this._value14bit && this._rangeMax >= 128) {
            this._rangeMax = 127;
        }
        this._value14bit = value14bit;
    }

    public synchronized void setValue14bit(boolean value14bit) {
        this._value14bit = value14bit;
    }

    public int getSwitchOutPort() {
        return this._switchSwitchOutPort;
    }

    public void setSwitchOutPort(int switchSwitchOutPort) {
        this._switchSwitchOutPort = switchSwitchOutPort;
    }

    public int getDataroomType() {
        return this._dataroomType;
    }

    public void setDataroomType(int dataentryHave) {
        this._dataroomType = dataentryHave;
    }

    public int getDataeroomMSB() {
        return this._dataroomMSB;
    }

    public void setDataroomMSB(int _dataentryMSB) {
        this._dataroomMSB = _dataentryMSB;
    }

    public int getDataroomLSB() {
        return this._dataroomLSB;
    }

    public void setDataroomLSB(int _dataentryLSB) {
        this._dataroomLSB = _dataentryLSB;
    }

    public boolean isValue14bit() {
        return this._value14bit;
    }

    public MGStatus(int port, int uiType, int row, int column) {
        this._port = port;
        this._uiType = uiType;
        this._row = row;
        this._column = column;
    }

    public MXMessageTemplate getTemplate() {
        if (this._cachedMessage == null) {
            this._cachedMessage = MXMessageFactory.fromDtext(this.getTextCommand(), this.getChannel());
            if (this._cachedMessage == null) {
                return null;
            }
        }
        return this._cachedMessage;
    }

    public synchronized MXMessage toMXMessage(MXTraceNumber traceNumber) {
        this.getTemplate();
        MXMessage message = this._cachedMessage.bind(traceNumber, this._port, this._gate, this._value);
        message.setChannel(this._channel);
        message.setValue14bit(this.isValue14bit());
        if (this._cachedMessage.get(0) == 16384 || this._cachedMessage.get(0) == 16640) {
            MXVisitant visit = new MXVisitant();
            visit.setDataroomType(this.getDataroomType());
            visit.setDataroomMSB(this.getDataeroomMSB());
            visit.setDataroomLSB(this.getDataroomLSB());
            visit.setDataentry14(this._value);
            message.setVisitant(visit);
        }
        return message;
    }

    public synchronized MXMessage toMXMessageCaseDrumOn(MXTraceNumber traecNumber) {
        if (this.getSwitchOutOnType() == 5) {
            int value = this.getValueForSwitchOn();
            if (value < 0) {
                return null;
            }
            MXMessage message = this.toMXMessage(traecNumber);
            message.setValue(value);
            return message;
        }
        if (this.getSwitchOutOnType() == 6) {
            int value;
            if (this._cacheOutOnMessage == null) {
                this._cacheOutOnMessage = MXMessageFactory.fromDtext(this.getSwitchOutOnText(), 0);
                if (this._cacheOutOnMessage == null) {
                    return null;
                }
            }
            if ((value = this.getValueForSwitchOn()) < 0) {
                return null;
            }
            MXMessage message = this._cacheOutOnMessage.bind(traecNumber, this._port, this.getSwitchOutOnTextGate(), value);
            message.setChannel(this.getSwitchOutChannel());
            return message;
        }
        _debug.println("Error getMXMessageDrumON:getSwitchOutOnType=" + this.getSwitchOutOnType());
        return null;
    }

    public synchronized MXMessage toMXMessageCaseDrumOff(MXTraceNumber traceNumber) {
        if (this.getSwitchOutOffType() == 11) {
            return null;
        }
        if (this.getSwitchOutOffType() == 12) {
            int value = this.getValueForSwitchOff();
            if (value < 0) {
                return null;
            }
            MXMessage message = this.toMXMessage(traceNumber);
            message.setValue(value);
            return message;
        }
        if (this.getSwitchOutOffType() == 13) {
            int value = this.getValueForSwitchOff();
            if (value < 0) {
                return null;
            }
            MXMessage message = this.toMXMessageCaseDrumOn(traceNumber);
            message.setValue(value);
            return message;
        }
        if (this.getSwitchOutOffType() == 14) {
            int value;
            if (this._cacheOutOffMessage == null) {
                this._cacheOutOffMessage = MXMessageFactory.fromDtext(this.getSwitchOutOffText(), 0);
                if (this._cacheOutOffMessage == null) {
                    return null;
                }
            }
            if ((value = this.getValueForSwitchOff()) < 0) {
                return null;
            }
            MXMessage message = this._cacheOutOffMessage.bind(traceNumber, this._port, this.getSwitchOutOffTextGate(), value);
            message.setChannel(this.getSwitchOutChannel());
            return message;
        }
        _debug.println("Error getMXMessageDrumOff:getSwitchOutOffType=" + this.getSwitchOutOffType());
        return null;
    }

    public Object clone() {
        MGStatus status = new MGStatus(this.getPort(), this.getUiType(), this.getRow(), this.getColumn());
        status.setMonitoringTarget(this.getTextCommand(), this.getChannel(), this.getGate(), this.getValue());
        status.setName(this.getName());
        status.setMemo(this.getMemo());
        status.setRangeMin(this._rangeMin);
        status.setRangeMax(this._rangeMax);
        status.setUiValueInvert(this._uiValueInvert);
        status.setValueHome(this._valueHome);
        status.setValueLastSent(this._valueLastSent);
        status.setSwitchType(this.getSwitchType());
        status.setSwitchInputType(this.getSwitchInputType());
        status.setSwitchOutPort(this.getSwitchOutPort());
        status.setSwitchOutChannel(this.getSwitchOutChannel());
        status.setSwitchOutOnType(this.getSwitchOutOnType());
        status.setSwitchOutOnTypeOfValue(this.getSwitchOutOnTypeOfValue());
        status.setSwitchOutOnValueFixed(this.getSwitchOutOnValueFixed());
        status.setSwitchOutOnText(this.getSwitchOutOnText());
        status.setSwitchOutOnTextGate(this.getSwitchOutOnTextGate());
        status.setSwitchOutOffType(this.getSwitchOutOffType());
        status.setSwitchOutOffTypeOfValue(this.getSwitchOutOffTypeOfValue());
        status.setSwitchOutOffValueFixed(this.getSwitchOutOffValueFixed());
        status.setSwitchOutOffText(this.getSwitchOutOffText());
        status.setSwitchOutOffTextGate(this.getSwitchOutOffTextGate());
        status.setSwitchWithToggle(this.isSwitchWithToggle());
        status.setSwitchHarmonyVelocityType(this.getSwitchHarmonyVelocityType());
        status.setSwitchHarmonyVelocityFixed(this.getSwitchHarmonyVelocityFixed());
        status.setSwitchHarmonyNotes(this.getSwitchHarmonyNotes());
        status.setSwitchSequencerFile(this.getSwitchSequencerFile());
        status.setDataroomType(this.getDataroomType());
        status.setDataroomMSB(this.getDataeroomMSB());
        status.setDataroomLSB(this.getDataroomLSB());
        status.setValue14bit(this.isValue14bit());
        return status;
    }

    public synchronized void setMonitoringTarget(String textCommand, int channel, int gate, int value) {
        this.setTextCommand(textCommand);
        this._rangeMin = 0;
        this._rangeMax = 127;
        this._cachedMessage = null;
        this._channel = channel;
        this._gate = gate;
        this._value = value;
        try {
            if (this.toMXMessage(null).isValue14bit()) {
                this._rangeMax = 16383;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized String toString() {
        String text;
        MXMessage message = this.toMXMessage(null);
        switch (this.getUiType()) {
            case 1: {
                text = "Circle";
                break;
            }
            case 2: {
                text = "Slider";
                break;
            }
            case 3: {
                text = "Pad";
                break;
            }
            default: {
                message = null;
                text = "Error";
            }
        }
        String name = this._name == null || this._name.length() == 0 ? message.toShortString() : this._name;
        return name + " (" + this._memo + ")\n" + text + "[row " + (this.getRow() + 1) + ", col " + (this.getColumn() + 1) + "] \n" + message.toString() + (message.isValue14bit() ? " (=14bit)" : "");
    }

    public boolean statusTryCatch(MXMessage message) {
        MXMessage target = this.toMXMessage(message._traceNumber);
        if (this.haveSameStatusAndGate(message)) {
            MXVisitant visit = message.getVisitant();
            if (message.isDataentry()) {
                int original = this._value;
                int value = visit.getDataentryValue14();
                switch (message.getGate()) {
                    case 6: {
                        if (value >= this._rangeMin && value <= this._rangeMax) break;
                        return false;
                    }
                    case 96: {
                        value = original + 1;
                        if (value >= this._rangeMin && value <= this._rangeMax) break;
                        return false;
                    }
                    case 97: {
                        value = original - 1;
                        if (value >= this._rangeMin && value <= this._rangeMax) break;
                        return false;
                    }
                }
                if (value >= this._rangeMin && value <= this._rangeMax) {
                    this.setValue(value);
                    return true;
                }
                return false;
            }
            int value = message.getValue();
            if (message.getCommand() == 128) {
                this.setValue(0);
                return true;
            }
            if (value >= this._rangeMin && value <= this._rangeMax) {
                this.setValue(value);
                return true;
            }
            return false;
        }
        if (this.canFixWithTemplate(message)) {
            int value = target.importBytesUseTemplate(message);
            if (value >= this._rangeMin && value <= this._rangeMax) {
                this.setValue(value);
                return true;
            }
            return false;
        }
        return false;
    }

    public void fixRangedValue() {
        if (this.getValue() < this.getRangeMin()) {
            this.setValue(this.getRangeMin());
        }
        if (this.getValue() > this.getRangeMax()) {
            this.setValue(this.getRangeMax());
        }
        if (this.getRangeMin() > this.getRangeMax()) {
            this.setRangeMax(this.getRangeMin());
        }
    }

    public boolean isDrumOn(int value) {
        switch (this.getSwitchInputType()) {
            case 1: {
                return true;
            }
            case 2: {
                return value >= this.getRangeMin() + 1;
            }
            case 3: {
                return value >= (this.getRangeMin() + this.getRangeMax()) / 2;
            }
            case 4: {
                return value == this.getRangeMax();
            }
        }
        _debug.println("isDrumOn = " + this.getSwitchInputType());
        return false;
    }

    public int getValueForSwitchOn() {
        switch (this.getSwitchOutOnType()) {
            case 5: 
            case 6: {
                switch (this.getSwitchOutOnTypeOfValue()) {
                    case 9: {
                        return this.getSwitchLastDetected();
                    }
                    case 8: {
                        int x = this.getSwitchLastDetected();
                        if (x == this.getRangeMin() && x < this.getRangeMax()) {
                            ++x;
                        }
                        return x;
                    }
                    case 10: {
                        return this.getSwitchOutOnValueFixed();
                    }
                }
            }
        }
        return 0;
    }

    public int getValueForSwitchOff() {
        switch (this.getSwitchOutOffType()) {
            case 11: {
                return -1;
            }
            case 12: 
            case 13: 
            case 14: {
                switch (this.getSwitchOutOnTypeOfValue()) {
                    case 15: {
                        return 0;
                    }
                    case 18: {
                        return this.getSwitchOutOffValueFixed();
                    }
                    case 17: {
                        return this.getSwitchLastDetected();
                    }
                    case 16: {
                        return this.getRangeMin();
                    }
                }
            }
        }
        return 0;
    }

    public String getSwitchOutOffText() {
        return this._switchOutOffText;
    }

    public void setSwitchOutOffText(String switchOutOffText) {
        this._switchOutOffText = switchOutOffText;
        this._cacheOutOffMessage = null;
    }

    public int getSwitchOutOffTextGate() {
        return this._switchOutOffTextGate;
    }

    public void setSwitchOutOffTextGate(int switchOutOffTextGate) {
        this._switchOutOffTextGate = switchOutOffTextGate;
    }

    public String getSwitchOutOnText() {
        return this._switchOutOnText;
    }

    public void setSwitchOutOnText(String switchOutOnText) {
        this._switchOutOnText = switchOutOnText;
        this._cacheOutOnMessage = null;
    }

    public int getSwitchOutOnTextGate() {
        return this._switchOutOnTextGate;
    }

    public void setSwitchOutOnTextGate(int switchOutOnTextGate) {
        this._switchOutOnTextGate = switchOutOnTextGate;
    }

    protected int getSwitchOutOffValueFixed() {
        return this._switchOutOffValueFixed;
    }

    protected void setSwitchOutOffValueFixed(int switchOutOffValueFixed) {
        this._switchOutOffValueFixed = switchOutOffValueFixed;
    }

    protected int getSwitchType() {
        return this._switchType;
    }

    protected void setSwitchType(int switchType) {
        this._switchType = switchType;
    }

    protected int getSwitchInputType() {
        return this._switchInputType;
    }

    protected void setSwitchInputType(int switchInputType) {
        this._switchInputType = switchInputType;
    }

    protected int getSwitchOutOnType() {
        return this._switchOutOnType;
    }

    protected void setSwitchOutOnType(int switchOutOnType) {
        this._switchOutOnType = switchOutOnType;
    }

    protected int getSwitchOutOnTypeOfValue() {
        return this._switchOutOnTypeOfValue;
    }

    protected void setSwitchOutOnTypeOfValue(int switchOutOnValue) {
        this._switchOutOnTypeOfValue = switchOutOnValue;
    }

    protected int getSwitchOutOnValueFixed() {
        return this._switchOutOnValueFixed;
    }

    protected void setSwitchOutOnValueFixed(int switchOutOnValueFixed) {
        this._switchOutOnValueFixed = switchOutOnValueFixed;
    }

    protected int getSwitchOutOffType() {
        return this._switchOutOffType;
    }

    protected void setSwitchOutOffType(int switchOutOffType) {
        this._switchOutOffType = switchOutOffType;
    }

    protected int getSwitchOutOffTypeOfValue() {
        return this._switchOutOffTypeOfValue;
    }

    protected void setSwitchOutOffTypeOfValue(int switchOutOffValue) {
        this._switchOutOffTypeOfValue = switchOutOffValue;
    }

    protected int getSwitchOutChannel() {
        return this._switchOutChannel;
    }

    protected void setSwitchOutChannel(int switchHarmonyChannel) {
        this._switchOutChannel = switchHarmonyChannel;
    }

    protected int getSwitchHarmonyVelocityType() {
        return this._switchHarmonyVelocityType;
    }

    protected void setSwitchHarmonyVelocityType(int switchHarmonyVelocityType) {
        this._switchHarmonyVelocityType = switchHarmonyVelocityType;
    }

    protected int getSwitchHarmonyVelocityFixed() {
        return this._switchHarmonyVelocityFixed;
    }

    protected void setSwitchHarmonyVelocityFixed(int switchHarmonyVelocityFixed) {
        this._switchHarmonyVelocityFixed = switchHarmonyVelocityFixed;
    }

    protected String getSwitchHarmonyNotes() {
        return this._switchHarmonyNotes;
    }

    protected void setSwitchHarmonyNotes(String switchHarmonyNotes) {
        this._switchHarmonyNotes = switchHarmonyNotes;
    }

    protected String getSwitchSequencerFile() {
        return this._switchSequencerFile;
    }

    protected void setSwitchSequencerFile(String switchSequencerFile) {
        File f;
        if (switchSequencerFile != null && this._switchSequencerFile != null && switchSequencerFile.equals(this._switchSequencerFile)) {
            return;
        }
        this._switchSequencerFile = switchSequencerFile;
        if (this._switchSequencer != null) {
            this._switchSequencer.stopSequencer();
        }
        this._switchSequencer = null;
        if (switchSequencerFile != null && !switchSequencerFile.isEmpty() && (f = new File(switchSequencerFile)).exists()) {
            try {
                MXMIDIInForPlayer player = new MXMIDIInForPlayer();
                player.openFile(new FileWithId(f));
                this._switchSequencer = player;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int getSwitchLastDetected() {
        return this._switchLastDetected;
    }

    public void setSwitchLastDetected(int switchLastDetected) {
        this._switchLastDetected = switchLastDetected;
    }

    public int getPort() {
        return this._port;
    }

    public synchronized void setPort(int port) {
        this._port = port;
    }

    public int getUiType() {
        return this._uiType;
    }

    public synchronized void setUiType(int uiType) {
        this._cachedMessage = null;
        this._uiType = uiType;
    }

    public int getRow() {
        return this._row;
    }

    public synchronized void setRow(int row) {
        this._row = row;
    }

    public int getColumn() {
        return this._column;
    }

    public synchronized void setColumn(int column) {
        this._column = column;
    }

    public String getName() {
        return this._name;
    }

    public synchronized void setName(String name) {
        this._name = name;
    }

    public String getMemo() {
        return this._memo;
    }

    public synchronized void setMemo(String memo) {
        this._memo = memo;
    }

    public String getTextCommand() {
        return this._textCommand;
    }

    public synchronized void setTextCommand(String textCommand) {
        this._cachedMessage = null;
        if (textCommand == null) {
            textCommand = "00, 00, 00";
        }
        this._textCommand = textCommand;
    }

    public int getValue() {
        return this._value;
    }

    public synchronized void setValue(int value) {
        if (value > 16383) {
            value = 16383;
        }
        this._value = value;
    }

    public int getRangeMin() {
        return this._rangeMin;
    }

    public synchronized void setRangeMin(int rangeMin) {
        if (rangeMin > 16383) {
            rangeMin = 16383;
        }
        this._rangeMin = rangeMin;
    }

    public int getRangeMax() {
        return this._rangeMax;
    }

    public synchronized void setRangeMax(int rangeMax) {
        if (rangeMax > 16383) {
            rangeMax = 16383;
        }
        this._rangeMax = rangeMax;
    }

    public boolean isUiValueInvert() {
        return this._uiValueInvert;
    }

    public synchronized void setUiValueInvert(boolean uiValueInvert) {
        this._uiValueInvert = uiValueInvert;
    }

    public int getValueHome() {
        return this._valueHome;
    }

    public synchronized void setValueHome(int valueHome) {
        this._valueHome = valueHome;
    }

    public boolean isValueLastSent() {
        return this._valueLastSent;
    }

    public synchronized void setValueLastSent(boolean valueLastSent) {
        this._valueLastSent = valueLastSent;
    }

    public boolean getValueLastSent() {
        return this._valueLastSent;
    }

    public int getGate() {
        return this._gate;
    }

    public synchronized void setGate(int gate) {
        this._gate = gate;
    }

    public int getChannel() {
        return this._channel;
    }

    public synchronized void setChannel(int channel) {
        this._channel = channel;
    }

    public boolean isSwitchWithToggle() {
        if (this.getSwitchType() != 1) {
            return this._switchWithToggle;
        }
        return false;
    }

    public void setSwitchWithToggle(boolean switchWithToggle) {
        this._switchWithToggle = switchWithToggle;
    }

    public boolean isSwitchSequenceSeekStart() {
        return this._switchSequenceSeekStart;
    }

    public void setSwitchSequenceSeekStart(boolean switchSequenceSeekStart) {
        this._switchSequenceSeekStart = switchSequenceSeekStart;
    }

    public boolean isSwitchSequencerToSingltTrack() {
        return this._switchSequencerToSingltTrack;
    }

    public void setSwitchSequencerToSingltTrack(boolean switchSequencerToSingltTrack) {
        this._switchSequencerToSingltTrack = switchSequencerToSingltTrack;
    }

    public boolean isSwitchSequencerFilterNote() {
        return this._switchSequencerFilterNote;
    }

    public void setSwitchSequencerFilterNote(boolean switchSequencerFilterNote) {
        this._switchSequencerFilterNote = switchSequencerFilterNote;
    }

    public void startSequence() {
        if (this._switchSequencer != null) {
            this._switchSequencer.open();
            this._switchSequencer.setOutPort(this.getSwitchOutPort());
            if (this._switchSequencerToSingltTrack) {
                this._switchSequencer.setPlayAsSingleChannel(this._switchOutChannel);
            } else {
                this._switchSequencer.setPlayAsSingleChannel(-1);
            }
            this._switchSequencer.setOnlyNotePitchWheel(this._switchSequencerFilterNote);
            if (this._switchSequenceSeekStart) {
                this._switchSequencer.setCurrentPos(this._switchSequencer.getFirstNotePos());
                this._switchSequencer.startSequencer();
            } else {
                this._switchSequencer.setCurrentPos(0);
                this._switchSequencer.startSequencer();
            }
        }
    }

    public void stopSequence() {
        if (this._switchSequencer != null) {
            this._switchSequencer.stopSequencer();
        }
    }

    public boolean isValueLastDetect() {
        return this._valueLastDetect;
    }

    public void setValueLastDetect(boolean _valueLastDetect) {
        this._valueLastDetect = _valueLastDetect;
    }

    public boolean haveSameStatusAndGate(MXMessage message) {
        MXMessage from = this.toMXMessage(null);
        if ((from.isDataentry() || message.isDataentry()) && from.isDataentry() == message.isDataentry()) {
            return from.getVisitant().getBankLSB() == message.getVisitant().getBankLSB() && from.getVisitant().getBankMSB() == message.getVisitant().getBankMSB() && from.getVisitant().getDataroomType() == message.getVisitant().getDataroomType() && this._channel == message.getChannel();
        }
        if (message.isMessageTypeChannel()) {
            if (this._channel != message.getChannel()) {
                return false;
            }
            if (from.getCommand() == 144 || from.getCommand() == 128) {
                if (message.getCommand() == 144 || message.getCommand() == 128) {
                    return from.getGate() == message.getGate();
                }
                return false;
            }
            if (from.getCommand() == message.getCommand()) {
                if (from.getCommand() == 176) {
                    int cc1 = from.getGate();
                    int cc2 = message.getGate();
                    if (cc1 != message.getGate()) {
                        if (cc1 >= 0 && cc1 <= 31 && cc1 + 32 == cc2) {
                            return true;
                        }
                        return cc2 >= 0 && cc2 <= 31 && cc2 + 32 == cc1;
                    }
                    return true;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean canFixWithTemplate(MXMessage message) {
        MXMessage from = this.toMXMessage(null);
        byte[] byteFrom = from.getDataBytes();
        byte[] byteTo = message.getDataBytes();
        if (byteFrom == null) {
            return byteTo == null;
        }
        if (byteTo == null) {
            return false;
        }
        if (byteFrom.length != byteTo.length) {
            return false;
        }
        int hitcount = 0;
        int faultcont = 0;
        int ignorecount = 0;
        for (int i = 0; i < byteFrom.length; ++i) {
            if (byteFrom[i] == byteTo[i]) {
                ++hitcount;
                continue;
            }
            if (byteFrom[i] == byteTo[i]) continue;
            int fromX = from.getTemplate(i);
            if (fromX == 768 || fromX == 512 || fromX == 9728) {
                ++ignorecount;
                continue;
            }
            int messageX = message.getTemplate(i);
            if (messageX == 768 || messageX == 512 || messageX == 9728) {
                ++ignorecount;
                continue;
            }
            ++faultcont;
        }
        return faultcont == 0;
    }
}

