/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx30controller;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXTraceNumber;
import jp.synthtarou.midimixer.libs.swing.MXFocusAble;
import jp.synthtarou.midimixer.libs.swing.MXFocusGroupElement;
import jp.synthtarou.midimixer.libs.swing.MXSliderUIForTablet;
import jp.synthtarou.midimixer.mx30controller.MGStatus;
import jp.synthtarou.midimixer.mx30controller.MGStatusConfig;
import jp.synthtarou.midimixer.mx30controller.MX32MixerProcess;

public class MGSlider
extends JPanel
implements MXFocusAble,
MouseWheelListener {
    private static final MXDebugLines _debug = new MXDebugLines(MGSlider.class);
    MX32MixerProcess _process;
    int _row;
    int _column;
    ArrayList<MouseListener> backupedListener = new ArrayList();
    boolean _ignoreEvent = false;
    private JLabel jLabel1;
    private JLabel jLabelValue;
    private JSlider jSliderValue;

    public MGStatus getStatus() {
        if (this._process == null) {
            return null;
        }
        return this._process._data.getSliderStatus(this._row, this._column);
    }

    public void setStatus(MGStatus status) {
        this._process._data.setSliderStatus(this._row, this._column, status);
    }

    public MGSlider(MX32MixerProcess process, int row, int column) {
        this._row = row;
        this._column = column;
        this._process = process;
        this.initComponents();
        this.updateUI();
        new MXSliderUIForTablet(this.jSliderValue);
        this.addMouseWheelListener(this);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        MGStatus status = this.getStatus();
        if (status != null) {
            this.jSliderValue.setMinimum(status.getRangeMin());
            this.jSliderValue.setMaximum(status.getRangeMax());
            this.jSliderValue.setInverted(status.isUiValueInvert());
            this.jSliderValue.setPaintLabels(true);
            this.jSliderValue.setValue(status.getValue());
            this.jLabelValue.setText(String.valueOf(status.getValue()));
            status.fixRangedValue();
            if (status.getName() == null || status.getName().length() == 0) {
                MXMessage message = status.toMXMessage(new MXTraceNumber());
                if (message == null) {
                    this.jLabel1.setText("?");
                } else {
                    this.jLabel1.setText(message.toShortString());
                }
            } else {
                this.jLabel1.setText(status.getName());
            }
            this.focusStatusChanged(false);
        }
    }

    public void setValueChangeable(boolean usable) {
        if (!usable) {
            for (MouseListener l : this.jSliderValue.getMouseListeners()) {
                if (l instanceof MXFocusGroupElement.Listen) continue;
                this.backupedListener.add(l);
            }
            for (MouseListener l : this.backupedListener) {
                this.jSliderValue.removeMouseListener(l);
            }
        } else {
            for (MouseListener l : this.backupedListener) {
                this.jSliderValue.addMouseListener(l);
            }
            this.backupedListener.clear();
        }
    }

    private void initComponents() {
        this.jSliderValue = new JSlider();
        this.jLabel1 = new JLabel();
        this.jLabelValue = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jSliderValue.setOrientation(1);
        this.jSliderValue.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MGSlider.this.jSliderValueStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSliderValue, gridBagConstraints);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabelValue.setFont(new Font("Yu Gothic UI", 1, 12));
        this.jLabelValue.setForeground(MXUtil.mixedColor(Color.red, Color.yellow, 30));
        this.jLabelValue.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.jLabelValue, gridBagConstraints);
    }

    private void jSliderValueStateChanged(ChangeEvent evt) {
        int newValue = this.jSliderValue.getValue();
        if (this.getStatus().getValue() == newValue) {
            return;
        }
        this.jLabelValue.setText(String.valueOf(newValue));
        if (this._ignoreEvent) {
            return;
        }
        MXTraceNumber track = new MXTraceNumber();
        this._process.catchedValue(this.getStatus(), track, newValue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUIOnly(MXTraceNumber traceNumber, final int newValue) {
        if (this.jSliderValue.getValue() != newValue) {
            this.jLabelValue.setText(String.valueOf(newValue));
            this.getStatus().setValue(newValue);
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        2 var1_1 = this;
                        synchronized (var1_1) {
                            MGSlider.this._ignoreEvent = true;
                            MGSlider.this.jSliderValue.setValue(newValue);
                            MGSlider.this._ignoreEvent = false;
                        }
                    }
                });
            } else {
                MGSlider mGSlider = this;
                synchronized (mGSlider) {
                    this._ignoreEvent = true;
                    this.jSliderValue.setValue(newValue);
                    this._ignoreEvent = false;
                }
            }
        }
    }

    public JLabel labelFor(int num, int max) {
        Object name = "";
        if (max >= 256) {
            int msb = num / 128;
            int cut = msb * 128;
            int lsb = num - cut;
            name = MXUtil.toHexFF(msb) + ":" + MXUtil.toHexFF(lsb);
        } else {
            name = MXUtil.toHexFF(num);
        }
        JLabel label = new JLabel((String)name);
        return label;
    }

    @Override
    public void focusStatusChanged(boolean flag) {
        if (flag) {
            this._process._parent.showTextForFocus(2, this._process._port, this._row, this._column);
        }
    }

    @Override
    public void focusedMousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) || this._process._parent._editingControl) {
            this._process._parent.enterEditMode(false);
            this.focusStatusChanged(false);
            this.editContoller();
        }
    }

    @Override
    public void focusChangingValue() {
        this._process._parent.showTextForFocus(2, this._process._port, this._row, this._column);
    }

    public void increment(MXTraceNumber traceNumber) {
        MGStatus status = this.getStatus();
        int newValue = status.getValue() + 1;
        if (status.isUiValueInvert()) {
            newValue = status.getValue() - 1;
        }
        if (newValue > status.getRangeMax()) {
            newValue = status.getRangeMax();
        }
        if (newValue < status.getRangeMin()) {
            newValue = status.getRangeMin();
        }
        if (newValue != status.getValue()) {
            this._process.catchedValue(status, traceNumber, newValue, null);
        }
    }

    public void decriment(MXTraceNumber traceNumber) {
        MGStatus status = this.getStatus();
        int newValue = status.getValue() - 1;
        if (status.isUiValueInvert()) {
            newValue = status.getValue() + 1;
        }
        if (newValue > status.getRangeMax()) {
            newValue = status.getRangeMax();
        }
        if (newValue < status.getRangeMin()) {
            newValue = status.getRangeMin();
        }
        if (newValue != status.getValue()) {
            this._process.catchedValue(status, traceNumber, newValue, null);
        }
    }

    public void beHomePosition() {
        final MGStatus status = this.getStatus();
        final int current = status.getValue();
        final int value = status.getValueHome();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    for (int i = 0; i < 5; ++i) {
                        int x = current * (5 - i) + value * i;
                        Thread.sleep(70L);
                        status.setValue(x /= 5);
                        MGSlider.this.updateUIOnly(null, x);
                        if (x != value) continue;
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    status.setValue(value);
                    MGSlider.this.updateUIOnly(null, value);
                }
            }
        });
        t.start();
    }

    public void editContoller() {
        this._process._parent.enterEditMode(false);
        MGStatus status = (MGStatus)this.getStatus().clone();
        MGStatusConfig config = new MGStatusConfig(this._process, status);
        MXUtil.showAsDialog(this, config, "Enter Edit Slider {row:" + this._row + ", column:" + this._column + "}");
        if (config._okOption) {
            this.setStatus(config._status);
            this.jLabel1.setText(config._status.getName());
            this._process.notifyCacheBroken();
            this.updateUI();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int d = e.getUnitsToScroll();
        if (d > 0) {
            this.decriment(new MXTraceNumber());
        } else {
            this.increment(new MXTraceNumber());
        }
    }
}

