/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx12masterkeys;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.MXWrap;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.swing.SafeSpinnerNumberModel;
import jp.synthtarou.midimixer.mx12masterkeys.MX12Process;

public class MX12MasterPanelEditor
extends JPanel {
    MXWrapList<Integer> _portModel;
    MXWrapList<Integer> _channelModel;
    MXWrapList<MXReceiver> _receiverModel;
    MX12Process _process;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButtonReset;
    private JCheckBox jCheckBoxAdjustPort;
    private JCheckBox jCheckBoxInputPagePort;
    private JCheckBox jCheckBoxThisPagePort;
    private JComboBox<String> jComboBoxChannel;
    private JComboBox<String> jComboBoxPort;
    private JComboBox<String> jComboBoxReciever;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JSpinner jSpinnerMouseVelocity;

    public static JDialog showAsDialog(JFrame parent, MX12Process process, boolean modal) {
        MX12MasterPanelEditor editor = new MX12MasterPanelEditor(process);
        JDialog dialog = new JDialog((Frame)parent, modal);
        dialog.setTitle(editor.getTitle());
        dialog.setAlwaysOnTop(true);
        dialog.pack();
        dialog.setSize(550, 330);
        dialog.getContentPane().add(editor);
        MXUtil.centerWindow(dialog);
        dialog.setVisible(true);
        return dialog;
    }

    public static JDialog showAsDialog(JDialog parent, MX12Process process, boolean modal) {
        MX12MasterPanelEditor editor = new MX12MasterPanelEditor(process);
        JDialog dialog = new JDialog((Dialog)parent, modal);
        dialog.setTitle(editor.getTitle());
        dialog.setAlwaysOnTop(true);
        dialog.pack();
        dialog.setSize(550, 330);
        dialog.getContentPane().add(editor);
        MXUtil.centerWindow(dialog);
        dialog.setVisible(true);
        return dialog;
    }

    public MX12MasterPanelEditor(MX12Process process) {
        this.initComponents();
        this._process = process;
        this.jLabel6.setText("");
        this.showParameters();
    }

    public void showParameters() {
        this._receiverModel = MXMain.getMain().getReceiverList();
        this._receiverModel.writeComboBox(this.jComboBoxReciever, this._process.getNextReceiver());
        this._portModel = MXUtilMidi.createPortInput(false);
        this._portModel.writeComboBox(this.jComboBoxPort, this._process.getMousePort());
        this._channelModel = MXUtilMidi.createChannel(false);
        this._channelModel.writeComboBox(this.jComboBoxChannel, this._process.getMouseChannel());
        this.jSpinnerMouseVelocity.setModel(new SafeSpinnerNumberModel(this._process.getMouseVelocity(), 1, 127, 1));
        this.jCheckBoxAdjustPort.setSelected(this._process.isOverwriteInputChannel());
        this.jCheckBoxInputPagePort.setSelected(this._process.isAcceptInputPanelSignal());
        this.jCheckBoxThisPagePort.setSelected(this._process.isAcceptThisPageSignal());
    }

    public void catchParameters() {
        this._process.setNextReceiver((MXReceiver)((MXWrap)this._receiverModel.get((int)this.jComboBoxReciever.getSelectedIndex())).value);
        this._process.setMousePort((Integer)((MXWrap)this._portModel.get((int)this.jComboBoxPort.getSelectedIndex())).value);
        this._process.setMouseChannel((Integer)((MXWrap)this._channelModel.get((int)this.jComboBoxChannel.getSelectedIndex())).value);
        this._process.setMouseVelocity((Integer)this.jSpinnerMouseVelocity.getValue());
        this._process.setOverwriteInputChannel(this.jCheckBoxAdjustPort.isSelected());
        this._process.setAcceptInputPanelSignal(this.jCheckBoxInputPagePort.isSelected());
        this._process.setAcceptThisPageSignal(this.jCheckBoxThisPagePort.isSelected());
        this._process._view._piano.allNoteOff();
    }

    public String getTitle() {
        return "MIX Recipe";
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBoxReciever = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBoxPort = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jComboBoxChannel = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jSpinnerMouseVelocity = new JSpinner();
        this.jCheckBoxAdjustPort = new JCheckBox();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jCheckBoxInputPagePort = new JCheckBox();
        this.jCheckBoxThisPagePort = new JCheckBox();
        this.jButtonReset = new JButton();
        this.setBorder(BorderFactory.createTitledBorder("Master Key Controller"));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText("Receiver");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jComboBoxReciever.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX12MasterPanelEditor.this.jComboBoxRecieverActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add(this.jComboBoxReciever, gridBagConstraints);
        this.jLabel2.setText("Port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add(this.jComboBoxPort, gridBagConstraints);
        this.jLabel3.setText("Channel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add(this.jComboBoxChannel, gridBagConstraints);
        this.jLabel4.setText("Velocity(Mouse)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jSpinnerMouseVelocity, gridBagConstraints);
        this.jCheckBoxAdjustPort.setText("With Re-Adjust Ch/Port ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        this.add((Component)this.jCheckBoxAdjustPort, gridBagConstraints);
        this.jButton1.setText("OK");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX12MasterPanelEditor.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.add((Component)this.jButton1, gridBagConstraints);
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX12MasterPanelEditor.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.add((Component)this.jButton2, gridBagConstraints);
        this.jLabel6.setText("jLabel6");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setText("Process");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel7, gridBagConstraints);
        this.jCheckBoxInputPagePort.setText("Input Panel Page's Signal <- Top Left");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jCheckBoxInputPagePort, gridBagConstraints);
        this.jCheckBoxThisPagePort.setText("This Page's Signal");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jCheckBoxThisPagePort, gridBagConstraints);
        this.jButtonReset.setText("Reset");
        this.jButtonReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX12MasterPanelEditor.this.jButtonResetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.add((Component)this.jButtonReset, gridBagConstraints);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.catchParameters();
        MXUtil.closeOwnerWindow(this);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        MXUtil.closeOwnerWindow(this);
    }

    private void jButtonResetActionPerformed(ActionEvent evt) {
        this._receiverModel.writeComboBox(this.jComboBoxReciever, MXMain.getMain().getInputProcess());
        this._portModel.writeComboBox(this.jComboBoxPort, 0);
        this._channelModel.writeComboBox(this.jComboBoxChannel, 0);
        this.jCheckBoxAdjustPort.setSelected(false);
        this.jCheckBoxInputPagePort.setSelected(true);
        this.jCheckBoxThisPagePort.setSelected(true);
    }

    private void jComboBoxRecieverActionPerformed(ActionEvent evt) {
    }
}

