/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.smf;

import java.util.ArrayList;
import jp.synthtarou.midimixer.libs.midi.smf.SMFMessage;
import jp.synthtarou.midimixer.libs.midi.smf.SMFParser;

public final class SMFTempoTable {
    private static long DEFAULT_MPQ = 500000L;
    private int[] mpqStack;
    private long[] cumulativeTicks;
    private long[] cumulativeMicroseconds;
    int _fileResolution;

    public void setFileResolution(int reso) {
        this._fileResolution = reso;
    }

    public int getFileResolution() {
        return this._fileResolution;
    }

    public SMFTempoTable(SMFParser parser, int fileResolution) {
        int resolution = fileResolution;
        ArrayList<SMFMessage> list = parser.getMessageList().listAll();
        ArrayList<SMFMessage> tempoEvents = new ArrayList<SMFMessage>();
        for (SMFMessage message : list) {
            if (!message.isMetaMessage() || message.getDataType() != 81) continue;
            tempoEvents.add(message);
        }
        if (tempoEvents.isEmpty() || ((SMFMessage)tempoEvents.get(0)).getTick() != 0L) {
            byte b1 = (byte)(DEFAULT_MPQ >> 16);
            byte b2 = (byte)(DEFAULT_MPQ >> 8);
            byte b3 = (byte)DEFAULT_MPQ;
            SMFMessage mm = new SMFMessage(0L, 255, 81, new byte[]{b1, b2, b3});
            if (!tempoEvents.isEmpty()) {
                mm = new SMFMessage(0L, 255, 81, ((SMFMessage)tempoEvents.get(0)).getBinary());
            }
            tempoEvents.add(0, mm);
        }
        this.mpqStack = new int[tempoEvents.size()];
        this.cumulativeTicks = new long[tempoEvents.size()];
        this.cumulativeMicroseconds = new long[tempoEvents.size()];
        this.mpqStack[0] = ((SMFMessage)tempoEvents.get(0)).getMetaTempo();
        this.cumulativeMicroseconds[0] = 0L;
        this.cumulativeTicks[0] = 0L;
        int pos = 0;
        for (SMFMessage event : tempoEvents) {
            long tick;
            if (pos == 0) {
                ++pos;
                continue;
            }
            this.cumulativeTicks[pos] = tick = event.getTick();
            long deltaTick = tick - this.cumulativeTicks[pos - 1];
            this.mpqStack[pos] = event.getMetaTempo();
            long deltaMicroseconds = SMFTempoTable.TicksToMicroseconds(deltaTick, this.mpqStack[pos - 1], resolution);
            this.cumulativeMicroseconds[pos] = this.cumulativeMicroseconds[pos - 1] + deltaMicroseconds;
            ++pos;
        }
        this.setFileResolution(resolution);
    }

    public long MicrosecondsToTicks(long us) {
        int index = this.GetIndexFromMicroseconds(us);
        int mpq = this.mpqStack[index];
        long cumUs = this.cumulativeMicroseconds[index];
        long cumTicks = this.cumulativeTicks[index];
        long deltaUs = us - cumUs;
        long deltaTicks = SMFTempoTable.MicrosecondsToTicks(deltaUs, mpq, this._fileResolution);
        return cumTicks + deltaTicks;
    }

    public long TicksToMicroseconds(long tick) {
        int index = this.GetIndexFromTick(tick);
        int mpq = this.mpqStack[index];
        long cumUs = this.cumulativeMicroseconds[index];
        long cumTicks = this.cumulativeTicks[index];
        long deltaTick = tick - cumTicks;
        long deltaUs = SMFTempoTable.TicksToMicroseconds(deltaTick, mpq, this.getFileResolution());
        return cumUs + deltaUs;
    }

    private int GetIndexFromMicroseconds(long us) {
        int lo = -1;
        int hi = this.cumulativeMicroseconds.length;
        while (hi - lo > 1) {
            int m = hi - (hi - lo) / 2;
            if (this.cumulativeMicroseconds[m] <= us) {
                lo = m;
                continue;
            }
            hi = m;
        }
        return lo;
    }

    private int GetIndexFromTick(long tick) {
        int lo = -1;
        int hi = this.cumulativeTicks.length;
        while (hi - lo > 1) {
            int m = hi - (hi - lo) / 2;
            if (this.cumulativeTicks[m] <= tick) {
                lo = m;
                continue;
            }
            hi = m;
        }
        return lo;
    }

    private static long MicrosecondsToTicks(long us, long mpq, int resolution) {
        return us * (long)resolution / mpq;
    }

    private static long TicksToMicroseconds(long tick, long mqp, int resolution) {
        return tick * mqp / (long)resolution;
    }
}

