/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.smf;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.sound.midi.InvalidMidiDataException;
import jp.synthtarou.midimixer.libs.midi.smf.ByteReader;
import jp.synthtarou.midimixer.libs.midi.smf.ByteReaderChildren;
import jp.synthtarou.midimixer.libs.midi.smf.SMFFileInfo;
import jp.synthtarou.midimixer.libs.midi.smf.SMFMessage;
import jp.synthtarou.midimixer.libs.midi.smf.SMFMessageList;

public class SMFParser {
    File _file;
    SMFFileInfo _info;
    private static final int MThd_MAGIC = 1297377380;
    private SMFMessageList _messageList;
    private BufferedInputStream _stream;

    public SMFParser(File file) throws IOException {
        this._file = file;
        this.parseFile(file);
    }

    public SMFFileInfo getFileInfo() {
        return this._info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean parseFile(File file) throws IOException {
        this._info = new SMFFileInfo();
        try (FileInputStream stream = new FileInputStream(file);){
            SMFMessageList list;
            int tracks;
            int x4;
            int x3;
            int x2;
            int x1;
            int fileLength = -1;
            ByteReader reader = new ByteReader(stream);
            try {
                int maxReadLength = 16;
                int duration = -1;
                while (!(reader._eof || (x1 = reader.read8()) == 77 && (x2 = reader.read8()) == 84 && (x3 = reader.read8()) == 104 && (x4 = reader.read8()) == 100)) {
                }
                if (reader._eof) {
                    boolean bl = false;
                    return bl;
                }
                int bytesRemaining = reader.read32() - 6;
                int type = reader.read16();
                int numtracks = reader.read16();
                this._info.setResolution(reader.read16());
                if (this._info.getResolution() > 0) {
                    this._info.setSmpteFormat(-99999);
                } else {
                    int frameCode = (this._info.getResolution() >> 8) * -1;
                    this._info.setSmpteFormat(frameCode);
                    this._info.setResolution(this._info.getResolution() & 0xFF);
                }
                reader.skip(bytesRemaining);
                tracks = numtracks;
                if (type != 0 && type != 1) {
                    boolean bl = false;
                    return bl;
                }
                list = new SMFMessageList(this);
            }
            catch (InvalidMidiDataException midi) {
                boolean bl = false;
                return bl;
            }
            for (int tr = 0; tr < tracks; ++tr) {
                int trackLength = 0;
                while (!(reader._eof || (x1 = reader.read8()) == 77 && (x2 = reader.read8()) == 84 && (x3 = reader.read8()) == 114 && (x4 = reader.read8()) == 107)) {
                }
                if (reader._eof) break;
                trackLength = reader.read32();
                if (trackLength < 0) {
                    boolean bl = false;
                    return bl;
                }
                if (trackLength == 0) {
                    System.out.println("SMF parts length = 0");
                    continue;
                }
                try {
                    ByteReaderChildren child = new ByteReaderChildren(reader, trackLength);
                    long tick = 0L;
                    int status = 0;
                    boolean endOfTrackFound = false;
                    SMFMessage message = null;
                    int order = 0;
                    block24: while (!child._eof && !endOfTrackFound) {
                        int data1 = -1;
                        int data2 = 0;
                        long step = child.readVariable();
                        if (step != 0L) {
                            tick += step;
                            order = 0;
                        } else {
                            ++order;
                        }
                        int byteValue = child.read8();
                        if (byteValue >= 128) {
                            status = byteValue;
                        } else {
                            data1 = byteValue;
                        }
                        block8 : switch (status & 0xF0) {
                            case 128: 
                            case 144: 
                            case 160: 
                            case 176: 
                            case 224: {
                                if (data1 == -1) {
                                    data1 = child.read8();
                                }
                                data2 = child.read8();
                                message = new SMFMessage(tick, status, data1, data2);
                                message.setSeqTrack(tr);
                                message.setOrder(order);
                                break;
                            }
                            case 192: 
                            case 208: {
                                if (data1 == -1) {
                                    data1 = child.read8();
                                }
                                message = new SMFMessage(tick, status, data1, 0);
                                message.setSeqTrack(tr);
                                message.setOrder(order);
                                break;
                            }
                            case 240: {
                                switch (status) {
                                    case 240: 
                                    case 247: {
                                        int sysexLength = (int)child.readVariable();
                                        byte[] sysexData = new byte[sysexLength];
                                        child.readBuffer(sysexData, sysexLength);
                                        if (sysexLength == 0) continue block24;
                                        message = new SMFMessage(tick, status, status, sysexData);
                                        message.setSeqTrack(tr);
                                        message.setOrder(order);
                                        break block8;
                                    }
                                    case 255: {
                                        int metaType = child.read8();
                                        int metaLength = (int)child.readVariable();
                                        if (metaType < 0 || metaLength < 0) break block8;
                                        if (metaLength == 0) continue block24;
                                        byte[] metaData = new byte[metaLength];
                                        child.readBuffer(metaData, metaLength);
                                        message = new SMFMessage(tick, status, metaType, metaData);
                                        message.setSeqTrack(tr);
                                        message.setOrder(order);
                                        break block8;
                                    }
                                    default: {
                                        throw new InvalidMidiDataException("Invalid status byte: " + status);
                                    }
                                }
                            }
                            default: {
                                throw new InvalidMidiDataException("Invalid status byte: " + status);
                            }
                        }
                        if (message == null) continue;
                        list.add(message);
                    }
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    boolean bl = false;
                    ((InputStream)stream).close();
                    return bl;
                }
            }
            this._messageList = list;
            boolean bl = true;
            return bl;
        }
    }

    public SMFMessageList getMessageList() {
        return this._messageList;
    }

    public int getDefaultMPQ() {
        return 500000;
    }

    public String[] readMetaInfo() {
        ArrayList<String> ret = new ArrayList<String>();
        for (SMFMessage message : this._messageList._set) {
            if (message.getStatus() != 255) continue;
            int metaType = message.getData1();
            byte[] data = message.getBinary();
            String meta = "";
            try {
                meta = SMFMessage.dumpHexFF(data);
                meta = new String(data, "ISO-8859-1");
                meta = new String(data, "Shift_JIS");
            }
            catch (Exception exception) {
                // empty catch block
            }
            ret.add(meta);
        }
        String[] ar = new String[ret.size()];
        ret.toArray(ar);
        return ar;
    }
}

