/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.recorder;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Track;

public class SMFRecorderClassic {
    private static final SMFRecorderClassic _instance = new SMFRecorderClassic();
    Sequencer _sequencer = null;
    Sequence _sequence = null;
    Receiver _receiver = null;
    boolean _isrecording = false;
    private int _port = -1;

    public static SMFRecorderClassic getInstance() {
        return _instance;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int _port) {
        this._port = _port;
    }

    public boolean isRecording() {
        return this._isrecording;
    }

    public long tickLength() {
        if (this._sequence == null) {
            return 0L;
        }
        return this._sequence.getTickLength();
    }

    public boolean startRecording() {
        try {
            if (this._isrecording) {
                return true;
            }
            this._sequencer = MidiSystem.getSequencer();
            this._sequence = new Sequence(0.0f, 24);
            Track currentTrack = this._sequence.createTrack();
            this._sequencer.setSequence(this._sequence);
            this._sequencer.setTickPosition(0L);
            this._sequencer.recordEnable(currentTrack, -1);
            this._sequencer.open();
            this._sequencer.startRecording();
            this._receiver = this._sequencer.getReceiver();
            this._isrecording = true;
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
            this._sequence = null;
            this._sequencer = null;
            return false;
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
            this._sequence = null;
            this._sequencer = null;
            return false;
        }
        return true;
    }

    public void stopRecording() {
        if (this._isrecording) {
            this._sequencer.stopRecording();
            this._isrecording = false;
        }
    }

    public void saveRecording(File file) {
        if (this._sequence != null && !this._isrecording) {
            try {
                FileOutputStream fout = new FileOutputStream(file);
                BufferedOutputStream bout = new BufferedOutputStream(fout);
                MidiSystem.write(this._sequence, 0, bout);
                bout.flush();
                fout.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Receiver getReceiver() {
        return this._receiver;
    }
}

