/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.programlist.database;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.MXTimer;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.MXWrap;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import jp.synthtarou.midimixer.libs.midi.MXTraceNumber;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.midi.port.FinalMIDIOut;
import jp.synthtarou.midimixer.libs.midi.programlist.database.DoubleIndex;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDBank;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDFile;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDFileManager;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDMap;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDProgram;
import jp.synthtarou.midimixer.libs.swing.MXPianoComponent;

public class ProgramPicker
extends JPanel {
    ArrayList<PDFile> _listRoot = new ArrayList();
    String _searchText;
    int _testPort;
    int _testChannel;
    MXWrapList<PDMap> _modelMapList;
    PDMap _selectedMap;
    MXWrapList<PDProgram> _modelProgramList;
    PDProgram _selectedProgram;
    MXWrapList<PDBank> _modelBankList;
    PDBank _lastChoice;
    PDBank _programChanged;
    MXPianoComponent _piano;
    MXReceiver _receiver;
    MXWrapList<MXReceiver> _listReceiver;
    public int _returnProgram = -1;
    public int _returnBankMSB = -1;
    public int _returnBankLSB = -1;
    MXWrapList<PDFile> _xmlList;
    long reserveSearch = 0L;
    private JButton jButtonCancel;
    private JButton jButtonSelect;
    private JComboBox<String> jComboBoxCategory;
    private JComboBox<String> jComboBoxMap;
    private JComboBox<String> jComboBoxTestChannel;
    private JComboBox<String> jComboBoxTestPort;
    private JComboBox<String> jComboBoxTestReceiver;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabelBankProgram;
    private JList<String> jListBank;
    private JList<String> jListProgram;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelPiano;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTextField jTextFieldSearch;

    public void add(PDFile root) {
        this._listRoot.add(root);
        this._xmlList = new MXWrapList();
        for (PDFile xml : this._listRoot) {
            this._xmlList.addNameAndValue(xml.getName(), xml);
        }
        this.jComboBoxMap.setModel(this._xmlList);
    }

    public static void main(String[] args) {
        MXDebugLines.globalSwitchOn();
        ProgramPicker picker = new ProgramPicker();
        MXUtil.showAsDialog(null, picker, "Test");
        System.exit(0);
    }

    public ProgramPicker() {
        this.initComponents();
        PDFileManager manager = PDFileManager.getManager();
        this._listRoot.addAll(manager._listXML);
        this.jComboBoxTestPort.setModel(MXUtilMidi.createPortOutput());
        this.jComboBoxTestChannel.setModel(MXUtilMidi.createChannel(false));
        this._xmlList = new MXWrapList();
        for (PDFile xml : this._listRoot) {
            this._xmlList.addNameAndValue(xml.getName(), xml);
        }
        this.jComboBoxMap.setModel(this._xmlList);
        if (this._xmlList.size() > 0) {
            this.jComboBoxMap.setSelectedIndex(0);
            this.xmlSelected(this._xmlList.readCombobox(this.jComboBoxMap));
        }
        this.setPreferredSize(new Dimension(600, 600));
        this._piano = new MXPianoComponent();
        this.jPanelPiano.add(this._piano);
        this._piano.setHandler(new MyHandler());
        this.jTextFieldSearch.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProgramPicker.this.textChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProgramPicker.this.textChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProgramPicker.this.textChanged();
            }
        });
        this._receiver = FinalMIDIOut.getInstance();
        this._listReceiver = MXMain.getMain().getReceiverList();
        this._listReceiver.writeComboBox(this.jComboBoxTestReceiver, this._receiver);
    }

    public void setDefault(int prog, int msb, int lsb) {
        int i;
        this.jComboBoxCategory.setSelectedIndex(0);
        this.fillProgramList();
        int hit = -1;
        for (i = 0; i < this._modelProgramList.size(); ++i) {
            PDProgram dbProg = (PDProgram)((MXWrap)this._modelProgramList.get((int)i)).value;
            if (dbProg._programNumber != prog) continue;
            hit = i;
            break;
        }
        if (hit >= 0) {
            this.jListProgram.setSelectedIndex(hit);
            this.fillBankList();
            hit = -1;
            for (i = 0; i < this._modelBankList.size(); ++i) {
                PDBank dbBank = (PDBank)((MXWrap)this._modelBankList.get((int)i)).value;
                if (dbBank.getBankMSB() != msb || dbBank.getBankLSB() != lsb) continue;
                hit = i;
                break;
            }
            if (hit >= 0) {
                this.jListBank.setSelectedIndex(hit);
            }
        }
    }

    public void xmlSelected(PDFile root) {
        this._modelMapList = new MXWrapList();
        this._modelProgramList = new MXWrapList();
        this._modelBankList = new MXWrapList();
        if (root == null) {
            this.jComboBoxCategory.setModel(this._modelMapList);
            this.fillProgramList();
            this.updateUISelection(true);
            return;
        }
        PDMap allMap = new PDMap("All");
        this._modelMapList.addNameAndValue(allMap.getName(), allMap);
        for (PDMap map : root.getModule().listMap()) {
            for (PDProgram prog : map.listPrograms()) {
                allMap._programSet.put(prog);
            }
            if (map.isEmpty()) continue;
            this._modelMapList.addNameAndValue(map.getName(), map);
            if (this._selectedMap != null) continue;
            this._selectedMap = map;
        }
        this.jComboBoxCategory.setModel(this._modelMapList);
        this.fillProgramList();
        this.updateUISelection(true);
    }

    public void textChanged() {
        if (this.jComboBoxCategory.getSelectedIndex() != 0) {
            this.jComboBoxCategory.setSelectedIndex(0);
        }
        this.reserveSearch = System.currentTimeMillis() + 500L;
        MXTimer.letsCountdown(500L, new Runnable(){

            @Override
            public void run() {
                if (System.currentTimeMillis() >= ProgramPicker.this.reserveSearch) {
                    ProgramPicker.this.invokeSearch();
                }
            }
        });
    }

    public void invokeSearch() {
        this._searchText = this.jTextFieldSearch.getText();
        this.fillProgramList();
        this.fillBankList();
    }

    public void updateUISelection(boolean defaultSelection) {
        int progSel = this._modelProgramList.indexOfValue(this._selectedProgram);
        int bankSel = this._modelBankList.indexOfValue(this._lastChoice);
        if (defaultSelection) {
            if (progSel < 0) {
                progSel = 0;
            }
            if (bankSel < 0) {
                bankSel = 0;
            }
        }
        this.jListProgram.setSelectedIndex(progSel);
        this.jListBank.setSelectedIndex(bankSel);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jPanelPiano = new JPanel();
        this.jComboBoxTestChannel = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jComboBoxTestPort = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jLabelBankProgram = new JLabel();
        this.jLabel7 = new JLabel();
        this.jComboBoxTestReceiver = new JComboBox();
        this.jButtonSelect = new JButton();
        this.jButtonCancel = new JButton();
        this.jPanel1 = new JPanel();
        this.jTextFieldSearch = new JTextField();
        this.jLabel1 = new JLabel();
        this.jComboBoxCategory = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListProgram = new JList();
        this.jLabel3 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jListBank = new JList();
        this.jLabel4 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jComboBoxMap = new JComboBox();
        this.setBorder(BorderFactory.createTitledBorder("Sound Tests"));
        this.setLayout(new GridBagLayout());
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setOrientation(0);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Test Output"));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanelPiano.setBorder(new SoftBevelBorder(0));
        this.jPanelPiano.setLayout(new BoxLayout(this.jPanelPiano, 2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jPanelPiano, gridBagConstraints);
        this.jComboBoxTestChannel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramPicker.this.jComboBoxTestChannelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.jPanel2.add(this.jComboBoxTestChannel, gridBagConstraints);
        this.jLabel5.setText("Port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.jComboBoxTestPort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramPicker.this.jComboBoxTestPortActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.jPanel2.add(this.jComboBoxTestPort, gridBagConstraints);
        this.jLabel6.setText("Channel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabelBankProgram.setText("Piano -");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jLabelBankProgram, gridBagConstraints);
        this.jLabel7.setText("Test ON");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.jLabel7, gridBagConstraints);
        this.jComboBoxTestReceiver.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ProgramPicker.this.jComboBoxTestReceiverItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.jPanel2.add(this.jComboBoxTestReceiver, gridBagConstraints);
        this.jButtonSelect.setText("OK");
        this.jButtonSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramPicker.this.jButtonSelectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        this.jPanel2.add((Component)this.jButtonSelect, gridBagConstraints);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramPicker.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.jPanel2.add((Component)this.jButtonCancel, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.jPanel2);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Tone"));
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.jTextFieldSearch, gridBagConstraints);
        this.jLabel1.setText("Map");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jComboBoxCategory.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ProgramPicker.this.jComboBoxCategoryItemStateChanged(evt);
            }
        });
        this.jComboBoxCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramPicker.this.jComboBoxCategoryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        this.jPanel1.add(this.jComboBoxCategory, gridBagConstraints);
        this.jLabel2.setText("Program");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jListProgram.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ProgramPicker.this.jListProgramValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListProgram);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel3.setText("Bank");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.jListBank.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ProgramPicker.this.jListBankValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jListBank);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jLabel4.setText("Search");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel8.setText("XML");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.jLabel8, gridBagConstraints);
        this.jComboBoxMap.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ProgramPicker.this.jComboBoxMapItemStateChanged(evt);
            }
        });
        this.jComboBoxMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramPicker.this.jComboBoxMapActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.jPanel1.add(this.jComboBoxMap, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.jPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSplitPane1, gridBagConstraints);
    }

    private void jComboBoxTestChannelActionPerformed(ActionEvent evt) {
        this._programChanged = this._lastChoice;
    }

    private void jComboBoxCategoryActionPerformed(ActionEvent evt) {
        this._selectedMap = this._modelMapList.readCombobox(this.jComboBoxCategory);
        this.fillProgramList();
        this.updateUISelection(true);
    }

    public void fillProgramList() {
        this._modelProgramList = new MXWrapList();
        if (this._searchText != null && !this._searchText.isBlank()) {
            DoubleIndex<PDProgram> searchTemp = new DoubleIndex<PDProgram>();
            for (PDMap folder : this._modelMapList.valueList()) {
                for (PDProgram prog : folder.listPrograms()) {
                    boolean hit = false;
                    if (MXUtil.searchTextIgnoreCase(prog.getName(), this._searchText)) {
                        hit = true;
                    } else {
                        for (PDBank bank : prog.listBanks()) {
                            if (!MXUtil.searchTextIgnoreCase(bank.getName(), this._searchText)) continue;
                            hit = true;
                            break;
                        }
                    }
                    if (!hit) continue;
                    searchTemp.put(prog);
                }
            }
            for (PDProgram prog : searchTemp.values()) {
                this._modelProgramList.addNameAndValue(prog.getProgramNumber() + "." + prog.getName(), prog);
            }
        } else {
            this._selectedMap = this._modelMapList.readCombobox(this.jComboBoxCategory);
            if (this._selectedMap != null) {
                for (PDProgram prog : this._selectedMap.listPrograms()) {
                    this._modelProgramList.addNameAndValue(prog.getProgramNumber() + "." + prog.getName(), prog);
                }
            }
        }
        this.jListProgram.setModel(this._modelProgramList);
    }

    private void jListProgramValueChanged(ListSelectionEvent evt) {
        int index = this.jListProgram.getSelectedIndex();
        this._selectedProgram = index < 0 ? null : (PDProgram)((MXWrap)this._modelProgramList.get((int)index)).value;
        this.fillBankList();
        this.updateUISelection(true);
    }

    private void jListBankValueChanged(ListSelectionEvent evt) {
        int index = this.jListBank.getSelectedIndex();
        if (index < 0) {
            if (this._modelBankList.size() > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProgramPicker.this.jListBank.setSelectedIndex(0);
                    }
                });
            }
            return;
        }
        this._programChanged = this._lastChoice = (PDBank)((MXWrap)this._modelBankList.get((int)index)).value;
        if (this._lastChoice != null) {
            StringBuffer text = new StringBuffer();
            int msb = this._lastChoice.getBankMSB();
            int lsb = this._lastChoice.getBankLSB();
            text.append(this._lastChoice.getId());
            if (msb >= 0 && lsb >= 0) {
                text.append("(BANK:" + MXUtil.toHexFF(msb) + ":" + MXUtil.toHexFF(lsb) + ")");
            }
            text.append(this._lastChoice.getName());
            this.jLabelBankProgram.setText(text.toString());
            MXWrap portObj = (MXWrap)this.jComboBoxTestPort.getSelectedItem();
            MXWrap channelObj = (MXWrap)this.jComboBoxTestChannel.getSelectedItem();
            int port = (Integer)portObj.value;
            int channel = (Integer)channelObj.value;
            if (this._programChanged.getBankMSB() >= 0 && this._programChanged.getBankLSB() >= 0) {
                MXMessage bank1 = MXMessageFactory.fromShortMessage(port, new MXTraceNumber(), 176 + channel, 0, this._programChanged.getBankMSB());
                FinalMIDIOut.getInstance().processMXMessage(bank1);
                MXMessage bank2 = MXMessageFactory.fromShortMessage(port, new MXTraceNumber(), 176 + channel, 32, this._programChanged.getBankLSB());
                FinalMIDIOut.getInstance().processMXMessage(bank2);
                try {
                    Thread.sleep(500L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            MXMessage prog = MXMessageFactory.fromShortMessage(port, new MXTraceNumber(), 192 + channel, 0, 0);
            prog.setGate(this._programChanged._parent._programNumber);
            FinalMIDIOut.getInstance().processMXMessage(prog);
        }
    }

    private void jComboBoxTestPortActionPerformed(ActionEvent evt) {
        this._programChanged = this._lastChoice;
    }

    private void jButtonSelectActionPerformed(ActionEvent evt) {
        this._returnProgram = this._selectedProgram.getId();
        this._returnBankMSB = this._lastChoice.getBankMSB();
        this._returnBankLSB = this._lastChoice.getBankLSB();
        MXUtil.closeOwnerWindow(this);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this._returnProgram = -1;
        this._returnBankMSB = -1;
        this._returnBankLSB = -1;
        MXUtil.closeOwnerWindow(this);
    }

    private void jComboBoxMapItemStateChanged(ItemEvent evt) {
        this.xmlSelected(this._xmlList.readCombobox(this.jComboBoxMap));
    }

    private void jComboBoxMapActionPerformed(ActionEvent evt) {
    }

    private void jComboBoxCategoryItemStateChanged(ItemEvent evt) {
    }

    private void jComboBoxTestReceiverItemStateChanged(ItemEvent evt) {
        this._receiver = this._listReceiver.readCombobox(this.jComboBoxTestReceiver);
    }

    public void fillBankList() {
        int sel = this.jListProgram.getSelectedIndex();
        this._selectedProgram = sel >= 0 ? (PDProgram)((MXWrap)this._modelProgramList.get((int)sel)).value : null;
        this._modelBankList = new MXWrapList();
        if (this._selectedProgram != null) {
            for (PDBank bank : this._selectedProgram.listBanks()) {
                Object bankCode = MXUtil.toHexFF(bank.getBankMSB()) + ":" + MXUtil.toHexFF(bank.getBankLSB());
                if (((String)bankCode).equals("ff:ff")) {
                    bankCode = "-";
                }
                this._modelBankList.addNameAndValue((String)bankCode + "." + bank.getName(), bank);
            }
        }
        this.jListBank.setModel(this._modelBankList);
    }

    class MyHandler
    implements MXPianoComponent.Handler {
        MyHandler() {
        }

        @Override
        public void noteOn(int note) {
            MXWrap portObj = (MXWrap)ProgramPicker.this.jComboBoxTestPort.getSelectedItem();
            MXWrap channelObj = (MXWrap)ProgramPicker.this.jComboBoxTestChannel.getSelectedItem();
            int port = (Integer)portObj.value;
            int channel = (Integer)channelObj.value;
            MXMessage message = MXMessageFactory.fromShortMessage(port, new MXTraceNumber(), 144 + channel, note, 100);
            FinalMIDIOut.getInstance().processMXMessage(message);
        }

        @Override
        public void noteOff(int note) {
            MXWrap portObj = (MXWrap)ProgramPicker.this.jComboBoxTestPort.getSelectedItem();
            MXWrap channelObj = (MXWrap)ProgramPicker.this.jComboBoxTestChannel.getSelectedItem();
            int port = (Integer)portObj.value;
            int channel = (Integer)channelObj.value;
            MXMessage message = MXMessageFactory.fromShortMessage(port, new MXTraceNumber(), 128 + channel, note, 0);
            FinalMIDIOut.getInstance().processMXMessage(message);
        }

        @Override
        public void selectionChanged() {
        }
    }
}

