/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.port;

import java.io.File;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.MultiThreadQueue;
import jp.synthtarou.midimixer.libs.domino.DTextXML;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXTraceNumber;
import jp.synthtarou.midimixer.libs.midi.driver.MXMIDIDevice;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIOutManager;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant16;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDFileManager;
import jp.synthtarou.midimixer.mx70console.ConsoleElement;
import org.xml.sax.SAXException;

public class MXMIDIOut {
    private static final MXDebugLines _debug = new MXDebugLines(MXMIDIOut.class);
    public static final MXMIDIOut OUTPUT_NONE = new MXMIDIOut("none", null);
    private MXMIDIDevice _device;
    private String _name;
    private boolean _isopen = false;
    int _assigned = -1;
    private File _DXMLFile;
    private MXVisitant16 _visitant16 = new MXVisitant16();
    boolean _useThread = false;
    MultiThreadQueue<MXMessage> _queue;
    Thread _thread;
    long startTime = System.currentTimeMillis();

    public int assignedPort() {
        return this._assigned;
    }

    public boolean isOpen() {
        return this._isopen;
    }

    protected MXMIDIOut(String name, MXMIDIDevice device) {
        this._device = device;
        this._name = name;
        if (this._useThread) {
            this._thread = new Thread(){

                @Override
                public void run() {
                    MXMessage message;
                    System.out.println("Thread Launcher");
                    while ((message = MXMIDIOut.this._queue.pop()) != null) {
                        try {
                            MXMIDIOut.this.processMidiOutInternal(message);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            this._queue = new MultiThreadQueue();
            this._thread.start();
        }
    }

    public String getName() {
        return this._name;
    }

    public File getDXMLFile() {
        return this._DXMLFile;
    }

    public void setDXMLFile(File file) throws SAXException {
        try {
            PDFileManager manager = PDFileManager.getManager();
            if (this._DXMLFile != null) {
                manager.unregist(this._DXMLFile.getName());
            }
            DTextXML parser = DTextXML.fromFile(file);
            this._DXMLFile = file;
            manager.register(parser);
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        MXMIDIOut out = (MXMIDIOut)o;
        return out._name == this._name;
    }

    public String toString() {
        return this._name;
    }

    public long getTimestamp() {
        try {
            return System.currentTimeMillis() - this.startTime;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public void processMidiOut(MXMessage message) {
        try {
            if (this._useThread) {
                this._queue.push(message);
            } else {
                this.processMidiOutInternal(message);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void processMidiOutInternal(MXMessage message) {
        block23: {
            if (!this._isopen || this._assigned < 0) {
                return;
            }
            if (!this._device.isOpen()) {
                this._isopen = false;
                return;
            }
            MXMain.addInsideOutput(message);
            try {
                int col;
                if (MXVisitant.isMesssageHaveVisitant(message)) {
                    this._visitant16.get(message.getChannel()).updatevisitantChannel(message);
                }
                long timeStamp = this.getTimestamp();
                long recTime = 0L;
                if (message.isMessageTypeChannel()) {
                    MXMessage newMessage;
                    MXVisitant msgVisitant = message.getVisitant();
                    MXVisitant visitant = this._visitant16.get(message.getChannel());
                    int command = message.getCommand();
                    int channel = message.getChannel();
                    int gate = message.getGate();
                    if (command != 192 && msgVisitant != null && msgVisitant.isHavingProgram() && (!visitant.isHavingProgram() || visitant.getProgram() != message.getVisitant().getProgram())) {
                        visitant.mergeNew(message.getVisitant());
                        newMessage = MXMessageFactory.fromShortMessage(this._assigned, message._traceNumber, 192 + channel, visitant.getProgram(), 0);
                        newMessage.setVisitant(visitant.getSnapShot());
                        this.processMidiOutInternal(newMessage);
                    }
                    if ((command != 176 || gate != 0 && gate != 32) && msgVisitant != null && msgVisitant.isHavingBank() && (!visitant.isHavingBank() || visitant.getBankMSB() != msgVisitant.getBankMSB() || visitant.getBankLSB() != msgVisitant.getBankLSB())) {
                        visitant.mergeNew(message.getVisitant());
                        MXMessage newMessage1 = MXMessageFactory.fromShortMessage(this._assigned, message._traceNumber, 176 + channel, 0, visitant._bankMSB);
                        MXMessage newMessage2 = MXMessageFactory.fromShortMessage(this._assigned, message._traceNumber, 176 + channel, 32, visitant._bankLSB);
                        this.processMidiOutInternal(newMessage1);
                        this.processMidiOutInternal(newMessage2);
                    }
                    if (!(command == 176 && gate == 7 || msgVisitant == null || !msgVisitant.isHavingVolume() || visitant.isHavingVolume() && visitant.getInfoVolume() == msgVisitant.getInfoVolume())) {
                        visitant.mergeNew(message.getVisitant());
                        newMessage = MXMessageFactory.fromShortMessage(this._assigned, message._traceNumber, 176 + channel, 7, visitant.getInfoVolume());
                        this.processMidiOutInternal(newMessage);
                    }
                    if (!(command == 176 && gate == 11 || msgVisitant == null || !msgVisitant.isHavingExpression() || visitant.isHavingExpression() && visitant.getInfoExpression() == msgVisitant.getInfoExpression())) {
                        visitant.mergeNew(message.getVisitant());
                        newMessage = MXMessageFactory.fromShortMessage(this._assigned, message._traceNumber, 176 + channel, 11, visitant.getInfoExpression());
                        this.processMidiOutInternal(newMessage);
                    }
                    if (!(command == 176 && gate == 10 || msgVisitant == null || !msgVisitant.isHavingExpression() || visitant.isHavingPan() && visitant.getInfoPan() == msgVisitant.getInfoPan())) {
                        visitant.mergeNew(message.getVisitant());
                        newMessage = MXMessageFactory.fromShortMessage(this._assigned, message._traceNumber, 176 + channel, 10, visitant.getInfoPan());
                        this.processMidiOutInternal(newMessage);
                    }
                }
                if ((col = message.getDwordCount()) == 0) {
                    byte[] data = message.getDataBytes();
                    try {
                        this._device.OutputLongMessage(data);
                        MXMain.addOutsideOutput(new ConsoleElement(message._traceNumber, message.getPort(), data));
                    }
                    catch (NullPointerException command) {
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    break block23;
                }
                if (col > 0) {
                    for (int i = 0; i < col; ++i) {
                        int dword = message.getAsDword(i);
                        try {
                            if (dword != 0) {
                                this._device.OutputShortMessage(dword);
                                MXMain.addOutsideOutput(new ConsoleElement(message._traceNumber, message.getPort(), dword));
                                continue;
                            }
                            break block23;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    break block23;
                }
                if (message.isDataentry()) {
                    if (message.getVisitant() == null) {
                        System.out.println("DATAENTRY no set VISITANT");
                        return;
                    }
                    if (!message.getVisitant().isHaveDataentryRPN() && !message.getVisitant().isHaveDataentryNRPN()) {
                        System.out.println("DATAENTRY no set RPN / NRPN");
                        return;
                    }
                }
                System.out.println("nothing to send : " + message);
            }
            catch (Throwable e) {
                _debug.printStackTrace(e);
            }
        }
    }

    public void allNoteOff(MXTraceNumber traceNumber) {
        for (int ch = 0; ch < 16; ++ch) {
            try {
                MXMessage msg = MXMessageFactory.fromShortMessage(this._assigned, traceNumber, 176 + ch, 123, 127);
                this.processMidiOutInternal(msg);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() {
        MXMIDIOutManager manager;
        MXMIDIOutManager mXMIDIOutManager = manager = MXMIDIOutManager.getManager();
        synchronized (mXMIDIOutManager) {
            manager.clearMIDIOutCache();
            if (this._assigned < 0) {
                return false;
            }
            if (this._isopen) {
                return true;
            }
            this._visitant16 = new MXVisitant16();
            if (this._device != null) {
                if (!this._device.isOpen()) {
                    this._device.open();
                }
                this._isopen = true;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        MXMIDIOutManager manager;
        MXMIDIOutManager mXMIDIOutManager = manager = MXMIDIOutManager.getManager();
        synchronized (mXMIDIOutManager) {
            if (this._isopen) {
                this.allNoteOff(new MXTraceNumber());
                manager.onClose(this);
                this._isopen = false;
                if (!this._name.equals("Gervill") && this._device != null) {
                    this._device.close();
                }
            }
        }
    }
}

