/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.port;

import java.util.ArrayList;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXMessageTemplate;
import jp.synthtarou.midimixer.libs.midi.MXNoteOffWatcher;
import jp.synthtarou.midimixer.libs.midi.MXTraceNumber;
import jp.synthtarou.midimixer.libs.midi.driver.MXMIDIDevice;
import jp.synthtarou.midimixer.libs.midi.driver.MXMIDIDriverReceiver;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIInForPlayer;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIInManager;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant16;
import jp.synthtarou.midimixer.mx70console.ConsoleElement;

public class MXMIDIIn {
    private static final MXDebugLines _debug = new MXDebugLines(MXMIDIIn.class);
    public static final MXMIDIInForPlayer INTERNAL_PLAYER = new MXMIDIInForPlayer();
    private boolean _isopen = false;
    private String _name;
    private MXMIDIDevice _device;
    public final MXNoteOffWatcher _noteOff = new MXNoteOffWatcher();
    protected int _assigned;
    private boolean[] _isToMaster = new boolean[16];
    private MXVisitant16 _visitant16 = new MXVisitant16();
    Thread lastSent = null;

    public boolean isOpen() {
        return this._isopen;
    }

    public MXMIDIIn(String name, MXMIDIDevice device) {
        this._name = name;
        this._assigned = -1;
        this._device = device;
    }

    public int assigned() {
        return this._assigned;
    }

    public boolean isToMaster(int channel) {
        return this._isToMaster[channel];
    }

    public void setToMaster(int channel, boolean toMaster) {
        this._isToMaster[channel] = toMaster;
    }

    public String getMasterList() {
        StringBuffer str = new StringBuffer();
        for (int ch = 0; ch < 16; ++ch) {
            if (!this.isToMaster(ch)) continue;
            if (str.length() == 0) {
                str.append(Integer.toString(ch));
                continue;
            }
            str.append(",");
            str.append(Integer.toString(ch));
        }
        return str.toString();
    }

    public void setMasterList(String text) {
        if (text == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        MXUtil.split(text, list, ',');
        this._isToMaster = new boolean[16];
        for (String x : list) {
            int ch = MXUtil.parseTextForNumber(x);
            if (ch < 0) continue;
            this._isToMaster[ch] = true;
        }
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return this._name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        MXMIDIInManager manager;
        MXMIDIInManager mXMIDIInManager = manager = MXMIDIInManager.getManager();
        synchronized (mXMIDIInManager) {
            this.allNoteOff(new MXTraceNumber());
            if (this instanceof MXMIDIInForPlayer) {
                this._isopen = false;
                return;
            }
            if (this._isopen) {
                MXMIDIInManager.getManager().onClose(this);
                if (this._device != null) {
                    this._device.close();
                }
                this._isopen = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() {
        MXMIDIInManager manager;
        if (this._assigned < 0) {
            return false;
        }
        MXMIDIInManager mXMIDIInManager = manager = MXMIDIInManager.getManager();
        synchronized (mXMIDIInManager) {
            if (this._isopen) {
                return true;
            }
            if (this instanceof MXMIDIInForPlayer) {
                this._isopen = true;
                return true;
            }
            this._device.open();
            this._isopen = true;
            this._device.setInputReceiver(new MXMIDIDriverReceiver(){

                @Override
                public boolean DoShortMessage(int port, MXTraceNumber traceNumber, int dword) {
                    int code = dword >> 16 & 0xFF;
                    if (code == 248 || code == 254) {
                        return false;
                    }
                    MXMIDIIn.this.startMainPath(dword, null);
                    return true;
                }

                @Override
                public boolean DoLongMessage(int port, MXTraceNumber traceNumber, byte[] data) {
                    MXMIDIIn.this.startMainPath(0, data);
                    return true;
                }
            });
            return true;
        }
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        MXMIDIIn in = (MXMIDIIn)o;
        return in._name == this._name;
    }

    public void allNoteOff(MXTraceNumber trace) {
        this._noteOff.allNoteOff(trace);
    }

    public String textForMasterChannel() {
        StringBuffer masterMark = new StringBuffer();
        for (int ch = 0; ch < 16; ++ch) {
            if (!this.isToMaster(ch)) continue;
            if (masterMark.length() != 0) {
                masterMark.append(", ");
            }
            masterMark.append((Object)(ch + 1));
        }
        return masterMark.toString();
    }

    public int parseMasteredText(String text) {
        if (text == null) {
            return 0;
        }
        String[] array = text.split("[ ,]+");
        int hit = 0;
        for (int i = 0; i < array.length; ++i) {
            int ch1;
            String parts = array[i];
            if (parts.length() < 1 || (ch1 = parts.charAt(0) - 48) < 0 || ch1 > 9) continue;
            if (parts.length() >= 2) {
                int ch2 = parts.charAt(2) - 48;
                if (ch2 < 0 || ch2 > 9) continue;
                ch1 = ch1 * 10 + ch2;
            }
            if (ch1 >= 1 && ch1 <= 16) {
                this.setToMaster(ch1 - 1, true);
            }
            ++hit;
        }
        return hit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMainPath(int dword, byte[] data) {
        int port = this.assigned();
        int status = dword >> 16 & 0xFF;
        int data1 = dword >> 8 & 0xFF;
        int data2 = dword & 0xFF;
        if (data == null && (status == 248 || status == 254)) {
            return;
        }
        MXMain mXMain = MXMain.getMain();
        synchronized (mXMain) {
            MXMessage message;
            if (data == null) {
                message = MXMessageFactory.fromShortMessage(port, new MXTraceNumber(), status, data1, data2);
                MXMain.addOutsideInput(new ConsoleElement(message._traceNumber, this._assigned, dword));
            } else {
                message = MXMessageFactory.fromBinary(port, new MXTraceNumber(), data);
                if (message == null) {
                    return;
                }
                MXMain.addOutsideInput(new ConsoleElement(message._traceNumber, this._assigned, data));
            }
            if (status >= 128 && status <= 239) {
                boolean worked = false;
                int ch = message.getChannel();
                int command = message.getCommand();
                int gate = message.getGate();
                MXVisitant visit = this._visitant16.get(ch);
                visit.updatevisitantChannel(message);
                message.setVisitant(visit.getSnapShot());
                if (command == 176) {
                    if (gate == 0 || gate == 32) {
                        if (visit.isHavingBank()) {
                            message = MXMessageFactory.fromShortMessage(port, message._traceNumber, command + ch, 0, 0);
                            message.setVisitant(visit.getSnapShot());
                            this.dispatchMainPath(message);
                        }
                        return;
                    }
                    if (gate == 6 || gate == 38) {
                        if (visit.isHaveDataentryRPN()) {
                            int[] temp0 = new int[]{16384, 0, 0, 0};
                            MXMessageTemplate template = new MXMessageTemplate(temp0);
                            message = template.bind(message._traceNumber, port, 0, 0);
                            message.setVisitant(visit.getSnapShot());
                            this.dispatchMainPath(message);
                            return;
                        }
                        if (visit.isHaveDataentryNRPN()) {
                            int[] temp0 = new int[]{16640, 0, 0, 0};
                            MXMessageTemplate template = new MXMessageTemplate(temp0);
                            message = template.bind(message._traceNumber, port, 0, 0);
                            message.setVisitant(visit.getSnapShot());
                            this.dispatchMainPath(message);
                            return;
                        }
                        return;
                    }
                    if (gate == 100 || gate == 101 || gate == 98 || gate == 99) {
                        return;
                    }
                }
                if (visit.isIncompleteBankInfo() && (command != 176 || gate != 0 && gate != 32)) {
                    visit.forceCompleteBankInfo();
                }
                if (visit.isIncomplemteDataentry() && (command != 176 || gate != 6 && gate != 38)) {
                    visit.forceCompleteBankDataentry();
                }
                if (visit.isIncomplemteDataroom() && (command != 176 || gate != 100 && gate != 101 && gate != 98 && gate != 99)) {
                    visit.forceCompleteBankDataroom();
                }
            }
            if (message.isMessageTypeChannel()) {
                int channel = message.getChannel();
                if (message.getCommand() == 128) {
                    this._noteOff.notifyNoteOffEvent(this.assigned(), message._traceNumber, channel, message.getGate(), "@7");
                    return;
                }
                if (message.getCommand() == 144 && message.getValue() == 0) {
                    this._noteOff.notifyNoteOffEvent(this.assigned(), message._traceNumber, channel, message.getGate(), "@6");
                    return;
                }
                this.dispatchMainPath(message);
                if (message.getCommand() == 144) {
                    int note = message.getGate();
                    this._noteOff.addListener(message, null, new MXNoteOffWatcher.Handler(){

                        @Override
                        public void onNoteOffEvent(MXMessage target, MXTraceNumber trace) {
                            target._traceNumber = trace;
                            MXMIDIIn.this.dispatchMainPath(target);
                        }
                    });
                } else if (message.getCommand() == 176 && message.getGate() == 123) {
                    this._noteOff.allNoteOff(message._traceNumber);
                } else if (message.getCommand() == 176 && message.getGate() == 120) {
                    this._noteOff.allNoteOff(message._traceNumber);
                }
            } else {
                this.dispatchMainPath(message);
            }
        }
    }

    public void dispatchMainPath(MXMessage message) {
        MXMain main = MXMain.getMain();
        if (main.getMasterKeys() != null && main.getMasterKeys().isAvail() && message.isMessageTypeChannel()) {
            boolean force = false;
            if (main.getMasterKeys().isAcceptInputPanelSignal() && this.isToMaster(message.getChannel())) {
                main.getMasterKeys().processMXMessage(message);
                force = true;
            }
            if (!force && main.getMasterKeys().isAcceptThisPageSignal() && message.getPort() == main.getMasterKeys().getMousePort() && message.getChannel() == main.getMasterKeys().getMouseChannel()) {
                main.getMasterKeys().processMXMessage(message);
                force = true;
            }
            if (force) {
                return;
            }
        }
        if (this.lastSent != Thread.currentThread()) {
            this.lastSent = Thread.currentThread();
            Thread.currentThread().setPriority(10);
            System.out.println("Thread MAX");
        }
        MXMain.getMain().dispatchMainPath(message);
    }
}

