/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.capture;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.MXWrap;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXMessageTemplate;
import jp.synthtarou.midimixer.libs.midi.MXTraceNumber;
import jp.synthtarou.midimixer.libs.midi.capture.GateInfomation;
import jp.synthtarou.midimixer.libs.midi.capture.MXMessageCapture;

public class MXMessageCapturePanel
extends JPanel {
    private static final MXDebugLines _debug = new MXDebugLines(MXMessageCapturePanel.class);
    public GateInfomation _selected = null;
    MXMessageCapture _capture = null;
    WindowListener _adater = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            MXMain.setCapture(null);
        }
    };
    MXWrapList<GateInfomation> _templateModel = null;
    Thread tick = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JList<String> jList1;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldCommandText;
    private JToggleButton jToggleBuittonScan;

    public MXMessageCapturePanel() {
        this.initComponents();
        this.startCapture();
        this.setPreferredSize(new Dimension(600, 400));
        this.startCapture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCapture() {
        this.jToggleBuittonScan.setSelected(false);
        if (this.tick != null) {
            Thread thread = this.tick;
            synchronized (thread) {
                this.tick.interrupt();
            }
            this.tick = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCapture() {
        this.jToggleBuittonScan.setSelected(true);
        if (this.tick != null) {
            Thread thread = this.tick;
            synchronized (thread) {
                this.tick.interrupt();
            }
            this.tick = null;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.tick = new TickThread();
        this.tick.start();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.jToggleBuittonScan = new JToggleButton();
        this.jTextFieldCommandText = new JTextField();
        this.setLayout(new GridBagLayout());
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MXMessageCapturePanel.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MXMessageCapturePanel.this.jButtonOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jButtonOK, gridBagConstraints);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MXMessageCapturePanel.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jButtonCancel, gridBagConstraints);
        this.jLabel1.setText("Lets SCAN");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jToggleBuittonScan.setText("Scan");
        this.jToggleBuittonScan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MXMessageCapturePanel.this.jToggleBuittonScanActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jToggleBuittonScan, gridBagConstraints);
        this.jTextFieldCommandText.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jTextFieldCommandText, gridBagConstraints);
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        int x = this.jList1.getSelectedIndex();
        if (x >= 0) {
            MXWrap wrap = (MXWrap)this._templateModel.get(x);
            this._selected = (GateInfomation)wrap.value;
            MXUtil.getOwnerWindow(this).setVisible(false);
            MXMain.setCapture(null);
            MXUtil.closeOwnerWindow(this);
        } else {
            JOptionPane.showMessageDialog(this, "Choose 1 from List", "Please", 0);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this._selected = null;
        MXUtil.getOwnerWindow(this).setVisible(false);
        MXMain.setCapture(null);
        MXUtil.closeOwnerWindow(this);
    }

    private void jToggleBuittonScanActionPerformed(ActionEvent evt) {
        if (this.jToggleBuittonScan.isSelected()) {
            this.startCapture();
        } else {
            this.stopCapture();
        }
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        int x = this.jList1.getSelectedIndex();
        if (x >= 0) {
            try {
                MXWrap wrap = (MXWrap)this._templateModel.get(x);
                int channel = ((GateInfomation)wrap.value)._parent.channel;
                String dtext = ((GateInfomation)wrap.value)._parent.dtext;
                int gate = ((GateInfomation)wrap.value)._gate;
                int min = ((GateInfomation)wrap.value)._minValue;
                int max = ((GateInfomation)wrap.value)._maxValue;
                MXMessageTemplate template = MXMessageFactory.fromDtext(dtext, channel);
                MXMessage msg = template.bind(new MXTraceNumber(), 0, gate, max);
                msg.setChannel(0);
                String text = msg.toStringHeader(min, max);
                this.jTextFieldCommandText.setText(text);
            }
            catch (Exception e) {
                this.jTextFieldCommandText.setText("Error");
            }
        }
    }

    public class TickThread
    extends Thread {
        long _startTick = System.currentTimeMillis();
        int _age;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this._age = -1;
            MXMessageCapturePanel.this._capture = new MXMessageCapture();
            try {
                MXMain.setCapture(MXMessageCapturePanel.this._capture);
                while (true) {
                    MXMessageCapture mXMessageCapture = MXMessageCapturePanel.this._capture;
                    synchronized (mXMessageCapture) {
                        try {
                            MXMessageCapturePanel.this._capture.wait(1000L);
                        }
                        catch (InterruptedException e) {
                            // MONITOREXIT @DISABLED, blocks:[0, 5, 6, 9] lbl12 : MonitorExitStatement: MONITOREXIT : var1_2
                            MXMain.setCapture(null);
                            return;
                        }
                    }
                    long spent = System.currentTimeMillis() - this._startTick;
                    if ((spent /= 1000L) >= 30L) {
                        MXMessageCapturePanel.this.jLabel1.setText("Done Scan ... 30 / 30 sec");
                        return;
                    }
                    MXMessageCapturePanel.this.jLabel1.setText("Scanning All Input ... " + spent + " / 30 sec");
                    if (this._age == MXMessageCapturePanel.this._capture.getAge()) continue;
                    this._age = MXMessageCapturePanel.this._capture.age;
                    MXMessageCapturePanel.this._templateModel = MXMessageCapturePanel.this._capture.createListModel();
                    MXMessageCapturePanel.this.jList1.setModel(MXMessageCapturePanel.this._templateModel);
                }
            }
            finally {
                MXMain.setCapture(null);
            }
        }
    }
}

