/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi;

import javax.swing.JComponent;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.midi.MXMessage;

public abstract class MXReceiver {
    private static final MXDebugLines _debug = new MXDebugLines(MXReceiver.class);
    private static MXMain _lock = MXMain.getMain();
    private MXReceiver _nextReceiver;
    boolean _usingThis = true;

    public abstract String getReceiverName();

    public abstract JComponent getReceiverView();

    public final MXReceiver getNextReceiver() {
        return this._nextReceiver;
    }

    public void setNextReceiver(MXReceiver next) {
        this._nextReceiver = next;
    }

    public abstract void processMXMessage(MXMessage var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToNext(MXMessage message) {
        if (this._nextReceiver != null) {
            MXMain mXMain = _lock;
            synchronized (mXMain) {
                this._nextReceiver.processMXMessage(message);
            }
        } else {
            _debug.println("receiver not set " + message);
            _debug.printStackTrace();
        }
    }

    public final boolean isUsingThisRecipe() {
        return this._usingThis;
    }

    public final void setUsingThisRecipe(boolean usingThis) {
        this._usingThis = usingThis;
    }
}

