/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXTraceNumber;

public class MXNoteOffWatcher {
    private static final MXDebugLines _debug = new MXDebugLines(MXNoteOffWatcher.class);
    Object lock = MXMain.getMain();
    private LinkedList<Element> _list = new LinkedList();
    Handler _lastHandler;

    public String toString() {
        return "(MXNoteOff + " + this._list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(MXMessage noteOn, MXMessage noteOff, Handler listener) {
        Object object = this.lock;
        synchronized (object) {
            if (noteOff == null) {
                noteOff = noteOn;
            }
            return this.addListener(noteOn, noteOff, listener, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(MXMessage noteOn, MXMessage noteOff, Handler listener, String dolog) {
        Object object = this.lock;
        synchronized (object) {
            if (noteOn.getCommand() != 144) {
                _debug.println("Its not note on " + noteOn);
                return false;
            }
            this._lastHandler = listener;
            Element e = new Element();
            e.caughtNoteOn = noteOn;
            e.sendingNoteOff = noteOff;
            e.listener = listener;
            this._list.add(e);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allNoteOff(MXTraceNumber trace) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<Element> list = new ArrayList<Element>(this._list);
            this._list.clear();
            for (Element e : list) {
                MXMessage base = e.sendingNoteOff;
                MXMessage msg = MXMessageFactory.fromShortMessage(base.getPort(), trace, 128 + base.getChannel(), base.getGate(), 0);
                e.listener.onNoteOffEvent(msg, trace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyNoteOffEvent(int port, MXTraceNumber traceNumber, int ch, int note) {
        Object object = this.lock;
        synchronized (object) {
            return this.notifyNoteOffEvent(port, traceNumber, ch, note, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyNoteOffEvent(int port, MXTraceNumber traceNumber, int ch, int note, String dolog) {
        Object object = this.lock;
        synchronized (object) {
            boolean proc = false;
            boolean saveProc = false;
            do {
                proc = false;
                Iterator it = this._list.iterator();
                while (it.hasNext()) {
                    Element e = (Element)it.next();
                    if (e.caughtNoteOn.getPort() != port || e.caughtNoteOn.getChannel() != ch || e.caughtNoteOn.getData1() != note) continue;
                    MXMessage noteOff = MXMessageFactory.fromShortMessage(port, traceNumber, 128 + ch, note, 0);
                    e.listener.onNoteOffEvent(noteOff, traceNumber);
                    it.remove();
                    proc = true;
                }
                if (!proc) continue;
                saveProc = true;
            } while (proc);
            return saveProc;
        }
    }

    public static interface Handler {
        public void onNoteOffEvent(MXMessage var1, MXTraceNumber var2);
    }

    private static class Element {
        MXMessage caughtNoteOn;
        MXMessage sendingNoteOff;
        Handler listener;

        private Element() {
        }
    }
}

