/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi;

import java.util.ArrayList;
import java.util.HashSet;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.midi.MXException;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageTemplate;
import jp.synthtarou.midimixer.libs.midi.MXTraceNumber;

public class MXMessageFactory {
    private static final MXDebugLines _debug = new MXDebugLines(MXMessageFactory.class);
    static HashSet<String> debugUnique;

    public static MXMessage createDummy() {
        return new MXMessage(0, new MXTraceNumber(), new MXMessageTemplate(null), 0, 0);
    }

    public static MXMessage fromClone(MXTraceNumber trace, MXMessage old) {
        MXMessage msg = (MXMessage)old.clone();
        msg._traceNumber = trace;
        return msg;
    }

    public static MXMessage fromDWordMessage(int port, MXTraceNumber traceNumber, int dword) {
        int status = dword >> 8 >> 8 & 0xFF;
        int data1 = dword >> 8 & 0xFF;
        int data2 = dword & 0xFF;
        return MXMessageFactory.fromShortMessage(port, traceNumber, status, data1, data2);
    }

    public static MXMessage fromMeta(int port, MXTraceNumber traceNumber, int metaType, byte[] data) {
        int[] template = new int[data.length + 2];
        template[0] = 255;
        template[1] = metaType;
        for (int i = 0; i < data.length; ++i) {
            template[i + 2] = data[i] & 0xFF;
        }
        MXMessage message = new MXMessage(port, traceNumber, template, 0, 0);
        message.setMetaType(metaType);
        String text = null;
        try {
            text = new String(data, "ASCII");
            text = new String(data);
            text = new String(data, "SJIS");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        message._metaText = text;
        message._dataBytes = data;
        return message;
    }

    public static MXMessage fromSysexMessage(int port, MXTraceNumber traceNumber, int status, byte[] data) {
        int[] template = new int[data.length + 1];
        template[0] = status;
        if (status != 240 && status != 247) {
            new MXException("SysEx(240,247) was " + status).printStackTrace();
        }
        for (int i = 0; i < data.length; ++i) {
            template[i + 1] = data[i] & 0xFF;
        }
        MXMessage m = new MXMessage(port, traceNumber, template, 0, 0);
        return m;
    }

    public static MXMessage fromShortMessage(int port, MXTraceNumber traceNumber, int status, int data1, int data2) {
        if (debugUnique != null) {
            if ((status & 0xF0) == 144 && data2 > 0) {
                debugUnique.add(String.valueOf(traceNumber));
            } else if ((status & 0xF0) == 144 && data2 == 0) {
                if (debugUnique.contains(String.valueOf(traceNumber))) {
                    new Throwable("Contains").printStackTrace();
                }
            } else if ((status & 0xF0) == 128 && debugUnique.contains(String.valueOf(traceNumber))) {
                new Throwable("Contains").printStackTrace();
            }
        }
        int command = status;
        int channel = 0;
        if (status >= 128 && status <= 224) {
            command = status & 0xF0;
            channel = status & 0xF;
        }
        if (command < 0 || command > 255) {
            _debug.println("command = " + command);
            return null;
        }
        if (channel < 0 || channel > 15) {
            _debug.println("channel= " + channel);
            return null;
        }
        if (data1 < 0 || data1 > 127) {
            _debug.println("data1 = " + data1);
            return null;
        }
        if (data2 < 0 || data2 > 127) {
            _debug.println("data2 = " + data2);
            return null;
        }
        int gate = 0;
        int value = 0;
        switch (command) {
            case 192: {
                gate = data1;
                value = 0;
                data1 = 1024;
                data2 = 0;
                break;
            }
            case 176: {
                gate = data1;
                value = data2;
                data1 = 1024;
                data2 = 512;
                break;
            }
            case 128: 
            case 144: 
            case 160: {
                gate = data1;
                value = data2;
                data1 = 1024;
                data2 = 512;
                break;
            }
            case 224: {
                value = data1 & 0x7F | data2 << 7;
                data1 = 512;
                data2 = 768;
                break;
            }
            case 208: {
                value = data1;
                data1 = 512;
                break;
            }
            default: {
                if (command < 240 || command > 247) break;
                if (command == 242) {
                    value = data1 & 0x7F | data2 << 7;
                    data1 = 512;
                    data2 = 768;
                }
                if (command != 243) break;
                value = data1;
                data1 = 512;
            }
        }
        int[] template = new int[]{status, data1, data2};
        MXMessage message = new MXMessage(port, traceNumber, template, gate, value);
        message.setChannel(channel);
        return message;
    }

    public static MXMessage fromBinary(int port, MXTraceNumber traceNumber, byte[] data) {
        if (data == null || data.length == 0 || data[0] == 0) {
            return null;
        }
        int[] template = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            template[i] = data[i] & 0xFF;
        }
        try {
            MXMessage ret = new MXMessage(port, traceNumber, template, 0, 0);
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MXMessageTemplate fromDtext(String text, int channel) {
        if (text == null || text.length() == 0) {
            return null;
        }
        while (text.startsWith(" ")) {
            text = text.substring(1);
        }
        while (text.endsWith(" ")) {
            text = text.substring(0, text.length() - 1);
        }
        if (text.equals("@PROG_INC")) {
            int[] template = new int[]{20480, channel};
            return new MXMessageTemplate(template);
        }
        if (text.equals("@PROG_DEC")) {
            int[] template = new int[]{20736, channel};
            return new MXMessageTemplate(template);
        }
        try {
            char[] line = text.toCharArray();
            char[] word = new char[line.length];
            int wx = 0;
            int readX = 0;
            ArrayList<String> separated = new ArrayList<String>();
            boolean inChecksum = false;
            int checksumKeep = -1;
            while (readX < line.length) {
                char ch;
                if ((ch = line[readX++]) == '[') {
                    inChecksum = true;
                    checksumKeep = 0;
                    continue;
                }
                if (ch == ']') {
                    if (inChecksum) {
                        inChecksum = false;
                        if (wx != 0) {
                            separated.add(new String(word, 0, wx));
                        }
                        separated.add("#CHECKSUM");
                        wx = 0;
                        continue;
                    }
                    _debug.println("Checksum have not opened");
                    _debug.printStackTrace();
                    continue;
                }
                if (ch == ' ' || ch == '\t' || ch == ',') {
                    if (wx != 0) {
                        separated.add(new String(word, 0, wx));
                        if (inChecksum) {
                            ++checksumKeep;
                        }
                    }
                    wx = 0;
                    continue;
                }
                word[wx++] = ch;
            }
            if (wx != 0) {
                separated.add(new String(word, 0, wx));
                if (inChecksum) {
                    ++checksumKeep;
                }
                wx = 0;
            }
            int gatetemp = -1;
            if (text.contains("@")) {
                ArrayList<String> sepa2 = new ArrayList<String>();
                for (int sx = 0; sx < separated.size(); ++sx) {
                    String str = (String)separated.get(sx);
                    if (str.startsWith("@")) {
                        String t;
                        if (str.equalsIgnoreCase("@PB")) {
                            sepa2.add("#ECH");
                            sepa2.add((String)separated.get(++sx));
                            sepa2.add((String)separated.get(++sx));
                            continue;
                        }
                        if (str.equalsIgnoreCase("@CP")) {
                            sepa2.add("#DCH");
                            sepa2.add((String)separated.get(++sx));
                            sepa2.add("#NONE");
                            continue;
                        }
                        if (str.equalsIgnoreCase("@PKP")) {
                            sepa2.add("#ACH");
                            t = (String)separated.get(++sx);
                            if (t.startsWith("#")) {
                                sepa2.add(t);
                            } else {
                                gatetemp = MXUtil.parseTextForNumber(t);
                                sepa2.add("#GL");
                            }
                            sepa2.add((String)separated.get(++sx));
                            continue;
                        }
                        if (str.equalsIgnoreCase("@CC")) {
                            sepa2.add("#BCH");
                            t = (String)separated.get(++sx);
                            if (t.startsWith("#")) {
                                sepa2.add(t);
                            } else {
                                gatetemp = MXUtil.parseTextForNumber(t);
                                sepa2.add("#GL");
                            }
                            if (separated.size() <= ++sx) {
                                return null;
                            }
                            sepa2.add((String)separated.get(sx));
                            continue;
                        }
                        if (str.equalsIgnoreCase("@SYSEX")) continue;
                        if (str.equalsIgnoreCase("@RPN")) {
                            int msb = MXMessageTemplate.readAliasText((String)separated.get(++sx));
                            int lsb = MXMessageTemplate.readAliasText((String)separated.get(++sx));
                            int data = MXMessageTemplate.readAliasText((String)separated.get(++sx));
                            if (separated.size() >= sx + 2) {
                                data <<= 7;
                                data |= MXMessageTemplate.readAliasText((String)separated.get(++sx));
                            }
                            int[] template = new int[]{16384, msb, lsb, data};
                            return new MXMessageTemplate(template);
                        }
                        if (str.equalsIgnoreCase("@NRPN")) {
                            int msb = MXMessageTemplate.readAliasText((String)separated.get(++sx));
                            int lsb = MXMessageTemplate.readAliasText((String)separated.get(++sx));
                            int data = MXMessageTemplate.readAliasText((String)separated.get(++sx));
                            if (separated.size() >= sx + 2) {
                                data <<= 7;
                                data |= MXMessageTemplate.readAliasText((String)separated.get(++sx));
                            }
                            int[] template = new int[]{16640, msb, lsb, data};
                            return new MXMessageTemplate(template);
                        }
                        _debug.println("Not Support [" + text + "]");
                        return null;
                    }
                    sepa2.add(str);
                }
                separated = sepa2;
            }
            int[] compiled = new int[line.length];
            boolean cx = false;
            int px = 0;
            for (int sx = 0; sx < separated.size(); ++sx) {
                String str = (String)separated.get(sx);
                int code = MXMessageTemplate.readAliasText(str);
                if (code < 0) {
                    return null;
                }
                compiled[px++] = code;
            }
            int[] template = new int[Math.max(px, 3)];
            for (int i = 0; i < px; ++i) {
                template[i] = compiled[i];
            }
            MXMessageTemplate temp = new MXMessageTemplate(template);
            temp._checksumTo = checksumKeep;
            return temp;
        }
        catch (Exception e) {
            _debug.printStackTrace(e);
            return null;
        }
    }

    static {
        _debug.switchOn();
        debugUnique = null;
    }
}

