/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.domino.unreach;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXTest
extends DefaultHandler {
    boolean startItem = false;
    ArrayList<String> path = new ArrayList();
    DocumentBuilder builder;
    Document document;
    ArrayList<Element> pathOut = new ArrayList();

    public SAXTest() {
        try {
            this.builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
            System.out.println("\u4fdd\u5b58\u3067\u304d\u307e\u305b\u3093");
            return;
        }
        this.document = this.builder.newDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException {
        MXDebugLines.globalSwitchOn();
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = saxParserFactory.newSAXParser();
        try (FileInputStream stream = new FileInputStream("c:/java/receipt_complex.xml");){
            InputSource source = new InputSource(stream);
            SAXTest test = new SAXTest();
            saxParser.parse(source, (DefaultHandler)test);
            SAXTest.writeDocument(new File("c:/java/recepi2.xml"), test.document);
        }
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.path.add(qName);
        System.out.println(this.path);
        Element element = this.document.createElement(qName);
        if (this.pathOut.size() == 0) {
            this.document.appendChild(element);
        } else {
            this.pathOut.get(this.pathOut.size() - 1).appendChild(element);
        }
        this.pathOut.add(element);
        if (attributes.getLength() > 0) {
            System.out.print("attr = ");
            for (int i = 0; i < attributes.getLength(); ++i) {
                String aName = attributes.getQName(i);
                String aValue = attributes.getValue(i);
                System.out.print("[" + aName + "]=[" + aValue + "]");
                element.setAttribute(aName, aValue);
            }
            System.out.println("");
        }
        if (qName.equals("shop")) {
            this.startItem = true;
            return;
        }
        if (qName.equals("item")) {
            this.startItem = true;
            return;
        }
    }

    @Override
    public void characters(char[] ch, int offset, int length) {
        StringBuffer text = new StringBuffer();
        text.append(ch, offset, length);
        while (text.length() > 0) {
            char c = text.charAt(0);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                text.deleteCharAt(0);
                continue;
            }
            c = text.charAt(text.length() - 1);
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n') break;
            text.deleteCharAt(text.length() - 1);
        }
        if (text.length() > 0) {
            System.out.println(this.path + "'s TEXT=[" + text + "]");
            this.pathOut.get(this.pathOut.size() - 1).setTextContent(text.toString());
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (this.path.size() > 0) {
            if (this.path.get(this.path.size() - 1).equals(qName)) {
                this.path.remove(this.path.size() - 1);
                this.pathOut.remove(this.pathOut.size() - 1);
            } else {
                System.out.println("XML ERROR " + qName);
            }
        } else {
            System.out.println("XML ERROR " + qName);
        }
        this.startItem = false;
    }

    @Override
    public void endDocument() {
    }

    public static boolean writeDocument(File file, Document doc) {
        Transformer tf = null;
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            tf = factory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            return false;
        }
        tf.setOutputProperty("indent", "yes");
        tf.setOutputProperty("encoding", "UTF-8");
        try {
            tf.transform(new DOMSource(doc), new StreamResult(file));
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

