/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.MXWrap;

public class MXWrapList<T>
extends ArrayList<MXWrap<T>>
implements ListModel,
ComboBoxModel {
    private static final MXDebugLines _debug = new MXDebugLines(MXWrapList.class);
    boolean _ignoreCase = false;
    List<ListDataListener> _listeners = new ArrayList<ListDataListener>();
    Object _selected = null;

    public boolean ignoreCase() {
        return this._ignoreCase;
    }

    public void setIgnoreCase(boolean ignore) {
        this._ignoreCase = ignore;
    }

    public List<String> nameList() {
        ArrayList<String> list = new ArrayList<String>();
        for (MXWrap e : this) {
            list.add(e.name);
        }
        return list;
    }

    public List<T> valueList() {
        ArrayList list = new ArrayList();
        for (MXWrap e : this) {
            list.add(e.value);
        }
        return list;
    }

    public String nameOfIndex(int x) {
        return ((MXWrap)this.get((int)x)).name;
    }

    public boolean existsName(String name) {
        if (this._ignoreCase) {
            for (MXWrap e : this) {
                if (!e.name.equalsIgnoreCase(name)) continue;
                return true;
            }
            return false;
        }
        for (MXWrap e : this) {
            if (!e.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    public int indexOfName(String name) {
        if (this._ignoreCase) {
            int x = 0;
            for (MXWrap e : this) {
                if (e.name.equalsIgnoreCase(name)) {
                    return x;
                }
                ++x;
            }
            return -1;
        }
        int x = 0;
        for (MXWrap e : this) {
            if (e.name.equals(name)) {
                return x;
            }
            ++x;
        }
        return -1;
    }

    public T valueOfIndex(int x) {
        return ((MXWrap)this.get((int)x)).value;
    }

    public T valueOfName(String name) {
        int x = this.indexOfName(name);
        if (x < 0) {
            return null;
        }
        return ((MXWrap)this.get((int)x)).value;
    }

    public int indexOfValue(T value) {
        int x = 0;
        for (MXWrap e : this) {
            if (e.value == value) {
                return x;
            }
            ++x;
        }
        x = 0;
        for (MXWrap e : this) {
            if (e.value != null && value != null && e.value.equals(value)) {
                return x;
            }
            ++x;
        }
        return -1;
    }

    public boolean addNameAndValue(String name, T value) {
        return this.add(new MXWrap<T>(name, value));
    }

    @Override
    public boolean add(MXWrap<T> value) {
        boolean x = super.add(value);
        return x;
    }

    @Override
    public int getSize() {
        return this.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this._listeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this._listeners.remove(l);
    }

    @Override
    public void setSelectedItem(Object o) {
        this._selected = o;
    }

    @Override
    public Object getSelectedItem() {
        if (this._selected == null && this.size() > 0) {
            this._selected = this.get(0);
        }
        return this._selected;
    }

    public T readCombobox(JComboBox box) {
        ComboBoxModel model = box.getModel();
        MXWrap item = (MXWrap)model.getSelectedItem();
        if (item != null) {
            return item.value;
        }
        return null;
    }

    public void writeComboBox(JComboBox box, T value) {
        MXWrapList model = this;
        box.setModel(this);
        for (int i = 0; i < model.getSize(); ++i) {
            MXWrap item = (MXWrap)model.getElementAt(i);
            if (item == null) continue;
            if (value.getClass().isPrimitive()) {
                if (item.value != value) continue;
                box.setSelectedIndex(i);
                return;
            }
            if (item.value == null && value == null) {
                box.setSelectedIndex(i);
                return;
            }
            if (item.value == null || value == null || !item.value.equals(value)) continue;
            box.setSelectedIndex(i);
            return;
        }
    }
}

