/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jp.synthtarou.midimixer.mx30controller.MGCircle;
import jp.synthtarou.midimixer.mx30controller.MGPad;
import jp.synthtarou.midimixer.mx30controller.MGSlider;

public class MXUtil {
    public static String toHexFF(int i) {
        String str = Integer.toHexString(i).toUpperCase();
        if (str.length() == 1) {
            return "0" + str;
        }
        if (str.length() >= 3) {
            return str.substring(str.length() - 2, str.length());
        }
        return str;
    }

    public static String dumpHexFF(byte[] data) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            if (i != 0) {
                str.append(" ");
            }
            str.append(MXUtil.toHexFF(data[i]));
        }
        return str.toString();
    }

    public static final int parseTextForNumber(String text) {
        int ch;
        int x = 0;
        int start = 0;
        int mum = 10;
        if (text == null) {
            return -1;
        }
        if (text.startsWith("0x")) {
            text = text.substring(2);
            mum = 16;
        }
        if (text.endsWith("h") || text.endsWith("H")) {
            text = text.substring(0, text.length() - 1);
            mum = 16;
        }
        for (start = 0; start < text.length() && ((ch = text.charAt(start)) == 32 || ch == 9 || ch == 10); ++start) {
        }
        if (start >= text.length()) {
            return -1;
        }
        while (start < text.length()) {
            ch = text.charAt(start) & 0xFF;
            if (ch >= 48 && ch <= 57) {
                x *= mum;
                x += ch - 48;
            } else if (ch >= 65 && ch <= 70 && mum == 16) {
                x *= mum;
                x += ch - 65 + 10;
            } else {
                if (ch < 97 || ch > 102 || mum != 16) break;
                x *= mum;
                x += ch - 97 + 10;
            }
            ++start;
        }
        return x;
    }

    public static boolean searchTextIgnoreCase(String text, String words) {
        text = text.toLowerCase();
        if ((words = words.toLowerCase()).indexOf(32) < 0) {
            return text.indexOf(words) >= 0;
        }
        ArrayList<String> cells = new ArrayList<String>();
        MXUtil.split(words, cells, ' ');
        for (String parts : cells) {
            if (text.indexOf(parts) >= 0) continue;
            return false;
        }
        return true;
    }

    public static void swingTreeEnable(Component c, boolean enable) {
        if (c instanceof Container) {
            Container parent = (Container)c;
            int count = parent.getComponentCount();
            for (int x = 0; x < count; ++x) {
                MXUtil.swingTreeEnable(parent.getComponent(x), enable);
            }
        }
        if (c instanceof JComponent) {
            ((JComponent)c).setEnabled(enable);
        }
    }

    public static void swingTreeEditable(Component c, boolean enable) {
        if (c instanceof Container) {
            Container parent = (Container)c;
            int count = parent.getComponentCount();
            for (int x = 0; x < count; ++x) {
                MXUtil.swingTreeEditable(parent.getComponent(x), enable);
            }
        }
        if (c instanceof MGCircle) {
            MGCircle circle = (MGCircle)c;
            circle.setValueChangeable(enable);
        }
        if (c instanceof MGSlider) {
            MGSlider slider = (MGSlider)c;
            slider.setValueChangeable(enable);
        }
        if (c instanceof MGPad) {
            MGPad pad = (MGPad)c;
            pad.setValueChangeable(enable);
        }
    }

    public static void showAsDialog(Container parent, JPanel panel, String title) {
        Container cont = MXUtil.getOwnerWindow(parent);
        if (title == null) {
            title = "MIX Recipe 0.25";
        }
        JDialog dialog = null;
        if (cont instanceof Window) {
            Window W = (Window)cont;
            dialog = new JDialog(W, title);
        } else if (cont instanceof Dialog) {
            Dialog D = (Dialog)cont;
            dialog = new JDialog(D, title);
        } else {
            dialog = new JDialog((Window)parent, title);
        }
        dialog.setModal(true);
        dialog.getContentPane().add((Component)panel, "Center");
        dialog.pack();
        MXUtil.centerWindow(dialog);
        dialog.setVisible(true);
    }

    public static void closeOwnerWindow(Component c) {
        while (c != null && (c = c.getParent()) != null) {
            if (!(c instanceof Dialog) && !(c instanceof Window)) continue;
            c.setVisible(false);
            return;
        }
    }

    public static void centerWindow(Component c) {
        Container parent;
        Window owner;
        Window window = owner = c instanceof Window ? ((Window)c).getOwner() : null;
        if (owner != null && !owner.isVisible()) {
            owner = null;
        }
        Container container = parent = owner != null ? owner : c.getParent();
        if (parent != null && !parent.isVisible()) {
            parent = null;
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension mySize = c.getSize();
        Point loc = new Point(0, 0);
        if (parent != null) {
            screenSize = parent.getSize();
            if (parent == owner) {
                loc = owner.getLocation();
            }
        }
        loc.x += (screenSize.width - mySize.width) / 2;
        loc.y += (screenSize.height - mySize.height) / 2;
        c.setLocation(loc);
    }

    public static void autoResizeTableColumnWidth(JTable table) {
        table.setAutoResizeMode(0);
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            int width = 10;
            for (int row = -1; row < table.getRowCount(); ++row) {
                TableCellRenderer renderer;
                if (row < 0) {
                    renderer = table.getTableHeader().getDefaultRenderer();
                    TableColumnModel model = table.getColumnModel();
                    TableColumn col = model.getColumn(column);
                    col.getHeaderValue();
                    Component r = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, column);
                    if (r instanceof Component) {
                        Component comp = r;
                        width = Math.max(comp.getPreferredSize().width + 30, width);
                        continue;
                    }
                    width = 50;
                    continue;
                }
                renderer = table.getCellRenderer(row, column);
                Component comp = table.prepareRenderer(renderer, row, column);
                width = Math.max(comp.getPreferredSize().width + 30, width);
            }
            if (width > 300) {
                width = 300;
            }
            columnModel.getColumn(column).setPreferredWidth(width);
        }
    }

    public static Container getOwnerWindow(Component panel) {
        while (panel != null) {
            if (panel instanceof Window) {
                return (Window)panel;
            }
            if (panel instanceof Dialog) {
                return (Dialog)panel;
            }
            panel = panel.getParent();
        }
        return null;
    }

    public static void split(String str, ArrayList<String> list, char splitter) {
        list.clear();
        int len = str.length();
        int from = 0;
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch != splitter) continue;
            list.add(str.substring(from, i));
            from = i + 1;
        }
        if (from < len) {
            list.add(str.substring(from, len));
        }
    }

    public static Color mixedColor(Color left, Color right, int percent) {
        int lr = left.getRed() * (100 - percent) / 100;
        int lg = left.getGreen() * (100 - percent) / 100;
        int lb = left.getBlue() * (100 - percent) / 100;
        int rr = right.getRed() * percent / 100;
        int rg = right.getGreen() * percent / 100;
        int rb = right.getBlue() * percent / 100;
        return new Color(lr + rr, lg + rg, lb + rb);
    }

    public static void backgroundRecursive(Container container, Color color) {
        LinkedList<Container> listContainer = new LinkedList<Container>();
        listContainer.add(container);
        while (!listContainer.isEmpty()) {
            Component[] list;
            Container cont = (Container)listContainer.remove();
            if (cont == null) continue;
            cont.setBackground(color);
            for (Component child : list = cont.getComponents()) {
                if (child instanceof Container) {
                    listContainer.add((Container)child);
                    continue;
                }
                child.setBackground(color);
            }
        }
    }
}

