/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs;

import java.io.PrintStream;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;

public class MXDebugLines {
    private static final MXDebugLines _debug = new MXDebugLines(MXDebugLines.class);
    private PrintStream _output = System.out;
    protected String _name;
    private boolean _switch = false;
    private static boolean _globalSwitch = false;
    private static HashSet<String> _target = new HashSet();

    public static void dumpEnv() {
        if (_debug.isDebug()) {
            Properties props = System.getProperties();
            Enumeration<Object> keys = props.keys();
            _debug.println("System.getProperties = ");
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = props.getProperty(key);
                _debug.println("    " + key + " = " + value);
            }
            Map<String, String> envs = System.getenv();
            _debug.println("System.getenv = ");
            for (String key : envs.keySet()) {
                String value = envs.get(key);
                _debug.println("    " + key + " = " + value);
            }
        }
    }

    public static void main(String[] args) {
        _debug.switchOn();
        _debug.printStackTrace();
        MXDebugLines.dumpEnv();
        MXDebugLines.test();
    }

    public static void test() {
        _debug.printStackTrace(new Throwable());
    }

    public MXDebugLines(Class cls) {
        this._name = cls.getName();
        if (this._name != null) {
            int x = this._name.lastIndexOf(46);
            if (x >= 0) {
                this._name = this._name.substring(x + 1);
            }
            if (_target == null) {
                return;
            }
            if (_target.contains(this._name)) {
                this._switch = true;
            }
        }
    }

    public boolean isDebug() {
        return _globalSwitch || this._switch;
    }

    public void println(String text) {
        if (this.isDebug()) {
            this._output.println(this._name + ": " + text);
        }
    }

    public void print(String text) {
        if (this.isDebug()) {
            this._output.print(this._name + ": " + text);
        }
    }

    public void println() {
        if (this.isDebug()) {
            this._output.println(this._name + ": ");
        }
    }

    public void printStackTrace() {
        if (this.isDebug()) {
            Throwable th = new Throwable();
            StackTraceElement[] elems = th.getStackTrace();
            this._output.println("print stack trace = ");
            for (int i = 1; i < elems.length; ++i) {
                StackTraceElement x = elems[i];
                this._output.println("    " + x);
            }
        }
    }

    public void printStackTrace(Throwable th) {
        if (this.isDebug()) {
            StackTraceElement[] elems = th.getStackTrace();
            this._output.println("print stack trace = " + th.getClass() + ":" + th.getMessage());
            for (int i = 0; i < elems.length; ++i) {
                StackTraceElement x = elems[i];
                this._output.println("    " + x);
            }
        }
    }

    public void printStackTrace(Throwable th, String text) {
        if (this.isDebug()) {
            this.println(text);
            this.printStackTrace(th);
        }
    }

    public static void initDebugLine(String[] args) {
        String debug1 = System.getenv("DEBUG");
        String debug2 = System.getProperty("DEBUG");
        Comparator<String> ignoreCase = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareToIgnoreCase(s2);
            }
        };
        TreeSet<String> test = new TreeSet<String>(ignoreCase);
        test.add("true");
        test.add("yes");
        test.add("on");
        test.add("1");
        if (debug1 != null && test.contains(debug1)) {
            _globalSwitch = true;
        } else if (debug2 != null && test.contains(debug2)) {
            _globalSwitch = true;
        } else {
            if (debug1 != null) {
                _target.add(debug1);
            }
            if (debug2 != null) {
                _target.add(debug2);
            }
        }
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase("--debug")) continue;
            _globalSwitch = true;
        }
    }

    public static void parseArgs(String[] args) {
        for (String text : args) {
            if (text.startsWith("--debug=")) {
                _target.add(text.substring(8));
                continue;
            }
            if (!text.equals("--degbug")) continue;
            _globalSwitch = true;
        }
    }

    public static void globalSwitchOn() {
        _globalSwitch = true;
    }

    public static void globalSwitchOff() {
        _globalSwitch = false;
    }

    public void switchOn() {
        this._switch = true;
    }

    public void switchOff() {
        this._switch = false;
    }
}

